/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extent.clipboard.io;

import com.boydti.fawe.config.BBC;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.object.RunnableVal;
import com.boydti.fawe.object.clipboard.AbstractClipboardFormat;
import com.boydti.fawe.object.clipboard.IClipboardFormat;
import com.boydti.fawe.object.clipboard.LazyClipboardHolder;
import com.boydti.fawe.object.clipboard.MultiClipboardHolder;
import com.boydti.fawe.object.clipboard.URIClipboardHolder;
import com.boydti.fawe.object.io.FastByteArrayOutputStream;
import com.boydti.fawe.object.io.PGZIPOutputStream;
import com.boydti.fawe.object.io.ResettableFileInputStream;
import com.boydti.fawe.object.schematic.PNGWriter;
import com.boydti.fawe.object.schematic.Schematic;
import com.boydti.fawe.object.schematic.StructureFormat;
import com.boydti.fawe.util.MainUtil;
import com.boydti.fawe.util.ReflectionUtils;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteSource;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.sk89q.jnbt.NBTConstants;
import com.sk89q.jnbt.NBTInputStream;
import com.sk89q.jnbt.NBTOutputStream;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardReader;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardWriter;
import com.sk89q.worldedit.extent.clipboard.io.SchematicReader;
import com.sk89q.worldedit.extent.clipboard.io.SpongeSchematicReader;
import com.sk89q.worldedit.extent.clipboard.io.SpongeSchematicWriter;
import com.sk89q.worldedit.session.ClipboardHolder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nullable;

public enum ClipboardFormat {
    SCHEMATIC(new AbstractClipboardFormat("SCHEMATIC", new String[]{"mcedit", "mce", "schematic"}){

        @Override
        public ClipboardReader getReader(InputStream inputStream) throws IOException {
            if (inputStream instanceof FileInputStream) {
                inputStream = new ResettableFileInputStream((FileInputStream)inputStream);
            }
            BufferedInputStream buffered = new BufferedInputStream(inputStream);
            NBTInputStream nbtStream = new NBTInputStream(new BufferedInputStream(new GZIPInputStream(buffered)));
            SchematicReader input = new SchematicReader(nbtStream);
            input.setUnderlyingStream(inputStream);
            return input;
        }

        @Override
        public ClipboardWriter getWriter(OutputStream outputStream) throws IOException {
            throw new UnsupportedOperationException("No longer supported.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isFormat(File file) {
            boolean bl;
            if (!file.getName().toLowerCase().endsWith(".schematic")) {
                return false;
            }
            FilterInputStream str = null;
            try {
                str = new DataInputStream(new GZIPInputStream(new FileInputStream(file)));
                if ((((DataInputStream)str).readByte() & 0xFF) != 10) {
                    boolean bl2 = false;
                    return bl2;
                }
                byte[] nameBytes = new byte[((DataInputStream)str).readShort() & 0xFFFF];
                ((DataInputStream)str).readFully(nameBytes);
                String name = new String(nameBytes, NBTConstants.CHARSET);
                bl = name.equals("Schematic");
            }
            catch (IOException e) {
                boolean bl3 = false;
                return bl3;
            }
            finally {
                if (str != null) {
                    try {
                        str.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return bl;
        }

        @Override
        public String getExtension() {
            return "schematic";
        }
    }),
    SPONGE_SCHEMATIC(new AbstractClipboardFormat("SPONGE", new String[]{"sponge", "schem"}){

        @Override
        public ClipboardReader getReader(InputStream inputStream) throws IOException {
            if (inputStream instanceof FileInputStream) {
                inputStream = new ResettableFileInputStream((FileInputStream)inputStream);
            }
            BufferedInputStream buffered = new BufferedInputStream(inputStream);
            NBTInputStream nbtStream = new NBTInputStream(new BufferedInputStream(new GZIPInputStream(buffered)));
            SpongeSchematicReader input = new SpongeSchematicReader(nbtStream);
            return input;
        }

        @Override
        public ClipboardWriter getWriter(OutputStream outputStream) throws IOException {
            OutputStream gzip;
            if (outputStream instanceof PGZIPOutputStream || outputStream instanceof GZIPOutputStream) {
                gzip = outputStream;
            } else {
                outputStream = new BufferedOutputStream(outputStream);
                PGZIPOutputStream pigz = new PGZIPOutputStream(outputStream);
                gzip = pigz;
            }
            NBTOutputStream nbtStream = new NBTOutputStream(new BufferedOutputStream(gzip));
            return new SpongeSchematicWriter(nbtStream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isFormat(File file) {
            boolean bl;
            if (!file.getName().toLowerCase().endsWith(".schem")) {
                return false;
            }
            FilterInputStream str = null;
            try {
                str = new DataInputStream(new GZIPInputStream(new FileInputStream(file)));
                if ((((DataInputStream)str).readByte() & 0xFF) != 10) {
                    boolean bl2 = false;
                    return bl2;
                }
                byte[] nameBytes = new byte[((DataInputStream)str).readShort() & 0xFFFF];
                ((DataInputStream)str).readFully(nameBytes);
                String name = new String(nameBytes, NBTConstants.CHARSET);
                bl = name.equals("Schematic");
            }
            catch (IOException e) {
                boolean bl3 = false;
                return bl3;
            }
            finally {
                if (str != null) {
                    try {
                        str.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return bl;
        }

        @Override
        public String getExtension() {
            return "schem";
        }
    }),
    STRUCTURE(new AbstractClipboardFormat("STRUCTURE", new String[]{"structure", "nbt"}){

        @Override
        public ClipboardReader getReader(InputStream inputStream) throws IOException {
            inputStream = new BufferedInputStream(inputStream);
            NBTInputStream nbtStream = new NBTInputStream(new BufferedInputStream(new GZIPInputStream(inputStream)));
            return new StructureFormat(nbtStream);
        }

        @Override
        public ClipboardWriter getWriter(OutputStream outputStream) throws IOException {
            OutputStream gzip;
            if ((outputStream = new BufferedOutputStream(outputStream)) instanceof PGZIPOutputStream || outputStream instanceof GZIPOutputStream) {
                gzip = outputStream;
            } else {
                PGZIPOutputStream pigz = new PGZIPOutputStream(outputStream);
                gzip = pigz;
            }
            NBTOutputStream nbtStream = new NBTOutputStream(new BufferedOutputStream(gzip));
            return new StructureFormat(nbtStream);
        }

        @Override
        public boolean isFormat(File file) {
            return file.getName().endsWith(".nbt");
        }

        @Override
        public String getExtension() {
            return "nbt";
        }
    }),
    PNG(new AbstractClipboardFormat("PNG", new String[]{"png", "image"}){

        @Override
        public ClipboardReader getReader(InputStream inputStream) throws IOException {
            return null;
        }

        @Override
        public ClipboardWriter getWriter(OutputStream outputStream) throws IOException {
            return new PNGWriter(new BufferedOutputStream(outputStream));
        }

        @Override
        public boolean isFormat(File file) {
            return file.getName().endsWith(".png");
        }

        @Override
        public String getExtension() {
            return "png";
        }
    });

    public static final ClipboardFormat[] values;
    private static final Map<String, ClipboardFormat> aliasMap;
    private IClipboardFormat format;

    private ClipboardFormat() {
    }

    private ClipboardFormat(IClipboardFormat format) {
        this.format = format;
    }

    public String getName() {
        return this.name();
    }

    public String getPrimaryFileExtension() {
        return this.getExtension();
    }

    public Set<String> getFileExtensions() {
        return Collections.singleton(this.getPrimaryFileExtension());
    }

    public URL uploadPublic(final Clipboard clipboard, String category, String user) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Vector dimensions = clipboard.getDimensions();
        map.put("width", dimensions.getX());
        map.put("height", dimensions.getY());
        map.put("length", dimensions.getZ());
        map.put("creator", user);
        Gson gson = new Gson();
        String json = gson.toJson(map);
        return MainUtil.upload(Settings.IMP.WEB.ASSETS, false, json, category, null, new RunnableVal<OutputStream>(){

            @Override
            public void run(OutputStream value) {
                ClipboardFormat.this.write(value, clipboard);
            }
        });
    }

    public MultiClipboardHolder loadAllFromInput(Actor player, String input, boolean message) throws IOException {
        Preconditions.checkNotNull((Object)player);
        Preconditions.checkNotNull((Object)input);
        WorldEdit worldEdit = WorldEdit.getInstance();
        LocalConfiguration config = worldEdit.getConfiguration();
        if (input.startsWith("url:")) {
            URL base = new URL(Settings.IMP.WEB.URL);
            input = new URL(base, "uploads/" + input.substring(4) + ".schematic").toString();
        }
        if (input.startsWith("http")) {
            URL url = new URL(input);
            URL webInterface = new URL(Settings.IMP.WEB.ASSETS);
            if (!url.getHost().equalsIgnoreCase(webInterface.getHost())) {
                if (message) {
                    BBC.WEB_UNAUTHORIZED.send(player, url);
                }
                return null;
            }
            MultiClipboardHolder clipboards = this.loadAllFromUrl(url);
            return clipboards;
        }
        if (input.contains("../") && !player.hasPermission("worldedit.schematic.load.other")) {
            if (message) {
                BBC.NO_PERM.send(player, "worldedit.schematic.load.other");
            }
            return null;
        }
        File working = worldEdit.getWorkingDirectoryFile(config.saveDir);
        File dir = new File(working, (Settings.IMP.PATHS.PER_PLAYER_SCHEMATICS ? player.getUniqueId().toString() + File.separator : "") + input);
        if (!dir.exists()) {
            dir = new File(dir + "." + this.getExtension());
        }
        if (!dir.exists()) {
            if (!input.contains("/") && !input.contains("\\") || player.hasPermission("worldedit.schematic.load.other")) {
                dir = new File(worldEdit.getWorkingDirectoryFile(config.saveDir), input);
            }
            if (!dir.exists()) {
                dir = new File(dir + "." + this.getExtension());
            }
        }
        if (!dir.exists()) {
            if (message) {
                BBC.SCHEMATIC_NOT_FOUND.send(player, input);
            }
            return null;
        }
        if (!dir.isDirectory()) {
            ByteSource source = Files.asByteSource((File)dir);
            URI uri = dir.toURI();
            return new MultiClipboardHolder(uri, new LazyClipboardHolder(dir.toURI(), source, this, null));
        }
        URIClipboardHolder[] clipboards = this.loadAllFromDirectory(dir);
        if (clipboards.length < 1) {
            if (message) {
                BBC.SCHEMATIC_NOT_FOUND.send(player, input);
            }
            return null;
        }
        return new MultiClipboardHolder(dir.toURI(), clipboards);
    }

    public URIClipboardHolder[] loadAllFromDirectory(File dir) {
        File[] files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".schematic");
            }
        });
        URIClipboardHolder[] clipboards = new LazyClipboardHolder[files.length];
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            ByteSource source = Files.asByteSource((File)file);
            clipboards[i] = new LazyClipboardHolder(file.toURI(), source, this, null);
        }
        return clipboards;
    }

    public MultiClipboardHolder loadAllFromUrl(URL url) throws IOException {
        ArrayList<LazyClipboardHolder> clipboards = new ArrayList<LazyClipboardHolder>();
        try (ReadableByteChannel rbc = Channels.newChannel(url.openStream());
             InputStream in = Channels.newInputStream(rbc);){
            try (ZipInputStream zip = new ZipInputStream(in);){
                ZipEntry entry;
                byte[] buffer = new byte[8192];
                while ((entry = zip.getNextEntry()) != null) {
                    if (!entry.getName().endsWith(".schematic")) continue;
                    FastByteArrayOutputStream out = new FastByteArrayOutputStream();
                    int len = 0;
                    while ((len = zip.read(buffer)) > 0) {
                        out.write(buffer, 0, len);
                    }
                    byte[] array = out.toByteArray();
                    ByteSource source = ByteSource.wrap((byte[])array);
                    LazyClipboardHolder clipboard = new LazyClipboardHolder(url.toURI(), source, this, null);
                    clipboards.add(clipboard);
                }
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        LazyClipboardHolder[] arr = clipboards.toArray(new LazyClipboardHolder[clipboards.size()]);
        try {
            MultiClipboardHolder multi = new MultiClipboardHolder(url.toURI());
            for (LazyClipboardHolder h : arr) {
                multi.add(h);
            }
            return multi;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private void write(OutputStream value, Clipboard clipboard) {
        try (PGZIPOutputStream gzip = new PGZIPOutputStream(value);
             ClipboardWriter writer = this.format.getWriter(gzip);){
            writer.write(clipboard);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public URL uploadAnonymous(final Clipboard clipboard) {
        return MainUtil.upload(null, null, this.format.getExtension(), new RunnableVal<OutputStream>(){

            @Override
            public void run(OutputStream value) {
                ClipboardFormat.this.write(value, clipboard);
            }
        });
    }

    public IClipboardFormat getFormat() {
        return this.format;
    }

    public Set<String> getAliases() {
        return this.format.getAliases();
    }

    public ClipboardReader getReader(InputStream inputStream) throws IOException {
        return this.format.getReader(inputStream);
    }

    public ClipboardWriter getWriter(OutputStream outputStream) throws IOException {
        return this.format.getWriter(outputStream);
    }

    public ClipboardHolder hold(Player player, URI uri, InputStream in) throws IOException {
        Preconditions.checkNotNull((Object)player);
        Preconditions.checkNotNull((Object)uri);
        Preconditions.checkNotNull((Object)in);
        ClipboardReader reader = this.getReader(in);
        LocalSession session = WorldEdit.getInstance().getSessionManager().get(player);
        session.setClipboard(null);
        Clipboard clipboard = reader.read(player.getUniqueId());
        URIClipboardHolder holder = new URIClipboardHolder(uri, clipboard);
        session.setClipboard(holder);
        return holder;
    }

    public Schematic load(File file) throws IOException {
        return this.load(new FileInputStream(file));
    }

    public Schematic load(InputStream stream) throws IOException {
        return new Schematic(this.getReader(stream).read());
    }

    public String getExtension() {
        return this.format.getExtension();
    }

    public boolean isFormat(File file) {
        return this.format.isFormat(file);
    }

    @Nullable
    public static ClipboardFormat findByAlias(String alias) {
        Preconditions.checkNotNull((Object)alias);
        return aliasMap.get(alias.toLowerCase(Locale.ENGLISH).trim());
    }

    @Nullable
    public static ClipboardFormat findByExtension(String extension) {
        Preconditions.checkNotNull((Object)extension);
        extension = extension.toLowerCase();
        for (ClipboardFormat format : values) {
            if (!format.getFileExtensions().contains(extension)) continue;
            return format;
        }
        return null;
    }

    @Nullable
    public static ClipboardFormat findByFile(File file) {
        Preconditions.checkNotNull((Object)file);
        for (ClipboardFormat format : EnumSet.allOf(ClipboardFormat.class)) {
            if (!format.isFormat(file)) continue;
            return format;
        }
        return null;
    }

    public static ClipboardFormat addFormat(IClipboardFormat instance) {
        ClipboardFormat newEnum = ReflectionUtils.addEnum(ClipboardFormat.class, instance.getName());
        newEnum.format = instance;
        for (String alias : newEnum.getAliases()) {
            aliasMap.put(alias, newEnum);
        }
        ArrayList<ClipboardFormat> newValues = new ArrayList<ClipboardFormat>(Arrays.asList(values));
        newValues.add(newEnum);
        ClipboardFormat[] newValuesArray = newValues.toArray(new ClipboardFormat[newValues.size()]);
        try {
            ReflectionUtils.setFailsafeFieldValue(ClipboardFormat.class.getDeclaredField("values"), null, newValuesArray);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return newEnum;
    }

    static {
        aliasMap = new ConcurrentHashMap<String, ClipboardFormat>(8, 0.9f, 1);
        for (ClipboardFormat emum : ClipboardFormat.values()) {
            for (String alias : emum.getAliases()) {
                aliasMap.put(alias, emum);
            }
        }
        values = ClipboardFormat.values();
    }
}

