/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command.tool;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.command.tool.BlockTool;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Platform;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BlockCategories;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class FloatingTreeRemover
implements BlockTool {
    private int rangeSq = 10000;
    private Vector[] recurseDirections = new Vector[]{Direction.NORTH.toVector(), Direction.EAST.toVector(), Direction.SOUTH.toVector(), Direction.WEST.toVector(), Direction.UP.toVector(), Direction.DOWN.toVector()};

    @Override
    public boolean canUse(Actor player) {
        return player.hasPermission("worldedit.tool.deltree");
    }

    private boolean isTreeBlock(BlockType type) {
        return BlockCategories.LEAVES.contains(type) || BlockCategories.LOGS.contains(type) || type == BlockTypes.RED_MUSHROOM_BLOCK || type == BlockTypes.BROWN_MUSHROOM_BLOCK || type == BlockTypes.MUSHROOM_STEM || type == BlockTypes.VINE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean actPrimary(Platform server, LocalConfiguration config, Player player, LocalSession session, Location clicked) {
        World world = (World)clicked.getExtent();
        BlockState state = world.getBlock(clicked.toVector());
        if (!this.isTreeBlock(state.getBlockType())) {
            player.printError("That's not a tree.");
            return true;
        }
        EditSession editSession = session.createEditSession(player);
        try {
            Set<Vector> blockSet = this.bfs(world, clicked.toVector());
            if (blockSet == null) {
                player.printError("That's not a floating tree.");
                boolean bl = true;
                return bl;
            }
            for (Vector blockVector : blockSet) {
                BlockState otherState = editSession.getBlock(blockVector);
                if (!this.isTreeBlock(otherState.getBlockType())) continue;
                editSession.setBlock(blockVector, BlockTypes.AIR.getDefaultState());
            }
        }
        catch (MaxChangedBlocksException e) {
            player.printError("Max blocks change limit reached.");
        }
        finally {
            session.remember(editSession);
        }
        return true;
    }

    private Set<Vector> bfs(World world, Vector origin) throws MaxChangedBlocksException {
        HashSet<Vector> visited = new HashSet<Vector>();
        LinkedList<Vector> queue = new LinkedList<Vector>();
        queue.addLast(origin);
        visited.add(origin);
        while (!queue.isEmpty()) {
            Vector current = (Vector)queue.removeFirst();
            block4: for (Vector recurseDirection : this.recurseDirections) {
                Vector next = current.add(recurseDirection);
                if (origin.distanceSq(next) > (double)this.rangeSq || !visited.add(next)) continue;
                BlockState state = world.getBlock(next);
                BlockTypes type = state.getBlockType();
                switch (type) {
                    case AIR: 
                    case CAVE_AIR: 
                    case VOID_AIR: 
                    case SNOW: {
                        continue block4;
                    }
                    default: {
                        if (this.isTreeBlock(state.getBlockType())) {
                            queue.addLast(next);
                            continue block4;
                        }
                        BlockTypes currentType = world.getBlock(current).getBlockType();
                        if (BlockCategories.LEAVES.contains(currentType) || currentType == BlockTypes.VINE) continue block4;
                        return null;
                    }
                }
            }
        }
        return visited;
    }
}

