/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.boydti.fawe.FaweAPI;
import com.boydti.fawe.config.BBC;
import com.boydti.fawe.util.MathMan;
import com.google.common.base.Preconditions;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.minecraft.util.commands.Logging;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.util.command.parametric.Optional;
import com.sk89q.worldedit.world.World;

@Command(aliases={}, desc="Commands for moving the player around: [More Info](https://goo.gl/uQTUiT)")
public class NavigationCommands {
    private final WorldEdit worldEdit;

    public NavigationCommands(WorldEdit worldEdit) {
        Preconditions.checkNotNull((Object)worldEdit);
        this.worldEdit = worldEdit;
    }

    @Command(aliases={"unstuck", "!"}, usage="", desc="Escape from being stuck inside a block", min=0, max=0)
    @CommandPermissions(value={"worldedit.navigation.unstuck"})
    public void unstuck(Player player) throws WorldEditException {
        player.findFreePosition();
        BBC.UNSTUCK.send(player, new Object[0]);
    }

    @Command(aliases={"ascend", "asc"}, usage="[# of levels]", desc="Go up a floor", min=0, max=1)
    @CommandPermissions(value={"worldedit.navigation.ascend"})
    public void ascend(Player player, @Optional(value={"1"}) int levelsToAscend) throws WorldEditException {
        int ascentLevels = 0;
        while (player.ascendLevel() && levelsToAscend != ++ascentLevels) {
        }
        if (ascentLevels == 0) {
            BBC.ASCEND_FAIL.send(player, new Object[0]);
        } else if (ascentLevels == 1) {
            BBC.ASCENDED_SINGULAR.send(player, new Object[0]);
        } else {
            BBC.ASCENDED_PLURAL.send(player, ascentLevels);
        }
    }

    @Command(aliases={"descend", "desc"}, usage="[# of floors]", desc="Go down a floor", min=0, max=1)
    @CommandPermissions(value={"worldedit.navigation.descend"})
    public void descend(Player player, @Optional(value={"1"}) int levelsToDescend) throws WorldEditException {
        int descentLevels = 0;
        while (player.descendLevel() && levelsToDescend != ++descentLevels) {
        }
        if (descentLevels == 0) {
            BBC.DESCEND_FAIL.send(player, new Object[0]);
        } else if (descentLevels == 1) {
            BBC.DESCEND_SINGULAR.send(player, new Object[0]);
        } else {
            BBC.DESCEND_PLURAL.send(player, descentLevels);
        }
    }

    @Command(aliases={"ceil"}, usage="[clearance]", desc="Go to the celing", flags="fg", min=0, max=1)
    @CommandPermissions(value={"worldedit.navigation.ceiling"})
    @Logging(value=Logging.LogMode.POSITION)
    public void ceiling(Player player, LocalSession session, CommandContext args) throws WorldEditException {
        boolean alwaysGlass;
        int clearance = args.argsLength() > 0 ? Math.max(0, args.getInteger(0)) : 0;
        if (player.ascendToCeiling(clearance, alwaysGlass = this.getAlwaysGlass(args))) {
            BBC.WHOOSH.send(player, new Object[0]);
        } else {
            BBC.ASCEND_FAIL.send(player, new Object[0]);
        }
    }

    @Command(aliases={"thru"}, usage="", desc="Passthrough walls", min=0, max=0)
    @CommandPermissions(value={"worldedit.navigation.thru.command"})
    public void thru(Player player, LocalSession session, CommandContext args) throws WorldEditException {
        if (player.passThroughForwardWall(6)) {
            BBC.WHOOSH.send(player, new Object[0]);
        } else {
            BBC.THRU_FAIL.send(player, new Object[0]);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Command(aliases={"jumpto", "j"}, usage="[world,x,y,z]", desc="Teleport to a location", min=0, max=1)
    @CommandPermissions(value={"worldedit.navigation.jumpto.command"})
    public void jumpTo(Player player, LocalSession session, CommandContext args) throws WorldEditException {
        Location pos;
        block4: {
            if (args.argsLength() == 1) {
                String arg = args.getString(0);
                String[] split = arg.split(",");
                World world = FaweAPI.getWorld(split[0]);
                if (world != null && split.length == 4 && MathMan.isInteger(split[1]) && MathMan.isInteger(split[2]) && MathMan.isInteger(split[3])) {
                    pos = new Location((Extent)world, Integer.parseInt(split[1]), (double)Integer.parseInt(split[2]), (double)Integer.parseInt(split[3]));
                    break block4;
                } else {
                    BBC.SELECTOR_INVALID_COORDINATES.send(player, args.getString(0));
                    return;
                }
            }
            pos = player.getSolidBlockTrace(300);
        }
        if (pos != null) {
            player.findFreePosition(pos);
            BBC.POOF.send(player, new Object[0]);
            return;
        }
        BBC.NO_BLOCK.send(player, new Object[0]);
    }

    @Command(aliases={"up"}, usage="<number>", desc="Go upwards some distance", flags="fg", min=1, max=1)
    @CommandPermissions(value={"worldedit.navigation.up"})
    @Logging(value=Logging.LogMode.POSITION)
    public void up(Player player, LocalSession session, CommandContext args) throws WorldEditException {
        boolean alwaysGlass;
        int distance = args.getInteger(0);
        if (player.ascendUpwards(distance, alwaysGlass = this.getAlwaysGlass(args))) {
            BBC.WHOOSH.send(player, new Object[0]);
        } else {
            BBC.UP_FAIL.send(player, new Object[0]);
        }
    }

    private boolean getAlwaysGlass(CommandContext args) {
        LocalConfiguration config = this.worldEdit.getConfiguration();
        boolean forceFlight = args.hasFlag('f');
        boolean forceGlass = args.hasFlag('g');
        return forceGlass || config.navigationUseGlass && !forceFlight;
    }
}

