/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit;

import com.sk89q.worldedit.MutableBlockVector;
import com.sk89q.worldedit.Vector;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class BlockVector
extends Vector {
    public static final BlockVector ZERO = new BlockVector(0, 0, 0);
    public static final BlockVector UNIT_X = new BlockVector(1, 0, 0);
    public static final BlockVector UNIT_Y = new BlockVector(0, 1, 0);
    public static final BlockVector UNIT_Z = new BlockVector(0, 0, 1);
    public static final BlockVector ONE = new BlockVector(1, 1, 1);

    public BlockVector(Vector position) {
        this(position.getBlockX(), position.getBlockY(), position.getBlockZ());
    }

    public BlockVector(int x, int y, int z) {
        super(x, y, z);
    }

    public BlockVector(float x, float y, float z) {
        this((int)x, (int)y, (int)z);
    }

    public BlockVector(double x, double y, double z) {
        this((int)x, (int)y, (int)z);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Vector)) {
            return false;
        }
        Vector other = (Vector)obj;
        return (int)other.getX() == (int)this.getX() && (int)other.getY() == (int)this.getY() && (int)other.getZ() == (int)this.getZ();
    }

    public boolean equals(BlockVector obj) {
        return obj.getBlockX() == this.getBlockX() && obj.getBlockY() == this.getBlockY() && obj.getBlockZ() == this.getBlockZ();
    }

    @Override
    public int hashCode() {
        return (int)this.getX() ^ (int)this.getZ() << 16 ^ (int)this.getY() << 30;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        if (!(this instanceof MutableBlockVector)) {
            stream.writeInt(this.getBlockX());
            stream.writeInt(this.getBlockY());
            stream.writeInt(this.getBlockZ());
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        if (this instanceof MutableBlockVector) {
            return;
        }
        this.setComponents(stream.readInt(), stream.readInt(), stream.readInt());
    }

    @Override
    public BlockVector toBlockVector() {
        return this;
    }

    @Override
    public String toString() {
        return "(" + this.getBlockX() + ", " + this.getBlockY() + ", " + this.getBlockZ() + ")";
    }
}

