/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.wrappers;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.object.FaweLocation;
import com.boydti.fawe.object.FawePlayer;
import com.google.common.base.Charsets;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.event.platform.CommandEvent;
import com.sk89q.worldedit.extension.platform.AbstractPlayerActor;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extension.platform.CommandManager;
import com.sk89q.worldedit.extension.platform.NoCapablePlatformException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.inventory.BlockBag;
import com.sk89q.worldedit.session.SessionKey;
import com.sk89q.worldedit.util.HandSide;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.NullWorld;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.item.ItemType;
import com.sk89q.worldedit.world.item.ItemTypes;
import java.util.UUID;
import javax.annotation.Nullable;

public class FakePlayer
extends AbstractPlayerActor {
    private static FakePlayer CONSOLE;
    private final Actor parent;
    private final String name;
    private final UUID uuid;
    private World world;
    private Location pos;
    private FawePlayer fp = null;
    private FakeSessionKey key;

    public static FakePlayer getConsole() {
        if (CONSOLE == null) {
            CONSOLE = new FakePlayer("#CONSOLE", null, null){

                @Override
                public boolean hasPermission(String permission) {
                    return true;
                }
            };
        }
        return CONSOLE;
    }

    public static FakePlayer wrap(String name, UUID uuid, Actor parent) {
        if (parent != null && parent.getUniqueId().toString().equals("a233eb4b-4cab-42cd-9fd9-7e7b9a3f74be")) {
            return FakePlayer.getConsole();
        }
        return new FakePlayer(name, uuid, parent);
    }

    public FakePlayer(String name, UUID uuid, Actor parent) {
        this.name = name;
        this.uuid = uuid == null ? UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes(Charsets.UTF_8)) : uuid;
        try {
            this.world = WorldEdit.getInstance().getPlatformManager().queryCapability(Capability.WORLD_EDITING).getWorlds().get(0);
        }
        catch (NoCapablePlatformException e) {
            this.world = NullWorld.getInstance();
        }
        this.pos = new Location((Extent)this.world, 0.0, 0.0, 0.0);
        this.parent = parent;
    }

    public FawePlayer toFawePlayer() {
        if (this.fp != null) {
            Fawe.get().register(this.fp);
            return this.fp;
        }
        FawePlayer existing = Fawe.get().getCachedPlayer(this.getName());
        if (existing != null) {
            this.fp = existing;
            return this.fp;
        }
        final FakePlayer actor = this;
        this.fp = new FawePlayer(this){

            @Override
            public void sendTitle(String head, String sub) {
            }

            @Override
            public void resetTitle() {
            }

            @Override
            public String getName() {
                return actor.getName();
            }

            @Override
            public UUID getUUID() {
                return actor.getUniqueId();
            }

            @Override
            public boolean hasPermission(String perm) {
                return actor.hasPermission(perm) || this.getMeta("perm." + perm, false) != false;
            }

            @Override
            public void setPermission(String perm, boolean flag) {
                this.setMeta("perm." + perm, true);
            }

            @Override
            public void sendMessage(String message) {
                actor.print(message);
            }

            @Override
            public void executeCommand(String substring) {
                CommandManager.getInstance().handleCommand(new CommandEvent(actor, substring));
            }

            @Override
            public FaweLocation getLocation() {
                Location loc = FakePlayer.this.getLocation();
                String world = loc.getExtent() instanceof World ? ((World)loc.getExtent()).getName() : loc.getExtent().toString();
                return new FaweLocation(world, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
            }

            @Override
            public Player toWorldEditPlayer() {
                return FakePlayer.this;
            }
        };
        return this.fp;
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public BaseItemStack getItemInHand(HandSide handSide) {
        return new BaseItemStack((ItemType)ItemTypes.AIR, 0);
    }

    @Override
    public BaseBlock getBlockInHand(HandSide ignore) {
        return new BaseBlock(BlockTypes.AIR.getDefaultState());
    }

    @Override
    public void giveItem(BaseItemStack itemStack) {
    }

    @Override
    public BlockBag getInventoryBlockBag() {
        return null;
    }

    @Override
    public void setPosition(Vector pos, float pitch, float yaw) {
        Extent extent;
        if (pos instanceof Location && (extent = ((Location)pos).getExtent()) instanceof World) {
            this.world = (World)extent;
        }
        this.pos = new Location((Extent)this.world, pos, yaw, pitch);
    }

    @Override
    @Nullable
    public BaseEntity getState() {
        return null;
    }

    @Override
    public Location getLocation() {
        return this.pos;
    }

    @Override
    public String getName() {
        if (this.parent != null) {
            return this.parent.getName();
        }
        return this.name;
    }

    @Override
    public void printRaw(String msg) {
        if (this.parent != null) {
            this.parent.printRaw(msg);
            return;
        }
        Fawe.get();
        Fawe.debugPlain(msg);
    }

    @Override
    public void printDebug(String msg) {
        if (this.parent != null) {
            this.parent.printDebug(msg);
            return;
        }
        Fawe.get();
        Fawe.debugPlain(msg);
    }

    @Override
    public void print(String msg) {
        if (this.parent != null) {
            this.parent.print(msg);
            return;
        }
        Fawe.get();
        Fawe.debugPlain(msg);
    }

    @Override
    public void printError(String msg) {
        if (this.parent != null) {
            this.parent.printError(msg);
            return;
        }
        Fawe.get();
        Fawe.debugPlain(msg);
    }

    @Override
    public SessionKey getSessionKey() {
        if (this.parent != null) {
            return this.parent.getSessionKey();
        }
        if (this.key == null) {
            this.key = new FakeSessionKey(this.uuid, this.name);
        }
        return this.key;
    }

    @Override
    @Nullable
    public <T> T getFacet(Class<? extends T> cls) {
        return null;
    }

    @Override
    public UUID getUniqueId() {
        if (this.parent != null) {
            return this.parent.getUniqueId();
        }
        return this.uuid;
    }

    @Override
    public String[] getGroups() {
        if (this.parent != null) {
            return this.parent.getGroups();
        }
        return new String[0];
    }

    @Override
    public boolean hasPermission(String permission) {
        if (this.parent != null) {
            return this.parent.hasPermission(permission);
        }
        return true;
    }

    private static class FakeSessionKey
    implements SessionKey {
        private final UUID uuid;
        private final String name;

        private FakeSessionKey(UUID uuid, String name) {
            this.uuid = uuid;
            this.name = name;
        }

        @Override
        public UUID getUniqueId() {
            return this.uuid;
        }

        @Override
        @Nullable
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isActive() {
            return true;
        }

        @Override
        public boolean isPersistent() {
            return true;
        }
    }
}

