/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.util.chat;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.config.BBC;
import com.boydti.fawe.object.FawePlayer;
import com.boydti.fawe.util.chat.ChatManager;
import com.boydti.fawe.util.chat.PlainChatManager;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extension.platform.Actor;
import java.util.Objects;

public class Message {
    private Object builder;
    private boolean active;

    public Message() {
        try {
            this.reset(Fawe.get().getChatManager());
        }
        catch (Throwable e) {
            Fawe.debug("Doesn't support fancy chat for " + Fawe.imp().getPlatform());
            Fawe.get().setChatManager(new PlainChatManager());
            this.reset(Fawe.get().getChatManager());
        }
        this.active = !(Fawe.get().getChatManager() instanceof PlainChatManager);
    }

    public Message(BBC caption, Object ... args) {
        this(BBC.getPrefix() + caption.format(args));
    }

    public Message(String text) {
        this();
        this.text(text);
    }

    public <T> T $(ChatManager<T> manager) {
        return (T)this.builder;
    }

    public <T> T reset(ChatManager<T> manager) {
        this.builder = manager.builder();
        return (T)this.builder;
    }

    public Message activeText(String text) {
        if (this.active) {
            this.text(text);
        }
        return this;
    }

    public boolean supportsInteraction() {
        return this.active;
    }

    public Message text(BBC caption, Object ... args) {
        return this.text(caption.format(args));
    }

    public Message text(Object text) {
        Fawe.get().getChatManager().text(this, BBC.color(Objects.toString(text)));
        return this;
    }

    public Message link(String text) {
        Fawe.get().getChatManager().link(this, text);
        return this;
    }

    public Message tooltip(Message ... tooltip) {
        Fawe.get().getChatManager().tooltip(this, tooltip);
        return this;
    }

    public Message tooltip(String tooltip) {
        return this.tooltip(new Message(tooltip));
    }

    public Message command(String command) {
        Fawe.get().getChatManager().command(this, (WorldEdit.getInstance().getConfiguration().noDoubleSlash ? "" : "/") + command);
        return this;
    }

    public Message prefix() {
        return this.text(BBC.getPrefix());
    }

    public Message newline() {
        return this.text("\n");
    }

    public Message cmdTip(String commandAndTooltip) {
        return this.tooltip(commandAndTooltip).command(commandAndTooltip);
    }

    public Message linkTip(String linkAndTooltip) {
        return this.tooltip(linkAndTooltip).link(linkAndTooltip);
    }

    public Message cmdOptions(String prefix, String suffix, String ... options) {
        for (int i = 0; i < options.length; ++i) {
            if (i != 0) {
                this.text(" &8|&7 ");
            }
            this.text("&7[&a" + options[i] + "&7]").cmdTip(prefix + options[i] + suffix);
        }
        return this;
    }

    public Message suggestTip(String commandAndTooltip) {
        return this.tooltip(commandAndTooltip).suggest(commandAndTooltip);
    }

    public Message suggest(String command) {
        Fawe.get().getChatManager().suggest(this, command);
        return this;
    }

    public Message color(String color) {
        Fawe.get().getChatManager().color(this, BBC.color(color));
        return this;
    }

    public void send(Actor player) {
        this.send(FawePlayer.wrap(player));
    }

    public void send(FawePlayer player) {
        Fawe.get().getChatManager().send(this, player);
    }

    public Message paginate(String baseCommand, int page, int totalPages) {
        if (!this.active) {
            return this.text(BBC.PAGE_FOOTER.f(baseCommand, page + 1));
        }
        if (page < totalPages && page > 1) {
            this.text("&f<<").command(baseCommand + " " + (page - 1)).text("&8 | ").text("&f>>").command(baseCommand + " " + (page + 1));
        } else if (page <= 1 && totalPages > page) {
            this.text("&8 -").text(" | ").text("&f>>").command(baseCommand + " " + (page + 1));
        } else if (page == totalPages && totalPages > 1) {
            this.text("&f<<").command(baseCommand + " " + (page - 1)).text("&8 | ").text("- ");
        } else {
            this.text("&8 - | - ");
        }
        return this;
    }
}

