/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.schematic;

import com.boydti.fawe.object.HasFaweQueue;
import com.boydti.fawe.object.clipboard.FaweClipboard;
import com.boydti.fawe.object.clipboard.ReadOnlyClipboard;
import com.boydti.fawe.util.EditSessionBuilder;
import com.boydti.fawe.util.MaskTraverser;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.MutableBlockVector2D;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardWriter;
import com.sk89q.worldedit.extent.transform.BlockTransformExtent;
import com.sk89q.worldedit.function.RegionFunction;
import com.sk89q.worldedit.function.mask.ExistingBlockMask;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.operation.ForwardExtentCopy;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.function.visitor.RegionVisitor;
import com.sk89q.worldedit.math.transform.Transform;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BlockState;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nullable;

public class Schematic {
    private final Clipboard clipboard;

    public Schematic(Clipboard clipboard) {
        Preconditions.checkNotNull((Object)clipboard);
        this.clipboard = clipboard;
    }

    public Schematic(Region region) {
        Preconditions.checkNotNull((Object)region);
        Preconditions.checkNotNull((Object)region.getWorld(), (Object)"World cannot be null (use the other constructor for the region)");
        EditSession session = new EditSessionBuilder(region.getWorld()).allowedRegionsEverywhere().autoQueue(false).build();
        this.clipboard = new BlockArrayClipboard(region, ReadOnlyClipboard.of(session, region));
    }

    @Nullable
    public Clipboard getClipboard() {
        return this.clipboard;
    }

    public EditSession paste(World world, Vector to) {
        return this.paste(world, to, true, true, null);
    }

    public void save(File file, ClipboardFormat format) throws IOException {
        Preconditions.checkNotNull((Object)file);
        Preconditions.checkNotNull((Object)((Object)format));
        if (!file.exists()) {
            File parent = file.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
            file.createNewFile();
        }
        this.save(new FileOutputStream(file), format);
    }

    public void save(OutputStream stream, ClipboardFormat format) throws IOException {
        Preconditions.checkNotNull((Object)stream);
        Preconditions.checkNotNull((Object)((Object)format));
        try (ClipboardWriter writer = format.getWriter(stream);){
            writer.write(this.clipboard);
        }
    }

    public EditSession paste(World world, Vector to, boolean allowUndo, boolean pasteAir, @Nullable Transform transform) {
        return this.paste(world, to, allowUndo, pasteAir, true, transform);
    }

    public EditSession paste(World world, Vector to, boolean allowUndo, boolean pasteAir, boolean copyEntities, @Nullable Transform transform) {
        EditSession editSession;
        Preconditions.checkNotNull((Object)world);
        Preconditions.checkNotNull((Object)to);
        Region region = this.clipboard.getRegion();
        if (world instanceof EditSession) {
            editSession = (EditSession)world;
        } else {
            EditSessionBuilder builder = new EditSessionBuilder(world).autoQueue(true).checkMemory(false).allowedRegionsEverywhere().limitUnlimited();
            editSession = allowUndo ? builder.build() : builder.changeSetNull().fastmode(true).build();
        }
        Extent extent = this.clipboard;
        Mask sourceMask = editSession.getSourceMask();
        if (transform != null && !transform.isIdentity()) {
            extent = new BlockTransformExtent(this.clipboard, transform);
        } else if (sourceMask == null) {
            this.paste(editSession, to, pasteAir);
            editSession.flushQueue();
            return editSession;
        }
        ForwardExtentCopy copy = new ForwardExtentCopy(extent, this.clipboard.getRegion(), this.clipboard.getOrigin(), editSession, to);
        if (transform != null && !transform.isIdentity()) {
            copy.setTransform(transform);
        }
        copy.setCopyingEntities(copyEntities);
        if (sourceMask != null) {
            new MaskTraverser(sourceMask).reset(extent);
            copy.setSourceMask(sourceMask);
            editSession.setSourceMask(null);
        }
        if (!pasteAir) {
            copy.setSourceMask(new ExistingBlockMask(this.clipboard));
        }
        try {
            Operations.completeLegacy(copy);
        }
        catch (MaxChangedBlocksException e) {
            e.printStackTrace();
        }
        editSession.flushQueue();
        return editSession;
    }

    public void paste(Extent extent, Vector to, boolean pasteAir, Transform transform) {
        EditSession editSession;
        Mask sourceMask;
        Preconditions.checkNotNull((Object)transform);
        Region region = this.clipboard.getRegion();
        Extent source = this.clipboard;
        if (transform != null) {
            source = new BlockTransformExtent(this.clipboard, transform);
        }
        ForwardExtentCopy copy = new ForwardExtentCopy(source, this.clipboard.getRegion(), this.clipboard.getOrigin(), extent, to);
        if (transform != null) {
            copy.setTransform(transform);
        }
        copy.setCopyBiomes(!(this.clipboard instanceof BlockArrayClipboard) || ((BlockArrayClipboard)this.clipboard).IMP.hasBiomes());
        if (extent instanceof EditSession && (sourceMask = (editSession = (EditSession)extent).getSourceMask()) != null) {
            new MaskTraverser(sourceMask).reset(extent);
            copy.setSourceMask(sourceMask);
            editSession.setSourceMask(null);
        }
        if (!pasteAir) {
            copy.setSourceMask(new ExistingBlockMask(this.clipboard));
        }
        Operations.completeBlindly(copy);
    }

    public void paste(final Extent extent, Vector to, final boolean pasteAir) {
        int relz;
        int rely;
        int relx;
        boolean copyBiomes;
        Region region = this.clipboard.getRegion().clone();
        int maxY = extent.getMaximumPoint().getBlockY();
        Vector bot = this.clipboard.getMinimumPoint();
        Vector origin = this.clipboard.getOrigin();
        boolean bl = copyBiomes = !(this.clipboard instanceof BlockArrayClipboard) || ((BlockArrayClipboard)this.clipboard).IMP.hasBiomes();
        if (this.clipboard instanceof BlockArrayClipboard && region instanceof CuboidRegion) {
            relx = to.getBlockX() + bot.getBlockX() - origin.getBlockX();
            rely = to.getBlockY() + bot.getBlockY() - origin.getBlockY();
            relz = to.getBlockZ() + bot.getBlockZ() - origin.getBlockZ();
            final BlockArrayClipboard bac = (BlockArrayClipboard)this.clipboard;
            if (copyBiomes) {
                bac.IMP.forEach(new FaweClipboard.BlockReader(){
                    MutableBlockVector2D mpos2d = new MutableBlockVector2D();
                    {
                        this.mpos2d.setComponents(Integer.MIN_VALUE, Integer.MIN_VALUE);
                    }

                    @Override
                    public void run(int x, int y, int z, BlockState block) {
                        try {
                            int xx = x + relx;
                            int zz = z + relz;
                            if (xx != this.mpos2d.getBlockX() || zz != this.mpos2d.getBlockZ()) {
                                this.mpos2d.setComponents(xx, zz);
                                extent.setBiome(this.mpos2d, bac.IMP.getBiome(x, z));
                            }
                            if (!pasteAir && block.getBlockType().getMaterial().isAir()) {
                                return;
                            }
                            extent.setBlock(xx, y + rely, zz, block);
                        }
                        catch (WorldEditException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }, true);
            } else {
                bac.IMP.forEach(new FaweClipboard.BlockReader(){

                    @Override
                    public void run(int x, int y, int z, BlockState block) {
                        try {
                            extent.setBlock(x + relx, y + rely, z + relz, block);
                        }
                        catch (WorldEditException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }, pasteAir);
            }
        } else {
            relx = to.getBlockX() - origin.getBlockX();
            rely = to.getBlockY() - origin.getBlockY();
            relz = to.getBlockZ() - origin.getBlockZ();
            RegionVisitor visitor = new RegionVisitor((Iterable<? extends Vector>)region, new RegionFunction(){
                MutableBlockVector2D mpos2d_2 = new MutableBlockVector2D();
                MutableBlockVector2D mpos2d = new MutableBlockVector2D();
                {
                    this.mpos2d.setComponents(Integer.MIN_VALUE, Integer.MIN_VALUE);
                }

                @Override
                public boolean apply(Vector mutable) throws WorldEditException {
                    BlockState block = Schematic.this.clipboard.getBlock(mutable);
                    int xx = mutable.getBlockX() + relx;
                    int zz = mutable.getBlockZ() + relz;
                    if (copyBiomes && xx != this.mpos2d.getBlockX() && zz != this.mpos2d.getBlockZ()) {
                        this.mpos2d.setComponents(xx, zz);
                        extent.setBiome(this.mpos2d, Schematic.this.clipboard.getBiome(this.mpos2d_2.setComponents(mutable.getBlockX(), mutable.getBlockZ())));
                    }
                    if (!pasteAir && block.getBlockType().getMaterial().isAir()) {
                        return false;
                    }
                    extent.setBlock(xx, mutable.getBlockY() + rely, zz, block);
                    return false;
                }
            }, (HasFaweQueue)null);
            Operations.completeBlindly(visitor);
        }
        int entityOffsetX = to.getBlockX() - origin.getBlockX();
        int entityOffsetY = to.getBlockY() - origin.getBlockY();
        int entityOffsetZ = to.getBlockZ() - origin.getBlockZ();
        for (Entity entity : this.clipboard.getEntities()) {
            Location pos = entity.getLocation();
            Location newPos = new Location(pos.getExtent(), pos.getX() + (double)entityOffsetX, pos.getY() + (double)entityOffsetY, pos.getZ() + (double)entityOffsetZ, pos.getYaw(), pos.getPitch());
            extent.createEntity(newPos, entity.getState());
        }
    }
}

