/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.progress;

import com.boydti.fawe.config.BBC;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.object.FawePlayer;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.object.RunnableVal2;
import com.boydti.fawe.util.StringMan;
import com.boydti.fawe.util.TaskManager;

public class DefaultProgressTracker
extends RunnableVal2<FaweQueue.ProgressType, Integer> {
    private final FawePlayer player;
    private final long start;
    private int delay;
    private int interval;
    private int totalQueue;
    private int amountQueue;
    private int amountDispatch;
    private int lastSize;
    private boolean done;
    private long lastTick;

    public DefaultProgressTracker(FawePlayer player) {
        Settings.QUEUE cfr_ignored_0 = Settings.IMP.QUEUE;
        this.delay = Settings.QUEUE.PROGRESS.DELAY;
        Settings.QUEUE cfr_ignored_1 = Settings.IMP.QUEUE;
        this.interval = Settings.QUEUE.PROGRESS.INTERVAL;
        this.totalQueue = 0;
        this.amountQueue = 0;
        this.amountDispatch = 0;
        this.lastSize = 0;
        this.done = false;
        this.lastTick = 0L;
        this.start = System.currentTimeMillis();
        this.player = player;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public int getInterval() {
        return this.interval;
    }

    public int getDelay() {
        return this.delay;
    }

    public FawePlayer getPlayer() {
        return this.player;
    }

    @Override
    public void run(FaweQueue.ProgressType type, Integer amount) {
        long currentTick;
        switch (type) {
            case DISPATCH: {
                ++this.amountDispatch;
                this.amountQueue = amount;
                break;
            }
            case QUEUE: {
                ++this.totalQueue;
                this.amountQueue = amount;
                break;
            }
            case DONE: {
                if (this.totalQueue > 64 && !this.done) {
                    this.done = true;
                    this.done();
                }
                return;
            }
        }
        long now = System.currentTimeMillis();
        if (now - this.start > (long)this.delay && (currentTick = now / 50L) > this.lastTick + (long)this.interval) {
            this.lastTick = currentTick;
            this.send();
        }
    }

    private final void done() {
        TaskManager.IMP.task(new Runnable(){

            @Override
            public void run() {
                DefaultProgressTracker.this.doneTask();
            }
        });
    }

    private final void send() {
        TaskManager.IMP.task(new Runnable(){

            @Override
            public void run() {
                DefaultProgressTracker.this.sendTask();
            }
        });
    }

    public void doneTask() {
        this.sendTile("", BBC.PROGRESS_FINISHED.s());
    }

    public void sendTask() {
        String queue = StringMan.padRight("" + this.totalQueue, 3);
        String dispatch = StringMan.padLeft("" + this.amountDispatch, 3);
        int total = this.amountDispatch != 0 ? this.amountDispatch : this.amountQueue;
        int speed = total != 0 ? (int)((double)total / Math.max((double)(System.currentTimeMillis() - this.start) / 1000.0, 1.0)) : 0;
        String speedStr = StringMan.padRight("" + speed, 3);
        String percent = StringMan.padRight("" + (this.amountDispatch != 0 ? this.amountDispatch * 100 / this.totalQueue : 0), 3);
        int remaining = speed != 0 ? this.amountQueue / speed : -1;
        this.sendTile("", BBC.PROGRESS_MESSAGE.format(queue, dispatch, percent, StringMan.padLeft("" + speed, 3), StringMan.padLeft("" + remaining, 3)));
    }

    public void sendTile(String title, String sub) {
        this.player.sendTitle(title, sub);
    }
}

