/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.change;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.object.FaweQueue;
import com.boydti.fawe.object.HasFaweQueue;
import com.boydti.fawe.object.extent.FastWorldEditExtent;
import com.boydti.fawe.util.ExtentTraverser;
import com.boydti.fawe.util.MathMan;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.DoubleTag;
import com.sk89q.jnbt.LongTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.history.UndoContext;
import com.sk89q.worldedit.history.change.Change;
import java.util.List;
import java.util.UUID;

public class MutableEntityChange
implements Change {
    public CompoundTag tag;
    public boolean create;
    private FaweQueue queue;
    private boolean checkedQueue;

    public MutableEntityChange(CompoundTag tag, boolean create) {
        this.tag = tag;
        this.create = create;
    }

    @Override
    public void undo(UndoContext context) throws WorldEditException {
        if (!this.create) {
            this.create(context);
        } else {
            this.delete(context);
        }
    }

    @Override
    public void redo(UndoContext context) throws WorldEditException {
        if (this.create) {
            this.create(context);
        } else {
            this.delete(context);
        }
    }

    public void delete(UndoContext context) {
        Extent extent = context.getExtent();
        ExtentTraverser<FastWorldEditExtent> find = new ExtentTraverser<Extent>(extent).find(FastWorldEditExtent.class);
        if (find != null) {
            long least;
            long most;
            FastWorldEditExtent fwee = find.get();
            Object map = this.tag.getValue();
            if (map.containsKey("UUIDMost")) {
                most = ((LongTag)map.get("UUIDMost")).getValue();
                least = ((LongTag)map.get("UUIDLeast")).getValue();
            } else if (map.containsKey("PersistentIDMSB")) {
                most = ((LongTag)map.get("PersistentIDMSB")).getValue();
                least = ((LongTag)map.get("PersistentIDLSB")).getValue();
            } else {
                Fawe.debug("Skipping entity without uuid.");
                return;
            }
            List pos = (List)((Tag)map.get("Pos")).getValue();
            int x = MathMan.roundInt(((DoubleTag)pos.get(0)).getValue());
            int y = MathMan.roundInt(((DoubleTag)pos.get(1)).getValue());
            int z = MathMan.roundInt(((DoubleTag)pos.get(2)).getValue());
            UUID uuid = new UUID(most, least);
            fwee.getQueue().removeEntity(x, y, z, uuid);
        } else {
            Fawe.debug("FAWE doesn't support: " + context + " for " + this.getClass() + " (bug Empire92)");
        }
    }

    public void create(UndoContext context) {
        if (this.queue != null) {
            this.perform(this.queue);
        }
        if (!this.checkedQueue) {
            this.checkedQueue = true;
            Extent extent = context.getExtent();
            ExtentTraverser<HasFaweQueue> found = new ExtentTraverser<Extent>(extent).find(HasFaweQueue.class);
            if (found != null) {
                this.queue = found.get().getQueue();
                this.perform(this.queue);
            } else {
                Fawe.debug("FAWE does not support: " + extent + " for " + this.getClass() + " (bug Empire92)");
            }
        }
    }

    public void perform(FaweQueue queue) {
        Object map = this.tag.getValue();
        Tag posTag = (Tag)map.get("Pos");
        if (posTag == null) {
            Fawe.debug("Missing pos tag: " + this.tag);
            return;
        }
        List pos = (List)posTag.getValue();
        int x = MathMan.roundInt(((DoubleTag)pos.get(0)).getValue());
        int y = MathMan.roundInt(((DoubleTag)pos.get(1)).getValue());
        int z = MathMan.roundInt(((DoubleTag)pos.get(2)).getValue());
        queue.setEntity(x, y, z, this.tag);
    }
}

