/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.brush;

import com.boydti.fawe.config.BBC;
import com.boydti.fawe.object.FawePlayer;
import com.boydti.fawe.object.PseudoRandom;
import com.boydti.fawe.object.brush.ResettableTool;
import com.boydti.fawe.object.brush.visualization.VisualExtent;
import com.boydti.fawe.object.clipboard.ResizableClipboardBuilder;
import com.boydti.fawe.object.function.NullRegionFunction;
import com.boydti.fawe.object.function.mask.AbstractDelegateMask;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.command.tool.brush.Brush;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.Masks;
import com.sk89q.worldedit.function.operation.Operation;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.function.visitor.RecursiveVisitor;
import com.sk89q.worldedit.math.transform.AffineTransform;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.session.ClipboardHolder;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.block.BlockState;

public class CopyPastaBrush
implements Brush,
ResettableTool {
    private final LocalSession session;
    private final Player player;
    public boolean autoRotate;
    public boolean randomRotate;

    public CopyPastaBrush(Player player, LocalSession session, boolean randomRotate, boolean autoRotate) {
        session.setClipboard(null);
        this.player = player;
        this.session = session;
        this.randomRotate = randomRotate;
        this.autoRotate = autoRotate;
    }

    @Override
    public boolean reset() {
        this.session.setClipboard(null);
        BBC.BRUSH_RESET.send(this.player, new Object[0]);
        return true;
    }

    @Override
    public void build(final EditSession editSession, Vector position, Pattern pattern, double size) throws MaxChangedBlocksException {
        FawePlayer fp = editSession.getPlayer();
        ClipboardHolder clipboard = this.session.getExistingClipboard();
        if (clipboard == null) {
            if (editSession.getExtent() instanceof VisualExtent) {
                return;
            }
            Mask mask = editSession.getMask();
            if (mask == null) {
                mask = Masks.alwaysTrue();
            }
            final ResizableClipboardBuilder builder = new ResizableClipboardBuilder(editSession.getWorld());
            int size2 = (int)(size * size);
            final int minY = position.getBlockY();
            mask = new AbstractDelegateMask(mask){

                @Override
                public boolean test(Vector vector) {
                    BlockState block;
                    if (super.test(vector) && vector.getBlockY() >= minY && !(block = editSession.getLazyBlock(vector)).getBlockType().getMaterial().isAir()) {
                        builder.add(vector, EditSession.nullBlock, block);
                        return true;
                    }
                    return false;
                }
            };
            mask.test(position);
            RecursiveVisitor visitor = new RecursiveVisitor(mask, new NullRegionFunction(), (int)size, editSession);
            visitor.visit(position);
            Operations.completeBlindly(visitor);
            Clipboard newClipboard = builder.build();
            newClipboard.setOrigin(position);
            ClipboardHolder holder = new ClipboardHolder(newClipboard);
            this.session.setClipboard(holder);
            int blocks = builder.size();
            BBC.COMMAND_COPY.send(fp, blocks);
            return;
        }
        AffineTransform transform = null;
        if (this.randomRotate) {
            if (transform == null) {
                transform = new AffineTransform();
            }
            int rotate = 90 * PseudoRandom.random.nextInt(4);
            transform = transform.rotateY(rotate);
        }
        if (this.autoRotate) {
            if (transform == null) {
                transform = new AffineTransform();
            }
            Location loc = editSession.getPlayer().getPlayer().getLocation();
            float yaw = loc.getYaw();
            float pitch = loc.getPitch();
            transform = transform.rotateY(-yaw % 360.0f);
            transform = transform.rotateX(pitch - 90.0f);
        }
        if (transform != null && !transform.isIdentity()) {
            clipboard.setTransform(transform);
        }
        Clipboard faweClip = clipboard.getClipboard();
        Region region = faweClip.getRegion();
        Operation operation = clipboard.createPaste(editSession).to(position.add(0, 1, 0)).ignoreAirBlocks(true).build();
        Operations.completeLegacy(operation);
        editSession.flushQueue();
    }
}

