/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.jnbt.anvil.filters;

import com.boydti.fawe.jnbt.anvil.MCAChunk;
import com.boydti.fawe.jnbt.anvil.MCAFilterCounter;
import com.boydti.fawe.object.number.MutableLong;
import com.boydti.fawe.util.ArrayUtil;

public class RemoveLayerFilter
extends MCAFilterCounter {
    private final int startLayer;
    private final int endLayer;
    private final int minY;
    private final int maxY;
    private final int id;

    public RemoveLayerFilter(int minY, int maxY, int id) {
        this.minY = minY;
        this.maxY = maxY;
        this.startLayer = minY >> 4;
        this.endLayer = maxY >> 4;
        this.id = id;
    }

    @Override
    public MCAChunk applyChunk(MCAChunk chunk, MutableLong cache) {
        for (int layer = this.startLayer; layer <= this.endLayer; ++layer) {
            int indexEnd;
            int indexStart;
            int y;
            byte[] ids = chunk.ids[layer];
            if (ids == null) {
                return null;
            }
            int startY = Math.max(this.minY, layer << 4) & 0xF;
            int endY = Math.min(this.maxY, 15 + (layer << 4)) & 0xF;
            for (y = startY; y <= endY; ++y) {
                indexStart = y << 8;
                indexEnd = indexStart + 255;
                for (int index = indexStart; index <= indexEnd; ++index) {
                    if (ids[index] == this.id) continue;
                    return null;
                }
            }
            for (y = startY; y <= endY; ++y) {
                indexStart = y << 8;
                indexEnd = indexStart + 255;
                ArrayUtil.fill(ids, indexStart, indexEnd + 1, (byte)0);
            }
            chunk.setModified();
        }
        return null;
    }
}

