/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.jnbt.anvil.filters;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.jnbt.NBTStreamer;
import com.boydti.fawe.jnbt.anvil.MCAChunk;
import com.boydti.fawe.jnbt.anvil.MCAFile;
import com.boydti.fawe.jnbt.anvil.MCAFilterCounter;
import com.boydti.fawe.object.RunnableVal;
import com.boydti.fawe.object.RunnableVal4;
import com.boydti.fawe.object.exception.FaweException;
import com.boydti.fawe.object.number.MutableLong;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;

public class DeleteUninhabitedFilter
extends MCAFilterCounter {
    private final long inhabitedTicks;
    private final long fileDurationMillis;
    private final long cutoffChunkAgeEpoch;
    private boolean debug = false;

    public DeleteUninhabitedFilter(long fileDurationMillis, long inhabitedTicks, long chunkInactivityMillis) {
        this.fileDurationMillis = fileDurationMillis;
        this.inhabitedTicks = inhabitedTicks;
        this.cutoffChunkAgeEpoch = System.currentTimeMillis() - chunkInactivityMillis;
    }

    public void enableDebug() {
        this.debug = true;
    }

    public long getInhabitedTicks() {
        return this.inhabitedTicks;
    }

    public long getFileDurationMillis() {
        return this.fileDurationMillis;
    }

    public long getCutoffChunkAgeEpoch() {
        return this.cutoffChunkAgeEpoch;
    }

    @Override
    public boolean appliesFile(Path path, BasicFileAttributes attr) {
        String name = path.getFileName().toString();
        String[] split = name.split("\\.");
        int mcaX = Integer.parseInt(split[1]);
        int mcaZ = Integer.parseInt(split[2]);
        File file = path.toFile();
        long lastModified = attr.lastModifiedTime().toMillis();
        if (lastModified > this.cutoffChunkAgeEpoch) {
            return false;
        }
        try {
            if (this.shouldDelete(file, attr, mcaX, mcaZ)) {
                if (this.debug) {
                    Fawe.debug("Deleting " + file + " as it was modified at " + new Date(lastModified) + " and you provided a threshold of " + new Date(this.cutoffChunkAgeEpoch));
                }
                file.delete();
                ((MutableLong)this.get()).add(0x4000000L);
                return false;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public MCAFile applyFile(MCAFile mca) {
        try {
            ForkJoinPool pool = new ForkJoinPool();
            mca.init();
            this.filter(mca, pool);
            pool.awaitQuiescence(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            mca.close(pool);
            pool.shutdown();
            pool.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return null;
    }

    public boolean shouldDelete(File file, BasicFileAttributes attr, int mcaX, int mcaZ) throws IOException {
        long creation = attr.creationTime().toMillis();
        long modified = attr.lastModifiedTime().toMillis();
        return modified - creation < this.fileDurationMillis && modified > creation || file.length() < 12288L;
    }

    public boolean shouldDeleteChunk(MCAFile mca, int cx, int cz) {
        return true;
    }

    public void filter(final MCAFile mca, final ForkJoinPool pool) throws IOException {
        mca.forEachSortedChunk(new RunnableVal4<Integer, Integer, Integer, Integer>(){

            @Override
            public void run(final Integer x, final Integer z, final Integer offset, Integer size) {
                int cz;
                int bx = mca.getX() << 5;
                int bz = mca.getZ() << 5;
                int cx = bx + x;
                if (DeleteUninhabitedFilter.this.shouldDeleteChunk(mca, cx, cz = bz + z)) {
                    Runnable task = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                mca.streamChunk(offset, new RunnableVal<NBTStreamer>(){

                                    @Override
                                    public void run(NBTStreamer value) {
                                        DeleteUninhabitedFilter.this.addReaders(mca, x, z, value);
                                    }
                                });
                            }
                            catch (FaweException faweException) {
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    };
                    pool.submit(task);
                }
            }
        });
    }

    public void addReaders(final MCAFile mca, final int x, final int z, NBTStreamer streamer) {
        streamer.addReader(".Level.InhabitedTime", new BiConsumer<Integer, Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void accept(Integer index, Long value) {
                if (value <= DeleteUninhabitedFilter.this.inhabitedTicks) {
                    MCAChunk chunk = new MCAChunk(null, x, z);
                    if (DeleteUninhabitedFilter.this.debug) {
                        int cx = (mca.getX() << 5) + (x & 0x1F);
                        int cz = (mca.getZ() << 5) + (z & 0x1F);
                        Fawe.debug("Deleting chunk " + cx + "," + cz + " as it was only inhabited for " + value + " and passed all other checks");
                    }
                    chunk.setDeleted(true);
                    MCAFile mCAFile = mca;
                    synchronized (mCAFile) {
                        mca.setChunk(chunk);
                    }
                    ((MutableLong)DeleteUninhabitedFilter.this.get()).add(65536L);
                }
            }
        });
    }
}

