/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.jnbt;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.object.clipboard.CPUOptimizedClipboard;
import com.boydti.fawe.object.clipboard.DiskOptimizedClipboard;
import com.boydti.fawe.object.clipboard.FaweClipboard;
import com.boydti.fawe.object.clipboard.MemoryOptimizedClipboard;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.GZIPInputStream;

public class CorruptSchematicStreamer {
    private final InputStream stream;
    private final UUID uuid;
    private FaweClipboard fc;
    final AtomicInteger volume = new AtomicInteger();
    final AtomicInteger width = new AtomicInteger();
    final AtomicInteger height = new AtomicInteger();
    final AtomicInteger length = new AtomicInteger();
    final AtomicInteger offsetX = new AtomicInteger();
    final AtomicInteger offsetY = new AtomicInteger();
    final AtomicInteger offsetZ = new AtomicInteger();
    final AtomicInteger originX = new AtomicInteger();
    final AtomicInteger originY = new AtomicInteger();
    final AtomicInteger originZ = new AtomicInteger();

    public CorruptSchematicStreamer(InputStream rootStream, UUID uuid) {
        this.stream = rootStream;
        this.uuid = uuid;
    }

    public void match(String matchTag, CorruptReader reader) {
        try {
            int read;
            this.stream.reset();
            this.stream.mark(Integer.MAX_VALUE);
            DataInputStream dataInput = new DataInputStream(new BufferedInputStream(new GZIPInputStream(this.stream)));
            byte[] match = matchTag.getBytes();
            int[] matchValue = new int[match.length];
            int matchIndex = 0;
            while ((read = dataInput.read()) != -1) {
                byte expected = match[matchIndex];
                if (expected == -1) {
                    if (++matchIndex != match.length) continue;
                    break;
                }
                if (read == expected) {
                    if (++matchIndex != match.length) continue;
                    reader.run(dataInput);
                    break;
                }
                if (matchIndex != 2) continue;
                matchIndex = 0;
            }
            Fawe.debug(" - Recover " + matchTag + " = success");
        }
        catch (Throwable e) {
            Fawe.debug(" - Recover " + matchTag + " = partial failure");
            e.printStackTrace();
        }
    }

    public FaweClipboard setupClipboard() {
        if (this.fc != null) {
            return this.fc;
        }
        Vector dimensions = this.guessDimensions(this.volume.get(), this.width.get(), this.height.get(), this.length.get());
        if (this.width.get() == 0 || this.height.get() == 0 || this.length.get() == 0) {
            Fawe.debug("No dimensions found! Estimating based on factors:" + dimensions);
        }
        this.fc = Settings.IMP.CLIPBOARD.USE_DISK ? new DiskOptimizedClipboard(dimensions.getBlockX(), dimensions.getBlockY(), dimensions.getBlockZ(), this.uuid) : (Settings.IMP.CLIPBOARD.COMPRESSION_LEVEL == 0 ? new CPUOptimizedClipboard(dimensions.getBlockX(), dimensions.getBlockY(), dimensions.getBlockZ()) : new MemoryOptimizedClipboard(dimensions.getBlockX(), dimensions.getBlockY(), dimensions.getBlockZ()));
        return this.fc;
    }

    public Clipboard recover() {
        throw new UnsupportedOperationException("TODO FIXME");
    }

    private Vector guessDimensions(int volume, int width, int height, int length) {
        if (volume == 0) {
            return new Vector(width, height, length);
        }
        if (volume == width * height * length) {
            return new Vector(width, height, length);
        }
        if (width == 0 && height != 0 && length != 0 && volume % (height * length) == 0 && height * length <= volume) {
            return new Vector(volume / (height * length), height, length);
        }
        if (height == 0 && width != 0 && length != 0 && volume % (width * length) == 0 && width * length <= volume) {
            return new Vector(width, volume / (width * length), length);
        }
        if (length == 0 && height != 0 && width != 0 && volume % (height * width) == 0 && height * width <= volume) {
            return new Vector(width, height, volume / (width * height));
        }
        ArrayList<Integer> factors = new ArrayList<Integer>();
        for (int i = (int)Math.sqrt(volume); i > 0; --i) {
            if (volume % i != 0) continue;
            factors.add(i);
            factors.add(volume / i);
        }
        int min = Integer.MAX_VALUE;
        Vector dimensions = new Vector();
        for (int x = 0; x < factors.size(); ++x) {
            int xValue = (Integer)factors.get(x);
            for (int y = 0; y < factors.size(); ++y) {
                int yValue = (Integer)factors.get(y);
                long area = xValue * yValue;
                if ((long)volume % area != 0L) continue;
                int z = (int)((long)volume / area);
                int max = Math.max(Math.max(xValue, yValue), z);
                if (max >= min) continue;
                min = max;
                dimensions = new Vector(xValue, z, yValue);
            }
        }
        return dimensions;
    }

    public static interface CorruptReader {
        public void run(DataInputStream var1) throws IOException;
    }
}

