/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.v0;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.bukkit.FaweBukkit;
import com.boydti.fawe.bukkit.v0.ChunkListener_8Plus;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.util.FaweTimer;
import com.boydti.fawe.util.MathMan;
import com.boydti.fawe.util.TaskManager;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockCanBuildEvent;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockExpEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.block.NotePlayEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.util.Vector;

public abstract class ChunkListener
implements Listener {
    protected int rateLimit = 0;
    private int[] badLimit;
    public static boolean physicsFreeze = false;
    public static boolean itemFreeze = false;
    protected final Long2ObjectOpenHashMap<Boolean> badChunks;
    private Long2ObjectOpenHashMap<int[]> counter;
    private int lastX;
    private int lastZ;
    private int[] lastCount;
    protected int physSkip;
    protected boolean physCancel;
    protected long physCancelPair;
    protected long physStart;
    protected long physTick;

    public ChunkListener() {
        this.badLimit = new int[]{Settings.IMP.TICK_LIMITER.PHYSICS_MS, Settings.IMP.TICK_LIMITER.FALLING, Settings.IMP.TICK_LIMITER.ITEMS};
        this.badChunks = new Long2ObjectOpenHashMap();
        this.counter = new Long2ObjectOpenHashMap();
        this.lastX = Integer.MIN_VALUE;
        this.lastZ = Integer.MIN_VALUE;
        if (Settings.IMP.TICK_LIMITER.ENABLED) {
            PluginManager plm = Bukkit.getPluginManager();
            Plugin plugin = ((FaweBukkit)Fawe.imp()).getPlugin();
            plm.registerEvents((Listener)this, plugin);
            try {
                plm.registerEvents((Listener)new ChunkListener_8Plus(this), plugin);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            TaskManager.IMP.repeat(new Runnable(){

                @Override
                public void run() {
                    --ChunkListener.this.rateLimit;
                    physicsFreeze = false;
                    itemFreeze = false;
                    ChunkListener.this.lastZ = Integer.MIN_VALUE;
                    ChunkListener.this.physSkip = 0;
                    ChunkListener.this.physCancelPair = Long.MIN_VALUE;
                    ChunkListener.this.physCancel = false;
                    ChunkListener.this.counter.clear();
                    for (Long2ObjectMap.Entry entry : ChunkListener.this.badChunks.long2ObjectEntrySet()) {
                        long key = entry.getLongKey();
                        int x = MathMan.unpairIntX(key);
                        int z = MathMan.unpairIntY(key);
                        ChunkListener.this.counter.put(key, ChunkListener.this.badLimit);
                    }
                    ChunkListener.this.badChunks.clear();
                }
            }, Settings.IMP.TICK_LIMITER.INTERVAL);
        }
    }

    protected abstract int getDepth(Exception var1);

    protected abstract StackTraceElement getElement(Exception var1, int var2);

    public int[] getCount(int cx, int cz) {
        if (this.lastX == cx && this.lastZ == cz) {
            return this.lastCount;
        }
        this.lastX = cx;
        this.lastZ = cz;
        long pair = MathMan.pairInt(cx, cz);
        this.lastCount = this.counter.get(pair);
        int[] tmp = this.lastCount;
        if (tmp == null) {
            tmp = new int[3];
            this.lastCount = tmp;
            this.counter.put(pair, tmp);
        }
        return tmp;
    }

    public void cleanup(Chunk chunk) {
        for (Entity entity : chunk.getEntities()) {
            if (entity.getType() != EntityType.DROPPED_ITEM) continue;
            entity.remove();
        }
    }

    public final void reset() {
        this.physSkip = 0;
        this.physStart = System.currentTimeMillis();
        this.physCancel = false;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void event(BlockBurnEvent event) {
        this.reset();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void event(BlockCanBuildEvent event) {
        this.reset();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void event(BlockDamageEvent event) {
        this.reset();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void event(BlockDispenseEvent event) {
        this.reset();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void event(BlockExpEvent event) {
        this.reset();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void event(BlockFadeEvent event) {
        this.reset();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void event(BlockFromToEvent event) {
        this.reset();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void event(BlockGrowEvent event) {
        this.reset();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void event(BlockIgniteEvent event) {
        this.reset();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void event(BlockPlaceEvent event) {
        this.reset();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void event(FurnaceBurnEvent event) {
        this.reset();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void event(FurnaceSmeltEvent event) {
        this.reset();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void event(LeavesDecayEvent event) {
        this.reset();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void event(NotePlayEvent event) {
        this.reset();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void event(SignChangeEvent event) {
        this.reset();
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void event(BlockRedstoneEvent event) {
        this.reset();
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPhysics(BlockPhysicsEvent event) {
        if (this.physCancel) {
            Block block = event.getBlock();
            long pair = MathMan.pairInt(block.getX() >> 4, block.getZ() >> 4);
            if (this.physCancelPair == pair) {
                event.setCancelled(true);
                return;
            }
            if (this.badChunks.containsKey(pair)) {
                this.physCancelPair = pair;
                event.setCancelled(true);
                return;
            }
        } else {
            if ((++this.physSkip & 0x3FF) != 0) {
                return;
            }
            FaweTimer timer = Fawe.get().getTimer();
            if (timer.getTick() != this.physTick) {
                this.physTick = timer.getTick();
                this.physStart = System.currentTimeMillis();
                return;
            }
            if (System.currentTimeMillis() - this.physStart < (long)Settings.IMP.TICK_LIMITER.PHYSICS_MS) {
                return;
            }
        }
        if (physicsFreeze) {
            event.setCancelled(true);
            return;
        }
        switch (event.getChangedType()) {
            case AIR: 
            case CAVE_AIR: 
            case VOID_AIR: {
                return;
            }
        }
        Exception e = new Exception();
        int depth = this.getDepth(e);
        if (depth >= 256 && this.containsSetAir(e, event)) {
            Block block = event.getBlock();
            int cx = block.getX() >> 4;
            int cz = block.getZ() >> 4;
            this.physCancelPair = MathMan.pairInt(cx, cz);
            if (this.rateLimit <= 0) {
                this.rateLimit = 20;
                Fawe.debug("[FAWE `tick-limiter`] Detected and cancelled physics  lag source at " + block.getLocation());
            }
            this.cancelNearby(cx, cz);
            event.setCancelled(true);
            this.physCancel = true;
            return;
        }
        this.physSkip = 1;
        this.physCancel = false;
    }

    protected boolean containsSetAir(Exception e, BlockPhysicsEvent event) {
        for (int frame = 25; frame < 35; ++frame) {
            String methodName;
            StackTraceElement elem = this.getElement(e, frame);
            if (elem == null || ((methodName = elem.getMethodName()).charAt(0) != 's' || methodName.length() != 6) && methodName.length() != 14) continue;
            return true;
        }
        return false;
    }

    protected void cancelNearby(int cx, int cz) {
        this.cancel(cx, cz);
        this.cancel(cx + 1, cz);
        this.cancel(cx - 1, cz);
        this.cancel(cx, cz + 1);
        this.cancel(cx, cz - 1);
        this.cancel(cx - 1, cz - 1);
        this.cancel(cx - 1, cz + 1);
        this.cancel(cx + 1, cz - 1);
        this.cancel(cx + 1, cz + 1);
    }

    private void cancel(int cx, int cz) {
        long key = MathMan.pairInt(cx, cz);
        this.badChunks.put(key, (Boolean)true);
        this.counter.put(key, this.badLimit);
        int[] count = this.getCount(cx, cz);
        count[0] = Integer.MAX_VALUE;
        count[1] = Integer.MAX_VALUE;
        count[2] = Integer.MAX_VALUE;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onBlockChange(EntityChangeBlockEvent event) {
        int z;
        int cz;
        if (physicsFreeze) {
            event.setCancelled(true);
            return;
        }
        Block block = event.getBlock();
        int x = block.getX();
        int cx = x >> 4;
        int[] count = this.getCount(cx, cz = (z = block.getZ()) >> 4);
        if (count[1] >= Settings.IMP.TICK_LIMITER.FALLING) {
            event.setCancelled(true);
            return;
        }
        if (event.getEntityType() == EntityType.FALLING_BLOCK && (count[1] = count[1] + 1) >= Settings.IMP.TICK_LIMITER.FALLING) {
            if (Fawe.get().getTimer().getTPS() < 18.0) {
                this.cancelNearby(cx, cz);
                if (this.rateLimit <= 0) {
                    this.rateLimit = 20;
                    Fawe.debug("[FAWE `tick-limiter`] Detected and cancelled falling block lag source at " + block.getLocation());
                }
                event.setCancelled(true);
                return;
            }
            count[1] = 0;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onChunkLoad(ChunkLoadEvent event) {
        if (!Settings.IMP.TICK_LIMITER.FIREWORKS_LOAD_CHUNKS) {
            Chunk chunk = event.getChunk();
            Entity[] entities = chunk.getEntities();
            World world = chunk.getWorld();
            Exception e = new Exception();
            int start = 14;
            int end = 22;
            int depth = Math.min(end, this.getDepth(e));
            for (int frame = start; frame < depth; ++frame) {
                StackTraceElement elem = this.getElement(e, frame);
                if (elem == null) {
                    return;
                }
                String className = elem.getClassName();
                int len = className.length();
                if (className == null || len <= 15 || className.charAt(len - 15) != 'E' || !className.endsWith("EntityFireworks")) continue;
                for (Entity ent : world.getEntities()) {
                    if (ent.getType() != EntityType.FIREWORK) continue;
                    Vector velocity = ent.getVelocity();
                    double vertical = Math.abs(velocity.getY());
                    if (!(Math.abs(velocity.getX()) > vertical) && !(Math.abs(velocity.getZ()) > vertical)) continue;
                    Fawe.debug("[FAWE `tick-limiter`] Detected and cancelled rogue FireWork at " + ent.getLocation());
                    ent.remove();
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onItemSpawn(ItemSpawnEvent event) {
        int cz;
        if (physicsFreeze) {
            event.setCancelled(true);
            return;
        }
        Location loc = event.getLocation();
        int cx = loc.getBlockX() >> 4;
        int[] count = this.getCount(cx, cz = loc.getBlockZ() >> 4);
        if (count[2] >= Settings.IMP.TICK_LIMITER.ITEMS) {
            event.setCancelled(true);
            return;
        }
        count[2] = count[2] + 1;
        if (count[2] >= Settings.IMP.TICK_LIMITER.ITEMS) {
            this.cleanup(loc.getChunk());
            this.cancelNearby(cx, cz);
            if (this.rateLimit <= 0) {
                this.rateLimit = 20;
                Fawe.debug("[FAWE `tick-limiter`] Detected and cancelled item lag source at " + loc);
            }
            event.setCancelled(true);
            return;
        }
    }
}

