/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.world.registry;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.registry.state.PropertyKey;
import com.sk89q.worldedit.util.gson.VectorAdapter;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.item.ItemType;
import com.sk89q.worldedit.world.item.ItemTypes;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class LegacyMapper {
    private static final Logger log = Logger.getLogger(LegacyMapper.class.getCanonicalName());
    private static LegacyMapper INSTANCE;
    private final Int2ObjectArrayMap<Integer> blockStateToLegacyId4Data = new Int2ObjectArrayMap();
    private final Int2ObjectArrayMap<Integer> extraId4DataToStateId = new Int2ObjectArrayMap();
    private final int[] blockArr = new int[4096];
    private final BiMap<Integer, ItemTypes> itemMap = HashBiMap.create();

    private LegacyMapper() {
        try {
            this.loadFromResource();
        }
        catch (Throwable e) {
            e.printStackTrace();
            log.log(Level.WARNING, "Failed to load the built-in legacy id registry", e);
        }
    }

    private void loadFromResource() throws IOException {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Vector.class, (Object)new VectorAdapter());
        Gson gson = gsonBuilder.disableHtmlEscaping().create();
        URL url = LegacyMapper.class.getResource("legacy.json");
        if (url == null) {
            throw new IOException("Could not find legacy.json");
        }
        String source = Resources.toString((URL)url, (Charset)Charset.defaultCharset());
        LegacyDataFile dataFile = (LegacyDataFile)gson.fromJson(source, new TypeToken<LegacyDataFile>(){}.getType());
        ParserContext parserContext = new ParserContext();
        parserContext.setPreferringWildcard(false);
        parserContext.setRestricted(false);
        parserContext.setTryLegacy(false);
        for (Map.Entry blockEntry : dataFile.blocks.entrySet()) {
            try {
                BlockStateHolder<BlockState> blockState = BlockState.get(null, (String)blockEntry.getValue());
                BlockTypes type = blockState.getBlockType();
                if (type.hasProperty(PropertyKey.WATERLOGGED)) {
                    blockState = blockState.with(PropertyKey.WATERLOGGED, Boolean.valueOf(false));
                }
                int combinedId = this.getCombinedId((String)blockEntry.getKey());
                this.blockArr[combinedId] = blockState.getInternalId();
                this.blockStateToLegacyId4Data.put(blockState.getInternalId(), (Integer)combinedId);
                this.blockStateToLegacyId4Data.putIfAbsent(blockState.getInternalBlockTypeId(), combinedId);
            }
            catch (Exception e) {
                log.fine("Unknown block: " + (String)blockEntry.getValue());
            }
        }
        for (int id = 0; id < 256; ++id) {
            int combinedId = id << 4;
            int base = this.blockArr[combinedId];
            if (base == 0) continue;
            int data = 0;
            while (data < 16) {
                if (this.blockArr[combinedId] == 0) {
                    this.blockArr[combinedId] = base;
                }
                ++data;
                ++combinedId;
            }
        }
        for (Map.Entry itemEntry : dataFile.items.entrySet()) {
            try {
                this.itemMap.put((Object)this.getCombinedId((String)itemEntry.getKey()), (Object)ItemTypes.get((String)itemEntry.getValue()));
            }
            catch (Exception e) {
                log.fine("Unknown item: " + (String)itemEntry.getValue());
            }
        }
    }

    private int getCombinedId(String input) {
        String[] split = input.split(":");
        return (Integer.parseInt(split[0]) << 4) + (split.length == 2 ? Integer.parseInt(split[1]) : 0);
    }

    @Nullable
    public ItemTypes getItemFromLegacy(int legacyId) {
        return (ItemTypes)this.itemMap.get((Object)(legacyId << 4));
    }

    public ItemTypes getItemFromLegacy(String input) {
        if (input.startsWith("minecraft:")) {
            input = input.substring(10);
        }
        return (ItemTypes)this.itemMap.get((Object)this.getCombinedId(input));
    }

    public BlockState getBlockFromLegacy(String input) {
        if (input.startsWith("minecraft:")) {
            input = input.substring(10);
        }
        return BlockState.getFromInternalId(this.blockArr[this.getCombinedId(input)]);
    }

    @Nullable
    public ItemTypes getItemFromLegacy(int legacyId, int data) {
        return (ItemTypes)this.itemMap.get((Object)((legacyId << 4) + data));
    }

    @Nullable
    public Integer getLegacyCombined(ItemType itemType) {
        return (Integer)this.itemMap.inverse().get((Object)itemType);
    }

    @Nullable
    public int[] getLegacyFromItem(ItemType itemType) {
        int[] nArray;
        Integer combinedId = this.getLegacyCombined(itemType);
        if (combinedId == null) {
            nArray = null;
        } else {
            int[] nArray2 = new int[2];
            nArray2[0] = combinedId >> 4;
            nArray = nArray2;
            nArray2[1] = combinedId & 0xF;
        }
        return nArray;
    }

    @Nullable
    public BlockState getBlockFromLegacy(int legacyId) {
        return this.getBlock(legacyId << 4);
    }

    @Nullable
    public BlockState getBlockFromLegacyCombinedId(int combinedId) {
        return this.getBlock(combinedId);
    }

    @Nullable
    public BlockState getBlockFromLegacy(int legacyId, int data) {
        return this.getBlock((legacyId << 4) + data);
    }

    private BlockState getBlock(int combinedId) {
        if (combinedId < this.blockArr.length) {
            try {
                int internalId = this.blockArr[combinedId];
                if (internalId == 0) {
                    return null;
                }
                return BlockState.getFromInternalId(internalId);
            }
            catch (IndexOutOfBoundsException ignore) {
                return null;
            }
        }
        Integer extra = this.extraId4DataToStateId.get(combinedId);
        if (extra == null) {
            extra = this.extraId4DataToStateId.get(combinedId & 0xFF0);
        }
        if (extra != null) {
            return BlockState.getFromInternalId(extra);
        }
        return null;
    }

    public void register(int id, int data, BlockStateHolder state) {
        int combinedId = (id << 4) + data;
        this.extraId4DataToStateId.put(combinedId, (Integer)state.getInternalId());
        this.blockStateToLegacyId4Data.putIfAbsent(state.getInternalId(), combinedId);
    }

    @Nullable
    public Integer getLegacyCombined(BlockState blockState) {
        Integer result = this.blockStateToLegacyId4Data.get(blockState.getInternalId());
        if (result == null) {
            result = this.blockStateToLegacyId4Data.get(blockState.getInternalBlockTypeId());
        }
        return result;
    }

    @Nullable
    public Integer getLegacyCombined(BlockType type) {
        return (Integer)this.blockStateToLegacyId4Data.get(type.getDefaultState());
    }

    @Deprecated
    public int[] getLegacyFromBlock(BlockState blockState) {
        int[] nArray;
        Integer combinedId = this.getLegacyCombined(blockState);
        if (combinedId == null) {
            nArray = null;
        } else {
            int[] nArray2 = new int[2];
            nArray2[0] = combinedId >> 4;
            nArray = nArray2;
            nArray2[1] = combinedId & 0xF;
        }
        return nArray;
    }

    public static LegacyMapper getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LegacyMapper();
        }
        return INSTANCE;
    }

    private static class LegacyDataFile {
        private Map<String, String> blocks;
        private Map<String, String> items;

        private LegacyDataFile() {
        }
    }
}

