/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.registry.state;

import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.registry.state.PropertyKey;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class PropertyGroup<G, A> {
    public static final PropertyGroup<Integer, Integer> LEVEL = new PropertyGroupBuilder().add(PropertyKey.LEVEL).add(PropertyKey.LAYERS, o -> o << 1, o -> o >> 1).setDefault(15).build();
    private final G defaultValue;
    private final PropertyFunction[] states;
    private static final Function VOID_FUNCTION = o -> o;

    private PropertyGroup(PropertyFunction[] states, G defaultValue) {
        this.states = states;
        this.defaultValue = defaultValue;
    }

    public G get(BlockStateHolder state) {
        BlockTypes type = state.getBlockType();
        PropertyFunction func = this.states[type.getInternalId()];
        if (func == null) {
            return this.defaultValue;
        }
        Object value = state.getState(func.key);
        return (G)func.getFunc.apply(value);
    }

    public BlockStateHolder set(BlockStateHolder state, A value) {
        BlockTypes type = state.getBlockType();
        PropertyFunction func = this.states[type.getInternalId()];
        if (func != null) {
            value = func.setFunc.apply(value);
            state = state.with(func.key, value);
        }
        return state;
    }

    public static class PropertyGroupBuilder<G, A> {
        private final List<Object[]> funcs = new ArrayList<Object[]>();
        private G defaultValue;

        public PropertyGroupBuilder add(PropertyKey key) {
            return this.add(key, null, null);
        }

        public PropertyGroupBuilder add(PropertyKey key, Function<Object, G> getProcessor, Function<A, A> setProcessor) {
            if (getProcessor == null) {
                getProcessor = VOID_FUNCTION;
            }
            if (setProcessor == null) {
                setProcessor = VOID_FUNCTION;
            }
            Object[] pf = new Object[]{key, getProcessor, setProcessor};
            this.funcs.add(pf);
            return this;
        }

        public PropertyGroupBuilder setDefault(G value) {
            this.defaultValue = value;
            return this;
        }

        public PropertyGroup build() {
            PropertyFunction[] states = new PropertyFunction[BlockTypes.size()];
            block0: for (BlockTypes type : BlockTypes.values) {
                for (Object[] func : this.funcs) {
                    PropertyFunction pf;
                    Property prop = type.getProperty((PropertyKey)((Object)func[0]));
                    if (prop == null) continue;
                    states[type.getInternalId()] = pf = new PropertyFunction(prop, (Function)func[1], (Function)func[2]);
                    continue block0;
                }
            }
            return new PropertyGroup(states, this.defaultValue);
        }
    }

    private static class PropertyFunction<G, A> {
        private final Function<A, A> setFunc;
        private final Function<G, G> getFunc;
        private final Property key;

        public PropertyFunction(Property key, Function<G, G> getProcessor, Function<A, A> setProcessor) {
            this.key = key;
            this.getFunc = getProcessor;
            this.setFunc = setProcessor;
        }
    }
}

