/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.registry.state;

import com.boydti.fawe.util.MathMan;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.registry.state.PropertyKey;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.List;
import javax.annotation.Nullable;

public class AbstractProperty<T>
implements Property<T> {
    private final PropertyKey key;
    private final String name;
    private final List<T> values;
    private final int bitMask;
    private final int bitMaskInverse;
    private final int bitOffset;
    private final int numBits;

    public AbstractProperty(String name, List<T> values) {
        this(name, values, 0);
    }

    public AbstractProperty(String name, List<T> values, int bitOffset) {
        this.name = name;
        this.values = values;
        this.numBits = MathMan.log2nlz(values.size());
        this.bitOffset = bitOffset + BlockTypes.BIT_OFFSET;
        this.bitMask = (1 << this.numBits) - 1 << this.bitOffset;
        this.bitMaskInverse = ~this.bitMask;
        this.key = PropertyKey.getOrCreate(name);
    }

    @Override
    public PropertyKey getKey() {
        return this.key;
    }

    @Deprecated
    public int getNumBits() {
        return this.numBits;
    }

    @Deprecated
    public int getBitOffset() {
        return this.bitOffset;
    }

    @Deprecated
    public int getBitMask() {
        return this.bitMask;
    }

    public <C extends AbstractProperty<T>> C withOffset(int bitOffset) {
        return (C)new AbstractProperty<T>(this.name, this.values, bitOffset);
    }

    @Deprecated
    public int modify(int state, T value) {
        int index = this.getIndex(value);
        if (index != -1) {
            return this.modifyIndex(state, index);
        }
        return state;
    }

    public int modifyIndex(int state, int index) {
        return state & this.bitMaskInverse | index << this.bitOffset;
    }

    public T getValue(int state) {
        return this.values.get((state & this.bitMask) >> this.bitOffset);
    }

    @Override
    public int getIndex(int state) {
        return (state & this.bitMask) >> this.bitOffset;
    }

    @Override
    public List<T> getValues() {
        return this.values;
    }

    @Override
    @Nullable
    public T getValueFor(String string) throws IllegalArgumentException {
        return (T)string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Property)) {
            return false;
        }
        return this.getName().equals(((Property)obj).getName());
    }
}

