/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.regions.shape;

import com.sk89q.worldedit.BlockVector;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.block.BlockStateHolder;

public abstract class ArbitraryShape {
    protected final Region extent;

    public ArbitraryShape(Region extent) {
        this.extent = extent;
    }

    protected Region getExtent() {
        return this.extent;
    }

    protected abstract BlockStateHolder getMaterial(int var1, int var2, int var3, BlockStateHolder var4);

    public int generate(EditSession editSession, Pattern pattern, boolean hollow) throws MaxChangedBlocksException {
        int affected = 0;
        for (BlockVector position : this.getExtent()) {
            BlockStateHolder material;
            int x = position.getBlockX();
            int y = position.getBlockY();
            int z = position.getBlockZ();
            if (!hollow) {
                material = this.getMaterial(x, y, z, pattern.apply(position));
                if (material == null || !editSession.setBlock((Vector)position, material)) continue;
                ++affected;
                continue;
            }
            material = this.getMaterial(x, y, z, pattern.apply(position));
            if (material == null || !editSession.setBlock((Vector)position, material)) continue;
            ++affected;
        }
        return affected;
    }
}

