/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.mask;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.function.mask.AbstractMask;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.Mask2D;
import com.sk89q.worldedit.function.mask.MaskIntersection2D;
import com.sk89q.worldedit.function.mask.Masks;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class MaskIntersection
extends AbstractMask {
    private final Set<Mask> masks = new LinkedHashSet<Mask>();
    private Mask[] masksArray;

    public MaskIntersection(Collection<Mask> masks) {
        Preconditions.checkNotNull(masks);
        this.masks.addAll(masks);
        this.formArray();
    }

    private void formArray() {
        this.masksArray = this.masks.isEmpty() ? new Mask[]{Masks.alwaysFalse()} : this.masks.toArray(new Mask[this.masks.size()]);
    }

    public Function<Map.Entry<Mask, Mask>, Mask> pairingFunction() {
        return input -> ((Mask)input.getKey()).and((Mask)input.getValue());
    }

    private void optimizeMasks(Set<Mask> ignore) {
        LinkedHashSet<Mask> newMasks = null;
        for (Mask mask : this.masks) {
            if (ignore.contains(mask)) continue;
            Mask newMask = mask.optimize();
            if (newMask != null) {
                if (newMask != mask) {
                    if (newMasks == null) {
                        newMasks = new LinkedHashSet<Mask>();
                    }
                    newMasks.add(newMask);
                }
            } else {
                ignore.add(mask);
            }
            if (newMasks == null) continue;
            this.masks.clear();
            this.masks.addAll(newMasks);
        }
    }

    @Override
    public Mask optimize() {
        HashSet<Mask> optimized = new HashSet<Mask>();
        HashSet<Map.Entry<Mask, Mask>> failedCombines = new HashSet<Map.Entry<Mask, Mask>>();
        while (this.combine(this.pairingFunction(), failedCombines)) {
        }
        do {
            this.optimizeMasks(optimized);
        } while (this.combine(this.pairingFunction(), failedCombines));
        this.formArray();
        if (this.masks.size() == 0) {
            return Masks.alwaysTrue();
        }
        if (this.masks.size() == 1) {
            return this.masks.iterator().next();
        }
        return this;
    }

    private boolean combine(Function<Map.Entry<Mask, Mask>, Mask> pairing, Set<Map.Entry<Mask, Mask>> failedCombines) {
        boolean hasOptimized = false;
        while (true) {
            Mask[] result = null;
            block1: for (Mask mask : this.masks) {
                for (Mask other : this.masks) {
                    AbstractMap.SimpleEntry<Mask, Mask> pair = new AbstractMap.SimpleEntry<Mask, Mask>(mask, other);
                    if (failedCombines.contains(pair)) continue;
                    Mask combined = (Mask)pairing.apply(pair);
                    if (combined != null) {
                        result = new Mask[]{combined, mask, other};
                        break block1;
                    }
                    failedCombines.add(pair);
                }
            }
            if (result == null) break;
            this.masks.remove(result[1]);
            this.masks.remove(result[2]);
            this.masks.add((Mask)result[0]);
            hasOptimized = true;
        }
        return hasOptimized;
    }

    public MaskIntersection(Mask ... mask) {
        this(Arrays.asList((Object[])Preconditions.checkNotNull((Object)mask)));
    }

    public void add(Collection<Mask> masks) {
        Preconditions.checkNotNull(masks);
        this.masks.addAll(masks);
        this.formArray();
    }

    public void add(Mask ... mask) {
        this.add(Arrays.asList((Object[])Preconditions.checkNotNull((Object)mask)));
    }

    public Collection<Mask> getMasks() {
        return this.masks;
    }

    public final Mask[] getMasksArray() {
        return this.masksArray;
    }

    @Override
    public boolean test(Vector vector) {
        for (Mask mask : this.masksArray) {
            if (mask.test(vector)) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public Mask2D toMask2D() {
        ArrayList<Mask2D> mask2dList = new ArrayList<Mask2D>();
        for (Mask mask : this.masks) {
            Mask2D mask2d = mask.toMask2D();
            if (mask2d != null) {
                mask2dList.add(mask2d);
                continue;
            }
            return null;
        }
        return new MaskIntersection2D(mask2dList);
    }
}

