/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.blocks;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public enum ClothColor {
    WHITE("White", "white"),
    ORANGE("Orange", "orange"),
    MAGENTA("Magenta", "magenta"),
    LIGHT_BLUE("Light blue", "lightblue"),
    YELLOW("Yellow", "yellow"),
    LIGHT_GREEN("Light green", "lightgreen"),
    PINK("Pink", "pink", "lightred"),
    GRAY("Gray", "grey", "gray"),
    LIGHT_GRAY("Light gray", "lightgrey", "lightgray"),
    CYAN("Cyan", "cyan", "turquoise"),
    PURPLE("Purple", "purple", "violet"),
    BLUE("Blue", "blue"),
    BROWN("Brown", "brown", "cocoa", "coffee"),
    DARK_GREEN("Dark green", "green", "darkgreen", "cactusgreen", "cactigreen"),
    RED("Red", "red"),
    BLACK("Black", "black");

    private static final Map<String, ClothColor> lookup;
    private final String name;
    private final String[] lookupKeys;

    private ClothColor(String name, String ... lookupKeys) {
        this.name = name;
        this.lookupKeys = lookupKeys;
    }

    @Nullable
    public static ClothColor lookup(String name) {
        return lookup.get(name.toLowerCase());
    }

    public String getName() {
        return this.name;
    }

    static {
        lookup = new HashMap<String, ClothColor>();
        for (ClothColor type : EnumSet.allOf(ClothColor.class)) {
            for (String key : type.lookupKeys) {
                lookup.put(key, type);
            }
        }
    }
}

