/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.util;

import com.boydti.fawe.config.BBC;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.object.FaweLocation;
import com.boydti.fawe.object.FawePlayer;
import com.boydti.fawe.object.RegionWrapper;
import com.boydti.fawe.object.exception.FaweException;
import com.boydti.fawe.object.extent.NullExtent;
import com.boydti.fawe.regions.FaweMask;
import com.boydti.fawe.regions.FaweMaskManager;
import com.boydti.fawe.util.MainUtil;
import com.boydti.fawe.util.SetQueue;
import com.boydti.fawe.util.TaskManager;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.regions.Region;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;

public class WEManager {
    public static final WEManager IMP = new WEManager();
    public final ArrayDeque<FaweMaskManager> managers = new ArrayDeque();

    public void cancelEditSafe(Extent parent, BBC reason) throws FaweException {
        try {
            Field field = AbstractDelegateExtent.class.getDeclaredField("extent");
            field.setAccessible(true);
            Object currentExtent = field.get(parent);
            if (!(currentExtent instanceof NullExtent)) {
                field.set(parent, new NullExtent((Extent)field.get(parent), reason));
            }
        }
        catch (Exception e) {
            MainUtil.handleError(e);
        }
        throw new FaweException(reason);
    }

    public void cancelEdit(Extent parent, BBC reason) throws WorldEditException {
        this.cancelEditSafe(parent, reason);
    }

    public boolean maskContains(HashSet<RegionWrapper> mask, int x, int z) {
        for (RegionWrapper region : mask) {
            if (x < region.minX || x > region.maxX || z < region.minZ || z > region.maxZ) continue;
            return true;
        }
        return false;
    }

    public boolean maskContains(RegionWrapper[] mask, int x, int z) {
        switch (mask.length) {
            case 0: {
                return false;
            }
            case 1: {
                return mask[0].isIn(x, z);
            }
        }
        for (RegionWrapper region : mask) {
            if (!region.isIn(x, z)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public Region[] getMask(FawePlayer<?> player) {
        return this.getMask(player, FaweMaskManager.MaskType.getDefaultMaskType());
    }

    public boolean isIn(int x, int y, int z, Region region) {
        return region.contains(x, y, z);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Region[] getMask(FawePlayer<?> player, FaweMaskManager.MaskType type) {
        FaweMask mask2;
        if (!Settings.IMP.REGION_RESTRICTIONS || player.hasPermission("fawe.bypass") || player.hasPermission("fawe.bypass.regions")) {
            return new Region[]{RegionWrapper.GLOBAL()};
        }
        FaweLocation loc = player.getLocation();
        String world = loc.world;
        if (!world.equals(player.getMeta("lastMaskWorld"))) {
            player.deleteMeta("lastMaskWorld");
            player.deleteMeta("lastMask");
        }
        player.setMeta("lastMaskWorld", world);
        HashSet<FaweMask> masks = (HashSet<FaweMask>)player.getMeta("lastMask");
        HashSet<Region> backupRegions = new HashSet<Region>();
        Set<Object> regions = new HashSet<Region>();
        if (masks == null) {
            masks = new HashSet<FaweMask>();
        } else {
            HashSet<FaweMask> hashSet = masks;
            synchronized (hashSet) {
                boolean removed = false;
                if (!masks.isEmpty()) {
                    Iterator iter = masks.iterator();
                    while (iter.hasNext()) {
                        mask2 = (FaweMask)iter.next();
                        if (mask2.isValid(player, type)) {
                            Region region = mask2.getRegion();
                            if (region.contains(loc.x, loc.y, loc.z)) {
                                regions.add(region);
                                continue;
                            }
                            removed = true;
                            backupRegions.add(region);
                            continue;
                        }
                        removed = true;
                        iter.remove();
                    }
                }
                if (!removed) {
                    return regions.toArray(new Region[regions.size()]);
                }
                masks.clear();
            }
        }
        HashSet tmpMasks = new HashSet();
        for (FaweMaskManager manager : this.managers) {
            if (!player.hasPermission("fawe." + manager.getKey())) continue;
            try {
                if (manager.isExclusive() && !masks.isEmpty() || (mask2 = manager.getMask(player, FaweMaskManager.MaskType.getDefaultMaskType())) == null) continue;
                regions.add(mask2.getRegion());
                masks.add(mask2);
                if (!manager.isExclusive()) continue;
                break;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (!tmpMasks.isEmpty()) {
            masks = tmpMasks;
            regions = masks.stream().map(mask -> mask.getRegion()).collect(Collectors.toSet());
        } else {
            regions.addAll(backupRegions);
        }
        if (!masks.isEmpty()) {
            player.setMeta("lastMask", masks);
        } else {
            player.deleteMeta("lastMask");
        }
        return regions.toArray(new Region[regions.size()]);
    }

    public boolean intersects(Region region1, Region region2) {
        Vector rg1P1 = region1.getMinimumPoint();
        Vector rg1P2 = region1.getMaximumPoint();
        Vector rg2P1 = region2.getMinimumPoint();
        Vector rg2P2 = region2.getMaximumPoint();
        return rg1P1.getBlockX() <= rg2P2.getBlockX() && rg1P2.getBlockX() >= rg2P1.getBlockX() && rg1P1.getBlockZ() <= rg2P2.getBlockZ() && rg1P2.getBlockZ() >= rg2P1.getBlockZ();
    }

    public boolean regionContains(Region selection, HashSet<Region> mask) {
        for (Region region : mask) {
            if (!this.intersects(region, selection)) continue;
            return true;
        }
        return false;
    }

    public boolean delay(final FawePlayer<?> player, final String command) {
        final long start = System.currentTimeMillis();
        return this.delay(player, new Runnable(){

            @Override
            public void run() {
                try {
                    if (System.currentTimeMillis() - start > 1000L) {
                        BBC.WORLDEDIT_RUN.send(FawePlayer.wrap(player), new Object[0]);
                    }
                    TaskManager.IMP.task(new Runnable(){

                        @Override
                        public void run() {
                            final long start = System.currentTimeMillis();
                            player.executeCommand(command.substring(1));
                            TaskManager.IMP.later(new Runnable(){

                                @Override
                                public void run() {
                                    SetQueue.IMP.addEmptyTask(new Runnable(){

                                        @Override
                                        public void run() {
                                            if (System.currentTimeMillis() - start > 1000L) {
                                                BBC.WORLDEDIT_COMPLETE.send(FawePlayer.wrap(player), new Object[0]);
                                            }
                                        }
                                    });
                                }
                            }, 2);
                        }
                    });
                }
                catch (Exception e) {
                    MainUtil.handleError(e);
                }
            }
        }, false, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean delay(FawePlayer<?> player, Runnable whenDone, boolean delayed, boolean onlyDelayedExecution) {
        boolean free = SetQueue.IMP.addEmptyTask(null);
        if (free) {
            if (delayed) {
                if (whenDone == null) return true;
                whenDone.run();
                return true;
            } else {
                if (whenDone == null || onlyDelayedExecution) return false;
                whenDone.run();
            }
            return true;
        } else {
            if (!delayed && player != null) {
                BBC.WORLDEDIT_DELAYED.send(player, new Object[0]);
            }
            SetQueue.IMP.addEmptyTask(whenDone);
        }
        return true;
    }
}

