/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.brush.heightmap;

public class AverageHeightMapFilter {
    private int[] inData;
    private int[] buffer;
    private final int width;
    private final int height;
    private final int minY;
    private final int maxY;

    public AverageHeightMapFilter(int[] inData, int width, int height, int minY, int maxY) {
        this.inData = inData;
        this.width = width;
        this.height = height;
        this.minY = minY;
        this.maxY = maxY;
        this.buffer = new int[inData.length];
    }

    public int[] filter(int iterations) {
        for (int j = 0; j < iterations; ++j) {
            int a = -this.width;
            int b = this.width;
            int c = 1;
            int d = -1;
            int i = 0;
            while (i < this.inData.length) {
                int average;
                int height = this.inData[i];
                this.buffer[i] = height < this.minY || height > this.maxY ? height : (average = 2 + this.get(a, height) + this.get(b, height) + this.get(c, height) + this.get(d, height) >> 2);
                ++i;
                ++a;
                ++b;
                ++c;
                ++d;
            }
            int[] tmp = this.inData;
            this.inData = this.buffer;
            this.buffer = tmp;
        }
        return this.inData;
    }

    private int get(int index, int def) {
        int val = this.inData[Math.max(0, Math.min(this.inData.length - 1, index))];
        if (val < this.minY || val > this.maxY) {
            return def;
        }
        return val;
    }
}

