/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.jnbt.anvil.generator;

import com.boydti.fawe.jnbt.anvil.generator.GenBase;
import com.boydti.fawe.object.PseudoRandom;
import com.boydti.fawe.util.MathMan;
import com.sk89q.worldedit.Vector2D;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;

public class CavesGen
extends GenBase {
    private boolean evenCaveDistribution = false;
    private int caveFrequency = 40;
    private int caveRarity = 7;
    private int caveMinAltitude = 8;
    private int caveMaxAltitude = 127;
    private int caveSystemFrequency = 1;
    private int individualCaveRarity = 25;
    private int caveSystemPocketChance = 0;
    private int caveSystemPocketMinSize = 0;
    private int caveSystemPocketMaxSize = 3;

    public CavesGen(int caveSize) {
        super(caveSize);
    }

    public CavesGen(int caveSize, int caveFrequency, int caveRarity, int caveMinAltitude, int caveMaxAltitude, int caveSystemFrequency, int individualCaveRarity, int caveSystemPocketChance, int caveSystemPocketMinSize, int caveSystemPocketMaxSize) {
        super(caveSize);
        this.caveFrequency = caveFrequency;
        this.caveRarity = caveRarity;
        this.caveMinAltitude = caveMinAltitude;
        this.caveMaxAltitude = caveMaxAltitude;
        this.caveSystemFrequency = caveSystemFrequency;
        this.individualCaveRarity = individualCaveRarity;
        this.caveSystemPocketChance = caveSystemPocketChance;
        this.caveSystemPocketMinSize = caveSystemPocketMinSize;
        this.caveSystemPocketMaxSize = caveSystemPocketMaxSize;
    }

    protected void generateLargeCaveNode(long seed, Vector2D pos, Extent chunk, double x, double y, double z) throws WorldEditException {
        this.generateCaveNode(seed, pos, chunk, x, y, z, 1.0 + PseudoRandom.random.nextDouble() * 6.0, 0.0, 0.0, -1, -1, 0.5);
    }

    protected void generateCaveNode(long seed, Vector2D chunkPos, Extent chunk, double x, double y, double z, double paramdouble1, double paramdouble2, double paramdouble3, int angle, int maxAngle, double paramDouble4) throws WorldEditException {
        boolean k;
        int bx = chunkPos.getBlockX() << 4;
        int bz = chunkPos.getBlockZ() << 4;
        double real_x = bx + 7;
        double real_z = bz + 7;
        double f1 = 0.0;
        double f2 = 0.0;
        PseudoRandom localRandom = new PseudoRandom(seed);
        if (maxAngle <= 0) {
            int checkAreaSize = this.getCheckAreaSize() * 16 - 16;
            maxAngle = checkAreaSize - localRandom.nextInt(checkAreaSize / 4);
        }
        boolean isLargeCave = false;
        if (angle == -1) {
            angle = maxAngle / 2;
            isLargeCave = true;
        }
        int j = localRandom.nextInt(maxAngle / 2) + maxAngle / 4;
        boolean bl = k = localRandom.nextInt(6) == 0;
        while (angle < maxAngle) {
            double d3 = 1.5 + (double)MathMan.sinInexact((float)angle * 3.141593f / (float)maxAngle) * paramdouble1 * 1.0;
            double d4 = d3 * paramDouble4;
            double f3 = MathMan.cosInexact(paramdouble3);
            double f4 = MathMan.sinInexact(paramdouble3);
            x += (double)MathMan.cosInexact(paramdouble2) * f3;
            y += f4;
            z += (double)MathMan.sinInexact(paramdouble2) * f3;
            paramdouble3 = k ? (paramdouble3 *= (double)0.92f) : (paramdouble3 *= (double)0.7f);
            paramdouble3 += f2 * (double)0.1f;
            paramdouble2 += f1 * (double)0.1f;
            f2 *= (double)0.9f;
            f1 *= 0.75;
            f2 += (localRandom.nextDouble() - localRandom.nextDouble()) * localRandom.nextDouble() * 2.0;
            f1 += (localRandom.nextDouble() - localRandom.nextDouble()) * localRandom.nextDouble() * 4.0;
            if (!isLargeCave && angle == j && paramdouble1 > 1.0 && maxAngle > 0) {
                this.generateCaveNode(localRandom.nextLong(), chunkPos, chunk, x, y, z, localRandom.nextDouble() * 0.5 + 0.5, paramdouble2 - 1.570796012878418, paramdouble3 / 3.0, angle, maxAngle, 1.0);
                this.generateCaveNode(localRandom.nextLong(), chunkPos, chunk, x, y, z, localRandom.nextDouble() * 0.5 + 0.5, paramdouble2 + 1.570796012878418, paramdouble3 / 3.0, angle, maxAngle, 1.0);
                return;
            }
            if (isLargeCave || localRandom.nextInt(4) != 0) {
                double d5 = x - real_x;
                double d6 = z - real_z;
                double d7 = maxAngle - angle;
                double d8 = paramdouble1 + 2.0 + 16.0;
                if (d5 * d5 + d6 * d6 - d7 * d7 > d8 * d8) {
                    return;
                }
                if (!(x < real_x - 16.0 - d3 * 2.0 || z < real_z - 16.0 - d3 * 2.0 || x > real_x + 16.0 + d3 * 2.0 || z > real_z + 16.0 + d3 * 2.0)) {
                    int local_x;
                    int m = (int)(x - d3) - bx - 1;
                    int n = (int)(x + d3) - bx + 1;
                    int i1 = (int)(y - d4) - 1;
                    int i2 = (int)(y + d4) + 1;
                    int i3 = (int)(z - d3) - bz - 1;
                    int i4 = (int)(z + d3) - bz + 1;
                    if (m < 0) {
                        m = 0;
                    }
                    if (n > 16) {
                        n = 16;
                    }
                    if (i1 < 1) {
                        i1 = 1;
                    }
                    if (i2 > 248) {
                        i2 = 248;
                    }
                    if (i3 < 0) {
                        i3 = 0;
                    }
                    if (i4 > 16) {
                        i4 = 16;
                    }
                    boolean waterFound = false;
                    for (local_x = m; !waterFound && local_x < n; ++local_x) {
                        for (int local_z = i3; !waterFound && local_z < i4; ++local_z) {
                            for (int local_y = i2 + 1; !waterFound && local_y >= i1 - 1; --local_y) {
                                if (local_y < 0 || local_y >= 255) continue;
                                BlockState material = chunk.getLazyBlock(bx + local_x, local_y, bz + local_z);
                                if (material.getBlockType() == BlockTypes.WATER) {
                                    waterFound = true;
                                }
                                if (local_y == i1 - 1 || local_x == m || local_x == n - 1 || local_z == i3 || local_z == i4 - 1) continue;
                                local_y = i1;
                            }
                        }
                    }
                    if (!waterFound) {
                        for (local_x = m; local_x < n; ++local_x) {
                            double d9 = ((double)(local_x + bx) + 0.5 - x) / d3;
                            for (int local_z = i3; local_z < i4; ++local_z) {
                                double d10 = ((double)(local_z + bz) + 0.5 - z) / d3;
                                boolean grassFound = false;
                                if (!(d9 * d9 + d10 * d10 < 1.0)) continue;
                                for (int local_y = i2; local_y > i1; --local_y) {
                                    BlockState block;
                                    double d11 = ((double)(local_y - 1) + 0.5 - y) / d4;
                                    if (!(d11 > -0.7) || !(d9 * d9 + d11 * d11 + d10 * d10 < 1.0)) continue;
                                    BlockState material = chunk.getLazyBlock(bx + local_x, local_y, bz + local_z);
                                    BlockState materialAbove = chunk.getLazyBlock(bx + local_x, local_y + 1, bz + local_z);
                                    switch (material.getBlockType()) {
                                        case GRASS: 
                                        case MYCELIUM: {
                                            grassFound = true;
                                        }
                                    }
                                    if (!this.isSuitableBlock(material, materialAbove)) continue;
                                    if (local_y - 1 < 10) {
                                        chunk.setBlock(bx + local_x, local_y, bz + local_z, BlockTypes.LAVA.getDefaultState());
                                        continue;
                                    }
                                    chunk.setBlock(bx + local_x, local_y, bz + local_z, BlockTypes.CAVE_AIR.getDefaultState());
                                    if (!grassFound || (block = chunk.getLazyBlock(bx + local_x, local_y - 1, bz + local_z)).getBlockType() != BlockTypes.DIRT) continue;
                                    chunk.setBlock(bx + local_x, local_y - 1, bz + local_z, BlockTypes.STONE.getDefaultState());
                                }
                            }
                        }
                        if (isLargeCave) break;
                    }
                }
            }
            ++angle;
        }
    }

    protected boolean isSuitableBlock(BlockStateHolder material, BlockStateHolder materialAbove) {
        switch (material.getBlockType()) {
            case AIR: 
            case CAVE_AIR: 
            case VOID_AIR: 
            case WATER: 
            case LAVA: 
            case BEDROCK: {
                return false;
            }
        }
        return true;
    }

    @Override
    public void generateChunk(Vector2D adjacentChunk, Vector2D originChunk, Extent chunk) throws WorldEditException {
        PseudoRandom random = this.getRandom();
        int i = random.nextInt(random.nextInt(random.nextInt(this.caveFrequency) + 1) + 1);
        if (this.evenCaveDistribution) {
            i = this.caveFrequency;
        }
        if (random.nextInt(100) >= this.caveRarity) {
            i = 0;
        }
        for (int j = 0; j < i; ++j) {
            double x = (adjacentChunk.getBlockX() << 4) + random.nextInt(16);
            double y = this.evenCaveDistribution ? (double)random.nextInt(this.caveMinAltitude, this.caveMaxAltitude) : (double)(random.nextInt(random.nextInt(this.caveMaxAltitude - this.caveMinAltitude + 1) + 1) + this.caveMinAltitude);
            double z = (adjacentChunk.getBlockZ() << 4) + random.nextInt(16);
            int count = this.caveSystemFrequency;
            boolean largeCaveSpawned = false;
            if (random.nextInt(100) <= this.individualCaveRarity) {
                this.generateLargeCaveNode(random.nextLong(), originChunk, chunk, x, y, z);
                largeCaveSpawned = true;
            }
            if (largeCaveSpawned || random.nextInt(100) <= this.caveSystemPocketChance - 1) {
                count += random.nextInt(this.caveSystemPocketMinSize, this.caveSystemPocketMaxSize);
            }
            while (count > 0) {
                --count;
                double f1 = random.nextDouble() * (double)3.141593f * 2.0;
                double f2 = (random.nextDouble() - 0.5) * 2.0 / 8.0;
                double f3 = random.nextDouble() * 2.0 + random.nextDouble();
                this.generateCaveNode(random.nextLong(), originChunk, chunk, x, y, z, f3, f1, f2, 0, 0, 1.0);
            }
        }
    }
}

