/*
 * Decompiled with CFR 0.152.
 */
package me.efnilite.skematic.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import org.bukkit.event.Event;

@Name(value="Selection dimensions")
@Description(value={"Get one of the region dimensions of a player's selection."})
@Examples(value={"set {area} to the length of player's selection"})
@Since(value="1.0.0")
public class ExprCuboidRegionDimensions
extends SimpleExpression<Number> {
    private Expression<CuboidRegion> region;
    private Dimension dimension;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parser) {
        this.dimension = Dimension.values()[parser.mark - 1];
        this.region = exprs[0];
        return true;
    }

    protected Number[] get(Event e) {
        Region r = (Region)this.region.getSingle(e);
        if (r == null) {
            return null;
        }
        Integer t = null;
        switch (this.dimension) {
            case LONG: {
                t = ((CuboidRegion)this.region.getSingle(e)).getLength();
                break;
            }
            case HIGH: {
                t = ((CuboidRegion)this.region.getSingle(e)).getHeight();
                break;
            }
            case WIDE: {
                t = ((CuboidRegion)this.region.getSingle(e)).getWidth();
            }
        }
        return new Number[]{t};
    }

    public String toString(Event e, boolean debug) {
        return "get the dimensions of the region " + this.region.toString(e, debug);
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Number> getReturnType() {
        return Number.class;
    }

    static {
        Skript.registerExpression(ExprCuboidRegionDimensions.class, Number.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] [(skematic|fawe)] (1\u00a6length|2\u00a6height|3\u00a6width) of %cuboidregions%", "[the] %cuboidregions%'s [(skematic|fawe)] (1\u00a6length|2\u00a6height|3\u00a6width)"});
    }

    static enum Dimension {
        LONG,
        HIGH,
        WIDE;

    }
}

