/*
 * Decompiled with CFR 0.152.
 */
package me.efnilite.skematic.elements.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.world.World;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Create region")
@Description(value={"Create a virtual region (for saving schematics, etc.)"})
@Examples(value={"create a new cuboidregion from {_location} to {_location-2}", "set {_region} to the last created region"})
@Since(value="1.1.0")
public class ExprCuboidRegion
extends SimpleExpression<CuboidRegion> {
    private static CuboidRegion[] last;
    private Expression<Location> position1;
    private Expression<Location> position2;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.position1 = exprs[0];
        this.position2 = exprs[1];
        return true;
    }

    protected CuboidRegion[] get(Event e) {
        Location p1 = (Location)this.position1.getSingle(e);
        Location p2 = (Location)this.position2.getSingle(e);
        if (p1 == null || p2 == null) {
            return null;
        }
        org.bukkit.World w = p1.getWorld();
        if (p1.getWorld() == null) {
            w = p2.getWorld();
        }
        CuboidRegion cuboid = new CuboidRegion((World)BukkitUtil.getLocalWorld((org.bukkit.World)w), new Vector(p1.getBlockX(), p1.getBlockY(), p1.getBlockZ()), new Vector(p2.getBlockX(), p2.getBlockY(), p2.getBlockZ()));
        last = new CuboidRegion[]{cuboid};
        return last;
    }

    public String toString(Event e, boolean debug) {
        return "create a new cuboidregion between " + this.position1.toString(e, debug) + " and " + this.position2.toString(e, debug);
    }

    public Class<? extends CuboidRegion> getReturnType() {
        return CuboidRegion.class;
    }

    public boolean isSingle() {
        return true;
    }

    static CuboidRegion[] getLastCuboidRegion() {
        return last;
    }

    static {
        Skript.registerExpression(ExprCuboidRegion.class, CuboidRegion.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[a] [new] (cuboid|we|wordedit)[ ]region from %location% to %location%"});
    }
}

