/*
 * Decompiled with CFR 0.152.
 */
package me.efnilite.skematic.elements.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import com.boydti.fawe.FaweAPI;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.world.World;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Drain liquids")
@Description(value={"Drain all liquids at a certain location with a radius."})
@Examples(value={"drain all liquids at 124, 32, 12 in \"world\" in a radius of 10"})
@Since(value="1.0.1")
public class EffDrain
extends Effect {
    private Expression<World> world;
    private Expression<Location> position;
    private Expression<Number> radius;

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.position = exprs[0];
        this.radius = exprs[2];
        this.world = exprs[1];
        return true;
    }

    protected void execute(Event e) {
        Location l = (Location)this.position.getSingle(e);
        World w = (World)this.world.getSingle(e);
        Number r = (Number)this.radius.getSingle(e);
        if (r == null || w == null || l == null) {
            return;
        }
        EditSession s = FaweAPI.getEditSessionBuilder((World)w).autoQueue(Boolean.valueOf(true)).build();
        s.drainArea(new Vector(l.getBlockX(), l.getBlockY(), l.getBlockZ()), ((Double)r).doubleValue());
        s.flushQueue();
    }

    public String toString(Event e, boolean debug) {
        return "drain area " + this.position.toString(e, debug) + " with radius " + this.radius.toString(e, debug) + " in world " + this.world.toString(e, debug);
    }

    static {
        Skript.registerEffect(EffDrain.class, (String[])new String[]{"drain [all] [(skematic|fawe)] [liquid[s]] [at] %location% (in|within) [a] radius [of] %number%"});
    }
}

