/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.util.report;

import com.google.common.base.Preconditions;
import com.sk89q.worldedit.util.report.DataReport;
import com.sk89q.worldedit.util.report.Unreported;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ShallowObjectReport
extends DataReport {
    private static final Logger log = Logger.getLogger(ShallowObjectReport.class.getCanonicalName());

    public ShallowObjectReport(String title, Object object) {
        super(title);
        Preconditions.checkNotNull((Object)object, (Object)"object");
        Class<?> type = object.getClass();
        for (Field field : type.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) || field.getAnnotation(Unreported.class) != null) continue;
            field.setAccessible(true);
            try {
                Object value = field.get(object);
                this.append(field.getName(), String.valueOf(value));
            }
            catch (IllegalAccessException e) {
                log.log(Level.WARNING, "Failed to get value of '" + field.getName() + "' on " + type);
            }
        }
    }
}

