/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.function.mask;

import com.boydti.fawe.object.collection.FastBitSet;
import com.boydti.fawe.util.MainUtil;
import com.boydti.fawe.util.StringMan;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.extent.NullExtent;
import com.sk89q.worldedit.function.mask.AbstractExtentMask;
import com.sk89q.worldedit.function.mask.BlockMaskBuilder;
import com.sk89q.worldedit.function.mask.BlockTypeMask;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.Mask2D;
import com.sk89q.worldedit.function.mask.Masks;
import com.sk89q.worldedit.function.mask.SingleBlockStateBitMask;
import com.sk89q.worldedit.function.mask.SingleBlockStateMask;
import com.sk89q.worldedit.function.mask.SingleBlockTypeMask;
import com.sk89q.worldedit.registry.state.AbstractProperty;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;

public class BlockMask
extends AbstractExtentMask {
    private final long[][] bitSets;
    protected static final long[] ALL = new long[0];

    @Deprecated
    public BlockMask(Extent extent, BaseBlock ... blocks) {
        super(extent);
        MainUtil.warnDeprecated(BlockMaskBuilder.class);
        this.bitSets = new BlockMaskBuilder().addBlocks(blocks).optimize().getBits();
    }

    public BlockMask() {
        super(NullExtent.INSTANCE);
        this.bitSets = new long[BlockTypes.size()][];
    }

    protected BlockMask(Extent extent, long[][] bitSets) {
        super(extent);
        this.bitSets = bitSets;
    }

    public BlockMaskBuilder toBuilder() {
        return new BlockMaskBuilder(this.bitSets);
    }

    public String toString() {
        ArrayList<String> strings = new ArrayList<String>();
        for (int i = 0; i < this.bitSets.length; ++i) {
            if (this.bitSets[i] == null) continue;
            long[] set = this.bitSets[i];
            BlockTypes type = BlockTypes.get(i);
            if (set == ALL) {
                strings.add(type.getId());
                continue;
            }
            for (BlockState state : type.getAllStates()) {
                if (!this.test(state)) continue;
                strings.add(state.getAsString());
            }
        }
        return StringMan.join(strings, ",");
    }

    @Override
    public Mask optimize() {
        HashMap<long[], Integer> states = new HashMap<long[], Integer>();
        int indexFound = -1;
        int indexNull = -1;
        int indexAll = -1;
        for (int i = 0; i < this.bitSets.length; ++i) {
            long[] bs = this.bitSets[i];
            if (bs == null) {
                indexNull = i;
                states.put(null, states.getOrDefault(null, 0) + 1);
                continue;
            }
            if (bs.length == 0) {
                indexAll = i;
                states.put(ALL, states.getOrDefault(ALL, 0) + 1);
                continue;
            }
            if (indexFound == -1) {
                indexFound = i;
                continue;
            }
            return this;
        }
        if (indexFound == -1) {
            if (states.size() == 1) {
                return states.keySet().iterator().next() == null ? Masks.alwaysFalse() : Masks.alwaysTrue();
            }
            if ((Integer)states.get(ALL) == 1) {
                return new SingleBlockTypeMask(this.getExtent(), BlockTypes.get(indexAll));
            }
            if ((Integer)states.get(null) == 1) {
                return new SingleBlockTypeMask(this.getExtent(), BlockTypes.get(indexNull)).inverse();
            }
            boolean[] types = new boolean[BlockTypes.size()];
            for (int i = 0; i < this.bitSets.length; ++i) {
                if (this.bitSets[i].length != 0) continue;
                types[i] = true;
            }
            return new BlockTypeMask(this.getExtent(), types);
        }
        BlockTypes type = BlockTypes.get(indexFound);
        Mask mask = this.getOptimizedMask(type, this.bitSets[indexFound]);
        if (mask == null) {
            long[] newBitSet = this.bitSets[indexFound];
            for (int i = 0; i < newBitSet.length; ++i) {
                newBitSet[i] = newBitSet[i] ^ 0xFFFFFFFFFFFFFFFFL;
            }
            mask = this.getOptimizedMask(type, this.bitSets[indexFound]);
            if (mask != null) {
                mask = mask.inverse();
            }
        }
        return mask;
    }

    private Mask getOptimizedMask(BlockType type, long[] bitSet) {
        boolean single = true;
        int and = type.getInternalId();
        List<? extends Property> properties = type.getProperties();
        for (AbstractProperty abstractProperty : type.getProperties()) {
            List values = abstractProperty.getValues();
            int numSet = 0;
            for (int i = 0; i < values.size(); ++i) {
                int localI = i << abstractProperty.getBitOffset();
                if (!FastBitSet.get(bitSet, localI)) continue;
                ++numSet;
                and |= abstractProperty.modify(and, i);
            }
            if (numSet != values.size() && numSet != 1) {
                return null;
            }
            single = single && numSet == 1;
        }
        if (single) {
            return new SingleBlockStateMask(this.getExtent(), BlockState.getFromInternalId(and));
        }
        return new SingleBlockStateBitMask(this.getExtent(), and);
    }

    @Override
    public Mask and(Mask other) {
        if (other instanceof BlockMask) {
            long[][] otherBitSets = ((BlockMask)other).bitSets;
            for (int i = 0; i < otherBitSets.length; ++i) {
                long[] otherBitSet = otherBitSets[i];
                long[] bitSet = this.bitSets[i];
                if (otherBitSet == null) {
                    this.bitSets[i] = null;
                    continue;
                }
                if (otherBitSet.length == 0 || bitSet == null) continue;
                if (bitSet.length == 0) {
                    this.bitSets[i] = otherBitSet;
                    continue;
                }
                for (int j = 0; j < otherBitSet.length; ++j) {
                    int n = j;
                    bitSet[n] = bitSet[n] & otherBitSet[j];
                }
            }
            return this;
        }
        if (other instanceof SingleBlockStateMask) {
            return new BlockMaskBuilder(this.bitSets).filter(((SingleBlockStateMask)other).getBlockState()).build(this.getExtent());
        }
        if (other instanceof SingleBlockTypeMask) {
            return new BlockMaskBuilder(this.bitSets).filter(((SingleBlockTypeMask)other).getBlockType()).build(this.getExtent());
        }
        return null;
    }

    @Override
    public Mask or(Mask other) {
        if (other instanceof BlockMask) {
            long[][] otherBitSets = ((BlockMask)other).bitSets;
            for (int i = 0; i < otherBitSets.length; ++i) {
                long[] otherBitSet = otherBitSets[i];
                long[] bitSet = this.bitSets[i];
                if (otherBitSet == null) continue;
                if (otherBitSet.length == 0) {
                    this.bitSets[i] = ALL;
                    continue;
                }
                if (bitSet == null) {
                    this.bitSets[i] = otherBitSet;
                    continue;
                }
                if (bitSet.length == 0) continue;
                for (int j = 0; j < otherBitSet.length; ++j) {
                    int n = j;
                    bitSet[n] = bitSet[n] | otherBitSet[j];
                }
            }
            return this;
        }
        if (other instanceof SingleBlockStateMask) {
            return new BlockMaskBuilder(this.bitSets).add(((SingleBlockStateMask)other).getBlockState()).build(this.getExtent());
        }
        if (other instanceof SingleBlockTypeMask) {
            return new BlockMaskBuilder(this.bitSets).add(((SingleBlockTypeMask)other).getBlockType()).build(this.getExtent());
        }
        return null;
    }

    @Override
    public Mask inverse() {
        for (int i = 0; i < this.bitSets.length; ++i) {
            if (this.bitSets[i] == null) {
                this.bitSets[i] = ALL;
                continue;
            }
            if (this.bitSets[i] == ALL) {
                this.bitSets[i] = null;
                continue;
            }
            for (int j = 0; j < this.bitSets[i].length; ++j) {
                this.bitSets[i][j] = this.bitSets[i][j] ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
        return this;
    }

    public boolean test(BlockState block) {
        long[] bitSet = this.bitSets[block.getInternalBlockTypeId()];
        if (bitSet == null) {
            return false;
        }
        if (bitSet.length == 0) {
            return true;
        }
        return FastBitSet.get(bitSet, block.getInternalPropertiesId());
    }

    @Override
    public boolean test(Vector vector) {
        BlockState block = this.getExtent().getBlock(vector);
        long[] bitSet = this.bitSets[block.getInternalBlockTypeId()];
        if (bitSet == null) {
            return false;
        }
        if (bitSet.length == 0) {
            return true;
        }
        return FastBitSet.get(bitSet, block.getInternalPropertiesId());
    }

    @Override
    @Nullable
    public Mask2D toMask2D() {
        return null;
    }
}

