/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.config.BBC;
import com.boydti.fawe.config.Commands;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.object.FawePlayer;
import com.boydti.fawe.object.RunnableVal3;
import com.boydti.fawe.object.clipboard.MultiClipboardHolder;
import com.boydti.fawe.object.clipboard.URIClipboardHolder;
import com.boydti.fawe.object.clipboard.remap.ClipboardRemapper;
import com.boydti.fawe.object.schematic.StructureFormat;
import com.boydti.fawe.object.schematic.visualizer.SchemVis;
import com.boydti.fawe.util.MainUtil;
import com.boydti.fawe.util.ReflectionUtils;
import com.boydti.fawe.util.chat.Message;
import com.sk89q.minecraft.util.commands.Command;
import com.sk89q.minecraft.util.commands.CommandContext;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.minecraft.util.commands.CommandPermissions;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.command.ClipboardCommands;
import com.sk89q.worldedit.command.FlattenedClipboardTransform;
import com.sk89q.worldedit.command.MethodCommands;
import com.sk89q.worldedit.command.UtilityCommands;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.event.extent.PlayerSaveClipboardEvent;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extent.clipboard.BlockArrayClipboard;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormats;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardWriter;
import com.sk89q.worldedit.function.operation.Operations;
import com.sk89q.worldedit.math.transform.Transform;
import com.sk89q.worldedit.session.ClipboardHolder;
import com.sk89q.worldedit.util.command.binding.Switch;
import com.sk89q.worldedit.util.command.parametric.Optional;
import com.sk89q.worldedit.util.io.file.FilenameException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.LongAdder;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

@Command(aliases={"schematic", "schem", "/schematic", "/schem", "clipboard", "/clipboard"}, desc="Commands that work with schematic files")
public class SchematicCommands
extends MethodCommands {
    private static final Logger log = Logger.getLogger(SchematicCommands.class.getCanonicalName());

    public SchematicCommands(WorldEdit worldEdit) {
        super(worldEdit);
    }

    @Command(aliases={"loadall"}, usage="[<format>] <filename|url>", help="Load multiple clipboards\nThe -r flag will apply random rotation", desc="Load multiple clipboards (paste will randomly choose one)")
    @Deprecated
    @CommandPermissions(value={"worldedit.clipboard.load", "worldedit.schematic.load", "worldedit.schematic.upload"})
    public void loadall(Player player, LocalSession session, @Optional(value={"schematic"}) String formatName, String filename, @Switch(value=114) boolean randomRotate) throws FilenameException {
        ClipboardFormat format = ClipboardFormat.findByAlias(formatName);
        if (format == null) {
            BBC.CLIPBOARD_INVALID_FORMAT.send(player, formatName);
            return;
        }
        try {
            MultiClipboardHolder all = format.loadAllFromInput(player, filename, true);
            if (all != null) {
                session.addClipboard(all);
                BBC.SCHEMATIC_LOADED.send(player, filename);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Command(aliases={"clear"}, usage="", desc="Clear your clipboard", min=0, max=0)
    @CommandPermissions(value={"worldedit.clipboard.clear", "worldedit.schematic.clear"})
    public void clear(Player player, LocalSession session) throws WorldEditException {
        session.setClipboard(null);
        BBC.CLIPBOARD_CLEARED.send(player, new Object[0]);
    }

    @Command(aliases={"unload"}, usage="[file]", desc="Remove a clipboard from your multi-clipboard", min=1, max=1)
    @CommandPermissions(value={"worldedit.clipboard.clear", "worldedit.schematic.clear"})
    public void unload(Player player, LocalSession session, String fileName) throws WorldEditException {
        URIClipboardHolder identifiable;
        URI uri;
        if (fileName.startsWith("file:/") || fileName.startsWith("http://") || fileName.startsWith("https://")) {
            uri = URI.create(fileName);
        } else {
            LocalConfiguration config = this.worldEdit.getConfiguration();
            File working = this.worldEdit.getWorkingDirectoryFile(config.saveDir);
            File root = Settings.IMP.PATHS.PER_PLAYER_SCHEMATICS ? new File(working, player.getUniqueId().toString()) : working;
            uri = new File(root, fileName).toURI();
        }
        boolean removed = false;
        ClipboardHolder clipboard = session.getClipboard();
        if (clipboard instanceof URIClipboardHolder && (identifiable = (URIClipboardHolder)clipboard).contains(uri)) {
            if (identifiable instanceof MultiClipboardHolder) {
                MultiClipboardHolder multi = (MultiClipboardHolder)identifiable;
                multi.remove(uri);
                if (multi.getHolders().isEmpty()) {
                    session.setClipboard(null);
                }
            } else {
                session.setClipboard(null);
            }
            BBC.CLIPBOARD_CLEARED.send(player, new Object[0]);
            return;
        }
        BBC.CLIPBOARD_URI_NOT_FOUND.send(player, fileName);
    }

    @Command(aliases={"remap"}, help="Remap a clipboard between MCPE/PC values", desc="Remap a clipboard between MCPE/PC values")
    @Deprecated
    @CommandPermissions(value={"worldedit.schematic.remap"})
    public void remap(Player player, LocalSession session) throws WorldEditException {
        ClipboardRemapper remapper = Fawe.imp().getPlatform().equalsIgnoreCase("nukkit") ? new ClipboardRemapper(ClipboardRemapper.RemapPlatform.PC, ClipboardRemapper.RemapPlatform.PE) : new ClipboardRemapper(ClipboardRemapper.RemapPlatform.PE, ClipboardRemapper.RemapPlatform.PC);
        for (Clipboard clip : session.getClipboard().getClipboards()) {
            remapper.apply(clip);
        }
        player.print(BBC.getPrefix() + "Remapped schematic");
    }

    private File resolve(File dir, String filename, @Nullable ClipboardFormat format) {
        if (format != null) {
            if (!filename.matches(".*\\.[\\w].*")) {
                filename = filename + "." + format.getExtension();
            }
            return MainUtil.resolveRelative(new File(dir, filename));
        }
        for (ClipboardFormat f : ClipboardFormat.values) {
            File file = MainUtil.resolveRelative(new File(dir, filename + "." + f.getExtension()));
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Command(aliases={"load"}, usage="[<format>] <filename>", desc="Load a schematic into your clipboard")
    @Deprecated
    @CommandPermissions(value={"worldedit.clipboard.load", "worldedit.schematic.load", "worldedit.schematic.upload", "worldedit.schematic.load.other"})
    public void load(Player player, LocalSession session, @Optional String formatName, String filename) throws FilenameException {
        LocalConfiguration config = this.worldEdit.getConfiguration();
        ClipboardFormat format = formatName == null ? null : ClipboardFormat.findByAlias(formatName);
        InputStream in = null;
        try {
            URI uri;
            if (filename.startsWith("url:")) {
                if (!player.hasPermission("worldedit.schematic.upload")) {
                    BBC.NO_PERM.send(player, "worldedit.schematic.upload");
                    return;
                }
                UUID uuid = UUID.fromString(filename.substring(4));
                URL base = new URL(Settings.IMP.WEB.URL);
                URL url = new URL(base, "uploads/" + uuid + ".schematic");
                ReadableByteChannel rbc = Channels.newChannel(url.openStream());
                in = Channels.newInputStream(rbc);
                uri = url.toURI();
                if (format == null) {
                    format = ClipboardFormat.SCHEMATIC;
                }
            } else {
                File f;
                File dir;
                if (!player.hasPermission("worldedit.schematic.load") && !player.hasPermission("worldedit.clipboard.load")) {
                    BBC.NO_PERM.send(player, "worldedit.clipboard.load");
                    return;
                }
                File working = this.worldEdit.getWorkingDirectoryFile(config.saveDir);
                File file = dir = Settings.IMP.PATHS.PER_PLAYER_SCHEMATICS ? new File(working, player.getUniqueId().toString()) : working;
                if (filename.startsWith("#")) {
                    String[] extensions = format != null ? format.getFileExtensions().toArray(new String[0]) : ClipboardFormats.getFileExtensionArray();
                    f = player.openFileOpenDialog(extensions);
                    if (f == null || !f.exists()) {
                        player.printError("Schematic " + filename + " does not exist! (" + f + ")");
                        return;
                    }
                } else {
                    if (Settings.IMP.PATHS.PER_PLAYER_SCHEMATICS && Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}").matcher(filename).find() && !player.hasPermission("worldedit.schematic.load.other")) {
                        BBC.NO_PERM.send(player, "worldedit.schematic.load.other");
                        return;
                    }
                    if (format == null && filename.matches(".*\\.[\\w].*")) {
                        String extension = filename.substring(filename.lastIndexOf(46) + 1, filename.length());
                        format = ClipboardFormat.findByExtension(extension);
                    }
                    f = this.resolve(dir, filename, format);
                }
                if (!(f != null && f.exists() || filename.contains("../"))) {
                    dir = this.worldEdit.getWorkingDirectoryFile(config.saveDir);
                    f = this.resolve(dir, filename, format);
                }
                if (f == null || !f.exists() || !MainUtil.isInSubDirectory(working, f)) {
                    player.printError("Schematic " + filename + " does not exist! (" + (f == null ? false : f.exists()) + "|" + f + "|" + (f == null ? false : !MainUtil.isInSubDirectory(working, f)) + ")");
                    return;
                }
                if (format == null && (format = ClipboardFormat.findByFile(f)) == null) {
                    BBC.CLIPBOARD_INVALID_FORMAT.send(player, f.getName());
                    return;
                }
                in = new FileInputStream(f);
                uri = f.toURI();
            }
            format.hold(player, uri, in);
            BBC.SCHEMATIC_LOADED.send(player, filename);
            return;
        }
        catch (IllegalArgumentException e) {
            player.printError("Unknown filename: " + filename);
            return;
        }
        catch (IOException | URISyntaxException e) {
            player.printError("File could not be read or it does not exist: " + e.getMessage());
            log.log(Level.WARNING, "Failed to load a saved clipboard", e);
            return;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Command(aliases={"save"}, usage="[format] <filename>", desc="Save a schematic into your clipboard")
    @Deprecated
    @CommandPermissions(value={"worldedit.clipboard.save", "worldedit.schematic.save", "worldedit.schematic.save.other"})
    public void save(Player player, LocalSession session, @Optional(value={"schem"}) String formatName, String filename, @Switch(value=103) boolean global) throws CommandException, WorldEditException {
        block44: {
            File parent;
            File f;
            File dir;
            LocalConfiguration config = this.worldEdit.getConfiguration();
            ClipboardFormat format = ClipboardFormat.findByAlias(formatName);
            if (format == null) {
                player.printError("Unknown schematic format: " + formatName);
                return;
            }
            File working = this.worldEdit.getWorkingDirectoryFile(config.saveDir);
            File file = dir = !global && Settings.IMP.PATHS.PER_PLAYER_SCHEMATICS ? new File(working, player.getUniqueId().toString()) : working;
            if (filename.contains("../")) {
                if (!player.hasPermission("worldedit.schematic.save.other")) {
                    BBC.NO_PERM.send(player, "worldedit.schematic.save.other");
                    return;
                }
                if (filename.startsWith("../")) {
                    dir = working;
                    filename = filename.substring(3);
                }
            }
            if ((f = this.worldEdit.getSafeSaveFile(player, dir, filename, format.getExtension(), format.getExtension())).getName().replaceAll("." + format.getExtension(), "").isEmpty()) {
                File directory = f.getParentFile();
                if (directory.exists()) {
                    int max = MainUtil.getMaxFileId(directory);
                    f = new File(directory, max + "." + format.getExtension());
                } else {
                    f = new File(directory, "1." + format.getExtension());
                }
            }
            if ((parent = f.getParentFile()) != null && !parent.exists() && !parent.mkdirs()) {
                try {
                    Files.createDirectories(parent.toPath(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    log.info("Could not create folder for schematics!");
                    return;
                }
            }
            try {
                if (!f.exists()) {
                    f.createNewFile();
                }
                try (FileOutputStream fos = new FileOutputStream(f);){
                    Clipboard target;
                    ClipboardHolder holder = session.getClipboard();
                    Clipboard clipboard = holder.getClipboard();
                    Transform transform = holder.getTransform();
                    if (!transform.isIdentity()) {
                        FlattenedClipboardTransform result = FlattenedClipboardTransform.transform(clipboard, transform);
                        target = new BlockArrayClipboard(result.getTransformedRegion(), UUID.randomUUID());
                        target.setOrigin(clipboard.getOrigin());
                        Operations.completeLegacy(result.copyTo(target));
                    } else {
                        target = clipboard;
                    }
                    URI uri = null;
                    if (holder instanceof URIClipboardHolder) {
                        uri = ((URIClipboardHolder)holder).getURI(clipboard);
                    }
                    if (new PlayerSaveClipboardEvent(player, clipboard, uri, f.toURI()).call()) {
                        try (ClipboardWriter writer = format.getWriter(fos);){
                            if (writer instanceof StructureFormat) {
                                ((StructureFormat)writer).write(target, player.getName());
                            } else {
                                writer.write(target);
                            }
                            log.info(player.getName() + " saved " + f.getCanonicalPath());
                            BBC.SCHEMATIC_SAVED.send(player, filename);
                            break block44;
                        }
                    }
                    BBC.WORLDEDIT_CANCEL_REASON_MANUAL.send(player, new Object[0]);
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                player.printError("Unknown filename: " + filename);
            }
            catch (IOException e) {
                e.printStackTrace();
                player.printError("Schematic could not written: " + e.getMessage());
                log.log(Level.WARNING, "Failed to write a saved clipboard", e);
            }
        }
    }

    @Command(aliases={"move", "m"}, usage="<directory>", desc="Move your loaded schematic", help="Move your currently loaded schematics", min=1, max=1)
    @CommandPermissions(value={"worldedit.schematic.move", "worldedit.schematic.move.other"})
    public void move(Player player, LocalSession session, String directory) throws WorldEditException {
        File dir;
        File destDir;
        LocalConfiguration config = this.worldEdit.getConfiguration();
        File working = this.worldEdit.getWorkingDirectoryFile(config.saveDir);
        if (!MainUtil.isInSubDirectory(working, destDir = new File(dir = Settings.IMP.PATHS.PER_PLAYER_SCHEMATICS ? new File(working, player.getUniqueId().toString()) : working, directory))) {
            player.printError("Directory " + destDir + " does not exist!");
            return;
        }
        if (Settings.IMP.PATHS.PER_PLAYER_SCHEMATICS && !MainUtil.isInSubDirectory(dir, destDir) && !player.hasPermission("worldedit.schematic.move.other")) {
            BBC.NO_PERM.send(player, "worldedit.schematic.move.other");
            return;
        }
        ClipboardHolder clipboard = session.getClipboard();
        List<File> sources = this.getFiles(clipboard);
        if (sources.isEmpty()) {
            BBC.SCHEMATIC_NONE.send(player, new Object[0]);
            return;
        }
        if (!destDir.exists() && !destDir.mkdirs()) {
            player.printError("Creation of " + destDir + " failed! (check file permissions)");
            return;
        }
        for (File source : sources) {
            File destFile = new File(destDir, source.getName());
            if (destFile.exists()) {
                BBC.SCHEMATIC_MOVE_EXISTS.send(player, destFile);
                continue;
            }
            if (!(!Settings.IMP.PATHS.PER_PLAYER_SCHEMATICS || MainUtil.isInSubDirectory(dir, destFile) && MainUtil.isInSubDirectory(dir, source) || player.hasPermission("worldedit.schematic.delete.other"))) {
                BBC.SCHEMATIC_MOVE_FAILED.send(player, destFile, BBC.NO_PERM.f("worldedit.schematic.move.other"));
                continue;
            }
            try {
                File cached = new File(source.getParentFile(), "." + source.getName() + ".cached");
                Files.move(source.toPath(), destFile.toPath(), new CopyOption[0]);
                if (cached.exists()) {
                    Files.move(cached.toPath(), destFile.toPath(), new CopyOption[0]);
                }
                BBC.SCHEMATIC_MOVE_SUCCESS.send(player, source, destFile);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Command(aliases={"delete", "d"}, usage="<filename|*>", desc="Delete a saved schematic", help="Delete a schematic from the schematic list", min=1, max=1)
    @CommandPermissions(value={"worldedit.schematic.delete", "worldedit.schematic.delete.other"})
    public void delete(Player player, LocalSession session, CommandContext args) throws WorldEditException {
        LocalConfiguration config = this.worldEdit.getConfiguration();
        File working = this.worldEdit.getWorkingDirectoryFile(config.saveDir);
        File dir = Settings.IMP.PATHS.PER_PLAYER_SCHEMATICS ? new File(working, player.getUniqueId().toString()) : working;
        ArrayList<File> files = new ArrayList<File>();
        String filename = args.getString(0);
        if (filename.equalsIgnoreCase("*")) {
            files.addAll(this.getFiles(session.getClipboard()));
        } else {
            File f = MainUtil.resolveRelative(new File(dir, filename));
            files.add(f);
        }
        if (files.isEmpty()) {
            BBC.SCHEMATIC_NONE.send(player, new Object[0]);
            return;
        }
        for (File f : files) {
            if (!MainUtil.isInSubDirectory(working, f) || !f.exists()) {
                player.printError("Schematic " + filename + " does not exist! (" + f.exists() + "|" + f + "|" + !MainUtil.isInSubDirectory(working, f) + ")");
                continue;
            }
            if (Settings.IMP.PATHS.PER_PLAYER_SCHEMATICS && !MainUtil.isInSubDirectory(dir, f) && !player.hasPermission("worldedit.schematic.delete.other")) {
                BBC.NO_PERM.send(player, "worldedit.schematic.delete.other");
                continue;
            }
            if (!this.delete(f)) {
                player.printError("Deletion of " + filename + " failed! Maybe it is read-only.");
                continue;
            }
            BBC.FILE_DELETED.send(player, filename);
        }
    }

    private List<File> getFiles(ClipboardHolder clipboard) {
        ArrayList<File> files = new ArrayList<File>();
        Collection<Object> uris = Collections.emptyList();
        if (clipboard instanceof URIClipboardHolder) {
            uris = ((URIClipboardHolder)clipboard).getURIs();
        }
        for (URI uri : uris) {
            File file = new File(uri);
            if (!file.exists()) continue;
            files.add(file);
        }
        return files;
    }

    private boolean delete(File file) {
        if (file.delete()) {
            new File(file.getParentFile(), "." + file.getName() + ".cached").delete();
            return true;
        }
        return false;
    }

    @Command(aliases={"formats", "listformats", "f"}, desc="List available formats", max=0)
    @CommandPermissions(value={"worldedit.schematic.formats"})
    public void formats(Actor actor) throws WorldEditException {
        BBC.SCHEMATIC_FORMAT.send(actor, new Object[0]);
        Message m = new Message(BBC.SCHEMATIC_FORMAT, new Object[0]).newline();
        String baseCmd = Commands.getAlias(SchematicCommands.class, "schematic") + " " + Commands.getAlias(SchematicCommands.class, "save");
        boolean first = true;
        for (ClipboardFormat format : ClipboardFormat.values) {
            StringBuilder builder = new StringBuilder();
            builder.append(format.name()).append(": ");
            for (String lookupName : format.getAliases()) {
                if (!first) {
                    builder.append(", ");
                }
                builder.append(lookupName);
                first = false;
            }
            String cmd = baseCmd + " " + format.name() + " <filename>";
            m.text(builder).suggestTip(cmd).newline();
            first = true;
        }
        m.send(actor);
    }

    @Command(aliases={"show"}, desc="Show a schematic", usage="[global|mine|<filter>]", min=0, max=-1, flags="dnp", help="List all schematics in the schematics directory\n -f <format> restricts by format\n")
    @CommandPermissions(value={"worldedit.schematic.show"})
    public void show(Player player, CommandContext args, @Switch(value=102) String formatName) {
        FawePlayer fp = FawePlayer.wrap(player);
        if (args.argsLength() == 0) {
            if (fp.getSession().getVirtualWorld() != null) {
                fp.setVirtualWorld(null);
            } else {
                BBC.COMMAND_SYNTAX.send(player, "/" + Commands.getAlias(SchematicCommands.class, "schematic") + " " + this.getCommand().aliases()[0] + " " + this.getCommand().usage());
            }
            return;
        }
        LocalConfiguration config = this.worldEdit.getConfiguration();
        File dir = this.worldEdit.getWorkingDirectoryFile(config.saveDir);
        try {
            SchemVis visExtent = new SchemVis(fp);
            LongAdder count = new LongAdder();
            UtilityCommands.getFiles(dir, player, args, 0, 65535, formatName, Settings.IMP.PATHS.PER_PLAYER_SCHEMATICS, file -> {
                if (file.isFile()) {
                    try {
                        visExtent.add((File)file);
                        count.add(1L);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            long total = count.longValue();
            if (total == 0L) {
                if (args.getJoinedStrings(0).toLowerCase().startsWith("all")) {
                    BBC.SCHEMATIC_NONE.send(player, new Object[0]);
                } else {
                    String joined = args.getJoinedStrings(0);
                    String cmd = "/" + Commands.getAlias(SchematicCommands.class, "schematic") + " " + this.getCommand().aliases()[0] + " all " + joined;
                    BBC.HELP_SUGGEST.send(player, joined, cmd);
                }
                return;
            }
            visExtent.bind();
            visExtent.update();
            String cmdPrefix = "/" + (config.noDoubleSlash ? "" : "/");
            String cmdShow = Commands.getAlias(ClipboardCommands.class, "schematic") + " " + Commands.getAlias(ClipboardCommands.class, "show");
            BBC.SCHEMATIC_SHOW.send(fp, count.longValue(), args.getJoinedStrings(0), cmdShow);
            if (fp.getSession().getExistingClipboard() != null) {
                String cmd = cmdPrefix + Commands.getAlias(ClipboardCommands.class, "clearclipboard");
                BBC.SCHEMATIC_PROMPT_CLEAR.send(fp, cmd);
            }
        }
        catch (Throwable e) {
            fp.setVirtualWorld(null);
            throw e;
        }
    }

    @Command(aliases={"list", "ls", "all"}, desc="List saved schematics", usage="[global|mine|<filter>] [page=1]", min=0, max=-1, flags="dnp", help="List all schematics in the schematics directory\n -p <page> prints the requested page\n -f <format> restricts by format\n")
    @CommandPermissions(value={"worldedit.schematic.list"})
    public void list(FawePlayer fp, Actor actor, final CommandContext args, @Switch(value=112) @Optional(value={"1"}) int page, @Switch(value=102) String formatName) throws WorldEditException {
        if (args.argsLength() == 0) {
            BBC.COMMAND_SYNTAX.send(fp, this.getCommand().usage());
            return;
        }
        LocalConfiguration config = this.worldEdit.getConfiguration();
        String prefix = config.noDoubleSlash ? "" : "/";
        File dir = this.worldEdit.getWorkingDirectoryFile(config.saveDir);
        String schemCmd = prefix + Commands.getAlias(SchematicCommands.class, "schematic");
        final String loadSingle = schemCmd + " " + Commands.getAlias(SchematicCommands.class, "load");
        final String loadMulti = schemCmd + " " + Commands.getAlias(SchematicCommands.class, "loadall");
        final String unload = schemCmd + " " + Commands.getAlias(SchematicCommands.class, "unload");
        final String delete = schemCmd + " " + Commands.getAlias(SchematicCommands.class, "delete");
        final String list = schemCmd + " " + Commands.getAlias(SchematicCommands.class, "list");
        final String showCmd = schemCmd + " " + Commands.getAlias(SchematicCommands.class, "show");
        final URIClipboardHolder multi = ReflectionUtils.as(URIClipboardHolder.class, fp.getSession().getExistingClipboard());
        final boolean hasShow = actor.hasPermission("worldedit.schematic.show");
        UtilityCommands.list(dir, actor, args, page, -1, formatName, Settings.IMP.PATHS.PER_PLAYER_SCHEMATICS, new RunnableVal3<Message, URI, String>(){

            @Override
            public void run(Message msg, URI uri, String relFilePath) {
                String color;
                boolean isDir = false;
                boolean loaded = multi != null && multi.contains(uri);
                String name = relFilePath;
                String uriStr = uri.toString();
                if (uriStr.startsWith("file:/")) {
                    File file = new File(uri.getPath());
                    name = file.getName();
                    if (file.isDirectory()) {
                        isDir = true;
                        color = "&6";
                    } else {
                        color = "&a";
                        if (name.indexOf(46) != -1) {
                            name = name.substring(0, name.lastIndexOf(46));
                        }
                    }
                } else {
                    color = uriStr.startsWith("http://") || uriStr.startsWith("https://") ? "&9" : "&7";
                }
                msg.text("&8 - ");
                if (msg.supportsInteraction()) {
                    if (loaded) {
                        msg.text("&7[&c-&7]").command(unload + " " + relFilePath).tooltip("Unload");
                    } else {
                        msg.text("&7[&a+&7]").command(loadMulti + " " + relFilePath).tooltip("Add to clipboard");
                    }
                    if (!isDir) {
                        msg.text("&7[&cX&7]").suggest("/" + delete + " " + relFilePath).tooltip("Delete");
                    } else if (hasShow) {
                        msg.text("&7[&3O&7]").command(showCmd + " " + args.getJoinedStrings(0) + " " + relFilePath).tooltip("Show");
                    }
                    msg.text(color + name);
                    if (isDir) {
                        msg.command(list + " " + relFilePath).tooltip("List");
                    } else {
                        msg.command(loadSingle + " " + relFilePath).tooltip("Load");
                    }
                } else {
                    msg.text(color).text(name);
                }
            }
        });
    }
}

