/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.config.Settings;
import com.boydti.fawe.object.FaweInputStream;
import com.boydti.fawe.object.FaweLimit;
import com.boydti.fawe.object.FaweOutputStream;
import com.boydti.fawe.object.FawePlayer;
import com.boydti.fawe.object.brush.visualization.VirtualWorld;
import com.boydti.fawe.object.changeset.AnvilHistory;
import com.boydti.fawe.object.changeset.DiskStorageHistory;
import com.boydti.fawe.object.changeset.FaweChangeSet;
import com.boydti.fawe.object.clipboard.MultiClipboardHolder;
import com.boydti.fawe.object.collection.SparseBitSet;
import com.boydti.fawe.object.extent.ResettableExtent;
import com.boydti.fawe.util.BrushCache;
import com.boydti.fawe.util.EditSessionBuilder;
import com.boydti.fawe.util.MainUtil;
import com.boydti.fawe.util.StringMan;
import com.boydti.fawe.util.TextureHolder;
import com.boydti.fawe.util.TextureUtil;
import com.boydti.fawe.util.cui.CUI;
import com.boydti.fawe.wrappers.WorldWrapper;
import com.google.common.base.Preconditions;
import com.sk89q.jchronic.Chronic;
import com.sk89q.jchronic.Options;
import com.sk89q.jchronic.utils.Span;
import com.sk89q.jchronic.utils.Time;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.EmptyClipboardException;
import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.blocks.BaseItem;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.command.tool.BlockTool;
import com.sk89q.worldedit.command.tool.BrushTool;
import com.sk89q.worldedit.command.tool.InvalidToolBindException;
import com.sk89q.worldedit.command.tool.SinglePickaxe;
import com.sk89q.worldedit.command.tool.Tool;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extent.inventory.BlockBag;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.operation.ChangeSetExecutor;
import com.sk89q.worldedit.history.changeset.ChangeSet;
import com.sk89q.worldedit.internal.cui.CUIEvent;
import com.sk89q.worldedit.internal.cui.CUIRegion;
import com.sk89q.worldedit.internal.cui.SelectionShapeEvent;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.RegionSelector;
import com.sk89q.worldedit.regions.selector.CuboidRegionSelector;
import com.sk89q.worldedit.regions.selector.RegionSelectorType;
import com.sk89q.worldedit.session.ClipboardHolder;
import com.sk89q.worldedit.session.request.Request;
import com.sk89q.worldedit.util.HandSide;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.item.ItemType;
import com.sk89q.worldedit.world.item.ItemTypes;
import com.sk89q.worldedit.world.snapshot.Snapshot;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LocalSession
implements TextureHolder {
    @Deprecated
    public static transient int MAX_HISTORY_SIZE = 15;
    private transient LocalConfiguration config;
    private final transient AtomicBoolean dirty = new AtomicBoolean();
    private transient int failedCuiAttempts = 0;
    private transient RegionSelector selector = new CuboidRegionSelector();
    private transient boolean placeAtPos1 = false;
    private transient List<Object> history = Collections.synchronizedList(new LinkedList<Object>(){

        @Override
        public Object get(int index) {
            Object value = super.get(index);
            if (value instanceof Integer) {
                value = LocalSession.this.getChangeSet(value);
                this.set(index, value);
            }
            return value;
        }

        @Override
        public Object remove(int index) {
            return LocalSession.this.getChangeSet(super.remove(index));
        }
    });
    private volatile transient Integer historyNegativeIndex;
    private transient ClipboardHolder clipboard;
    private transient boolean toolControl = true;
    private transient boolean superPickaxe = false;
    private transient BlockTool pickaxeMode = new SinglePickaxe();
    private transient boolean hasTool = false;
    private transient Tool[] tools = new Tool[ItemTypes.size()];
    private transient int maxBlocksChanged = -1;
    private transient boolean useInventory;
    private transient Snapshot snapshot;
    private transient boolean hasCUISupport = false;
    private transient int cuiVersion = -1;
    private transient boolean fastMode = false;
    private transient Mask mask;
    private transient Mask sourceMask;
    private transient TextureUtil texture;
    private transient ResettableExtent transform = null;
    private transient TimeZone timezone = TimeZone.getDefault();
    private transient World currentWorld;
    private transient UUID uuid;
    private volatile transient long historySize = 0L;
    private transient VirtualWorld virtual;
    private String lastScript;
    private RegionSelectorType defaultSelector;

    public LocalSession() {
    }

    public LocalSession(@Nullable LocalConfiguration config) {
        this.config = config;
    }

    public void setConfiguration(LocalConfiguration config) {
        Preconditions.checkNotNull((Object)config);
        this.config = config;
    }

    public void postLoad() {
        if (this.defaultSelector != null) {
            this.selector = this.defaultSelector.createSelector();
        }
    }

    public boolean loadSessionHistoryFromDisk(UUID uuid, World world) {
        if (world == null || uuid == null) {
            return false;
        }
        if (Settings.IMP.HISTORY.USE_DISK) {
            MAX_HISTORY_SIZE = Integer.MAX_VALUE;
        }
        if (!(world = WorldWrapper.unwrap(world)).equals(this.currentWorld)) {
            this.uuid = uuid;
            this.saveHistoryNegativeIndex(uuid, this.currentWorld);
            this.history.clear();
            this.currentWorld = world;
            if (this.loadHistoryChangeSets(uuid, this.currentWorld)) {
                this.loadHistoryNegativeIndex(uuid, this.currentWorld);
                return true;
            }
            this.historyNegativeIndex = 0;
        }
        return false;
    }

    private boolean loadHistoryChangeSets(UUID uuid, World world) {
        final SparseBitSet set = new SparseBitSet();
        File folder = MainUtil.getFile(Fawe.imp().getDirectory(), Settings.IMP.PATHS.HISTORY + File.separator + Fawe.imp().getWorldName(world) + File.separator + uuid);
        if (folder.isDirectory()) {
            folder.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    String name = pathname.getName();
                    Integer val = null;
                    if (pathname.isDirectory()) {
                        val = StringMan.toInteger(name, 0, name.length());
                    } else {
                        int i = name.lastIndexOf(46);
                        if (i != -1) {
                            val = StringMan.toInteger(name, 0, i);
                        }
                    }
                    if (val != null) {
                        set.set(val);
                    }
                    return false;
                }
            });
        }
        if (!set.isEmpty()) {
            this.historySize = MainUtil.getTotalSize(folder.toPath());
            int index = set.nextSetBit(0);
            while (index != -1) {
                this.history.add(index);
                index = set.nextSetBit(index + 1);
            }
        } else {
            this.historySize = 0L;
        }
        return !set.isEmpty();
    }

    private void loadHistoryNegativeIndex(UUID uuid, World world) {
        if (!Settings.IMP.HISTORY.USE_DISK) {
            return;
        }
        File file = MainUtil.getFile(Fawe.imp().getDirectory(), Settings.IMP.PATHS.HISTORY + File.separator + Fawe.imp().getWorldName(world) + File.separator + uuid + File.separator + "index");
        if (file.exists()) {
            try {
                FaweInputStream is = new FaweInputStream(new FileInputStream(file));
                this.historyNegativeIndex = Math.min(Math.max(0, is.readInt()), this.history.size());
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.historyNegativeIndex = 0;
        }
    }

    private void saveHistoryNegativeIndex(UUID uuid, World world) {
        if (world == null || !Settings.IMP.HISTORY.USE_DISK) {
            return;
        }
        File file = MainUtil.getFile(Fawe.imp().getDirectory(), Settings.IMP.PATHS.HISTORY + File.separator + Fawe.imp().getWorldName(world) + File.separator + uuid + File.separator + "index");
        if (this.getHistoryNegativeIndex() != 0) {
            try {
                if (!file.exists()) {
                    file.getParentFile().mkdirs();
                    file.createNewFile();
                }
                FaweOutputStream os = new FaweOutputStream(new FileOutputStream(file));
                os.writeInt(this.getHistoryNegativeIndex());
                os.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (file.exists()) {
            file.delete();
        }
    }

    public boolean isDirty() {
        return this.dirty.get();
    }

    private void setDirty() {
        this.dirty.set(true);
    }

    public int getHistoryIndex() {
        return this.history.size() - 1 - (this.historyNegativeIndex == null ? 0 : this.historyNegativeIndex);
    }

    public int getHistoryNegativeIndex() {
        return this.historyNegativeIndex == null ? (this.historyNegativeIndex = Integer.valueOf(0)) : this.historyNegativeIndex;
    }

    public void setHistoryIndex(int value) {
        this.historyNegativeIndex = this.history.size() - value - 1;
    }

    public boolean save() {
        this.saveHistoryNegativeIndex(this.uuid, this.currentWorld);
        if (this.defaultSelector == RegionSelectorType.CUBOID) {
            this.defaultSelector = null;
        }
        return this.lastScript != null || this.defaultSelector != null;
    }

    public boolean compareAndResetDirty() {
        return this.dirty.compareAndSet(true, false);
    }

    public TimeZone getTimeZone() {
        return this.timezone;
    }

    public void setTimezone(TimeZone timezone) {
        Preconditions.checkNotNull((Object)timezone);
        this.timezone = timezone;
    }

    public void clearHistory() {
        this.history.clear();
        this.historyNegativeIndex = 0;
        this.historySize = 0L;
        this.currentWorld = null;
    }

    public void remember(EditSession editSession) {
        FawePlayer fp = editSession.getPlayer();
        int limit = fp == null ? Integer.MAX_VALUE : fp.getLimit().MAX_HISTORY;
        this.remember(editSession, true, limit);
    }

    private FaweChangeSet getChangeSet(Object o) {
        if (o instanceof FaweChangeSet) {
            FaweChangeSet cs = (FaweChangeSet)o;
            cs.close();
            return cs;
        }
        if (o instanceof Integer) {
            File folder = MainUtil.getFile(Fawe.imp().getDirectory(), Settings.IMP.PATHS.HISTORY + File.separator + Fawe.imp().getWorldName(this.currentWorld) + File.separator + this.uuid);
            File specific = new File(folder, o.toString());
            if (specific.isDirectory()) {
                return new AnvilHistory(Fawe.imp().getWorldName(this.currentWorld), specific);
            }
            return new DiskStorageHistory(this.currentWorld, this.uuid, (int)((Integer)o));
        }
        return null;
    }

    public synchronized void remember(Player player, World world, ChangeSet changeSet, FaweLimit limit) {
        if (Settings.IMP.HISTORY.USE_DISK) {
            MAX_HISTORY_SIZE = Integer.MAX_VALUE;
        }
        if (changeSet.size() == 0) {
            return;
        }
        this.loadSessionHistoryFromDisk(player.getUniqueId(), world);
        if (changeSet instanceof FaweChangeSet) {
            int size = this.getHistoryNegativeIndex();
            ListIterator<Object> iter = this.history.listIterator();
            int i = 0;
            int cutoffIndex = this.history.size() - this.getHistoryNegativeIndex();
            while (iter.hasNext()) {
                Object item = iter.next();
                if (++i <= cutoffIndex) continue;
                FaweChangeSet oldChangeSet = item instanceof FaweChangeSet ? (FaweChangeSet)item : this.getChangeSet(item);
                this.historySize -= MainUtil.getSize(oldChangeSet);
                iter.remove();
            }
        }
        this.historySize += MainUtil.getSize(changeSet);
        this.history.add(changeSet);
        if (this.getHistoryNegativeIndex() != 0) {
            this.setDirty();
            this.historyNegativeIndex = 0;
        }
        if (limit != null) {
            int limitMb = limit.MAX_HISTORY;
            while ((!Settings.IMP.HISTORY.USE_DISK && this.history.size() > MAX_HISTORY_SIZE || this.historySize >> 20 > (long)limitMb) && this.history.size() > 1) {
                FaweChangeSet item = (FaweChangeSet)this.history.remove(0);
                item.delete();
                long size = MainUtil.getSize(item);
                this.historySize -= size;
            }
        }
    }

    public synchronized void remember(EditSession editSession, boolean append, int limitMb) {
        if (Settings.IMP.HISTORY.USE_DISK) {
            MAX_HISTORY_SIZE = Integer.MAX_VALUE;
        }
        editSession.flushQueue();
        if (editSession == null || editSession.getChangeSet() == null || limitMb == 0 || this.historySize >> 20 > (long)limitMb && !append) {
            return;
        }
        if (editSession.size() == 0) {
            return;
        }
        FaweChangeSet changeSet = (FaweChangeSet)editSession.getChangeSet();
        if (changeSet.isEmpty()) {
            return;
        }
        FawePlayer fp = editSession.getPlayer();
        if (fp != null) {
            this.loadSessionHistoryFromDisk(fp.getUUID(), editSession.getWorld());
        }
        if (append) {
            int size = this.getHistoryNegativeIndex();
            ListIterator<Object> iter = this.history.listIterator();
            int i = 0;
            int cutoffIndex = this.history.size() - this.getHistoryNegativeIndex();
            while (iter.hasNext()) {
                Object item = iter.next();
                if (++i <= cutoffIndex) continue;
                FaweChangeSet oldChangeSet = item instanceof FaweChangeSet ? (FaweChangeSet)item : this.getChangeSet(item);
                this.historySize -= MainUtil.getSize(oldChangeSet);
                iter.remove();
            }
        }
        this.historySize += MainUtil.getSize(changeSet);
        if (append) {
            this.history.add(changeSet);
            if (this.getHistoryNegativeIndex() != 0) {
                this.setDirty();
                this.historyNegativeIndex = 0;
            }
        } else {
            this.history.add(0, changeSet);
        }
        while ((!Settings.IMP.HISTORY.USE_DISK && this.history.size() > MAX_HISTORY_SIZE || this.historySize >> 20 > (long)limitMb) && this.history.size() > 1) {
            FaweChangeSet item = (FaweChangeSet)this.history.remove(0);
            item.delete();
            long size = MainUtil.getSize(item);
            this.historySize -= size;
        }
    }

    public EditSession undo(@Nullable BlockBag newBlockBag, Player player) {
        Preconditions.checkNotNull((Object)player);
        FawePlayer fp = FawePlayer.wrap(player);
        this.loadSessionHistoryFromDisk(player.getUniqueId(), fp.getWorldForEditing());
        if (this.getHistoryNegativeIndex() < this.history.size()) {
            FaweChangeSet changeSet = this.getChangeSet(this.history.get(this.getHistoryIndex()));
            EditSession newEditSession = new EditSessionBuilder(changeSet.getWorld()).allowedRegionsEverywhere().checkMemory(false).changeSetNull().fastmode(false).limitUnprocessed(fp).player(fp).blockBag(this.getBlockBag(player)).build();
            newEditSession.setBlocks(changeSet, ChangeSetExecutor.Type.UNDO);
            this.setDirty();
            Integer n = this.historyNegativeIndex;
            Integer n2 = this.historyNegativeIndex = Integer.valueOf(this.historyNegativeIndex + 1);
            return newEditSession;
        }
        int size = this.history.size();
        if (this.getHistoryNegativeIndex() != size) {
            this.historyNegativeIndex = this.history.size();
            this.setDirty();
        }
        return null;
    }

    public EditSession redo(@Nullable BlockBag newBlockBag, Player player) {
        Preconditions.checkNotNull((Object)player);
        FawePlayer fp = FawePlayer.wrap(player);
        this.loadSessionHistoryFromDisk(player.getUniqueId(), fp.getWorldForEditing());
        if (this.getHistoryNegativeIndex() > 0) {
            this.setDirty();
            Integer n = this.historyNegativeIndex;
            Integer n2 = this.historyNegativeIndex = Integer.valueOf(this.historyNegativeIndex - 1);
            FaweChangeSet changeSet = this.getChangeSet(this.history.get(this.getHistoryIndex()));
            EditSession newEditSession = new EditSessionBuilder(changeSet.getWorld()).allowedRegionsEverywhere().checkMemory(false).changeSetNull().fastmode(false).limitUnprocessed(fp).player(fp).blockBag(this.getBlockBag(player)).build();
            newEditSession.setBlocks(changeSet, ChangeSetExecutor.Type.REDO);
            return newEditSession;
        }
        return null;
    }

    public void unregisterTools(Player player) {
        for (Tool tool : this.tools) {
            if (!(tool instanceof BrushTool)) continue;
            ((BrushTool)tool).clear(player);
        }
    }

    public int getSize() {
        return this.history.size();
    }

    public RegionSelectorType getDefaultRegionSelector() {
        return this.defaultSelector;
    }

    public void setDefaultRegionSelector(RegionSelectorType defaultSelector) {
        Preconditions.checkNotNull((Object)((Object)defaultSelector));
        this.defaultSelector = defaultSelector;
        this.setDirty();
    }

    public RegionSelector getRegionSelector(World world) {
        Preconditions.checkNotNull((Object)world);
        try {
            if (this.selector.getWorld() == null || !this.selector.getWorld().equals(world)) {
                this.selector.setWorld(world);
                this.selector.clear();
            }
        }
        catch (Throwable ignore) {
            this.selector.clear();
        }
        return this.selector;
    }

    @Deprecated
    public RegionSelector getRegionSelector() {
        return this.selector;
    }

    public void setRegionSelector(World world, RegionSelector selector) {
        Preconditions.checkNotNull((Object)world);
        Preconditions.checkNotNull((Object)selector);
        selector.setWorld(world);
        this.selector = selector;
    }

    @Deprecated
    public boolean isRegionDefined() {
        return this.selector.isDefined();
    }

    public boolean isSelectionDefined(World world) {
        Preconditions.checkNotNull((Object)world);
        if (this.selector.getIncompleteRegion().getWorld() == null || !this.selector.getIncompleteRegion().getWorld().equals(world)) {
            return false;
        }
        return this.selector.isDefined();
    }

    @Deprecated
    public Region getRegion() throws IncompleteRegionException {
        return this.selector.getRegion();
    }

    public Region getSelection(World world) throws IncompleteRegionException {
        Preconditions.checkNotNull((Object)world);
        if (this.selector.getIncompleteRegion().getWorld() == null || !this.selector.getIncompleteRegion().getWorld().equals(world)) {
            throw new IncompleteRegionException();
        }
        return this.selector.getRegion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public VirtualWorld getVirtualWorld() {
        AtomicBoolean atomicBoolean = this.dirty;
        synchronized (atomicBoolean) {
            return this.virtual;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVirtualWorld(@Nullable VirtualWorld world) {
        VirtualWorld tmp;
        AtomicBoolean atomicBoolean = this.dirty;
        synchronized (atomicBoolean) {
            tmp = this.virtual;
            this.virtual = world;
        }
        if (tmp != null) {
            try {
                tmp.close(world == null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (world != null) {
            Fawe.imp().registerPacketListener();
            world.update();
        }
    }

    public World getSelectionWorld() {
        World world = this.selector.getIncompleteRegion().getWorld();
        if (world instanceof WorldWrapper) {
            return ((WorldWrapper)world).getParent();
        }
        return world;
    }

    public Region getWorldSelection() throws IncompleteRegionException {
        return this.getSelection(this.getSelectionWorld());
    }

    public Region getWorldSelection(World world) throws IncompleteRegionException {
        return this.getSelection(world);
    }

    public ClipboardHolder getClipboard() throws EmptyClipboardException {
        if (this.clipboard == null) {
            throw new EmptyClipboardException();
        }
        return this.clipboard;
    }

    @Nullable
    public ClipboardHolder getExistingClipboard() {
        return this.clipboard;
    }

    public void addClipboard(@Nonnull MultiClipboardHolder toAppend) {
        MultiClipboardHolder multi;
        Preconditions.checkNotNull((Object)toAppend);
        ClipboardHolder existing = this.getExistingClipboard();
        if (existing instanceof MultiClipboardHolder) {
            multi = (MultiClipboardHolder)existing;
            for (ClipboardHolder holder : toAppend.getHolders()) {
                multi.add(holder);
            }
        } else {
            multi = toAppend;
            if (existing != null) {
                multi.add(existing);
            }
        }
        this.setClipboard(multi);
    }

    public void setClipboard(@Nullable ClipboardHolder clipboard) {
        if (this.clipboard == clipboard) {
            return;
        }
        if (!(this.clipboard == null || clipboard != null && clipboard.contains(this.clipboard.getClipboard()))) {
            this.clipboard.close();
        }
        this.clipboard = clipboard;
    }

    public boolean isToolControlEnabled() {
        return this.toolControl;
    }

    public void setToolControl(boolean toolControl) {
        this.toolControl = toolControl;
    }

    public int getBlockChangeLimit() {
        return this.maxBlocksChanged;
    }

    public void setBlockChangeLimit(int maxBlocksChanged) {
        this.maxBlocksChanged = maxBlocksChanged;
    }

    public boolean hasSuperPickAxe() {
        return this.superPickaxe;
    }

    public void enableSuperPickAxe() {
        this.superPickaxe = true;
    }

    public void disableSuperPickAxe() {
        this.superPickaxe = false;
    }

    public boolean toggleSuperPickAxe() {
        this.superPickaxe = !this.superPickaxe;
        return this.superPickaxe;
    }

    public Vector getPlacementPosition(Player player) throws IncompleteRegionException {
        Preconditions.checkNotNull((Object)player);
        if (!this.placeAtPos1) {
            return player.getBlockIn();
        }
        return this.selector.getPrimaryPosition();
    }

    public boolean togglePlacementPosition() {
        this.placeAtPos1 = !this.placeAtPos1;
        return this.placeAtPos1;
    }

    @Nullable
    public BlockBag getBlockBag(Player player) {
        Preconditions.checkNotNull((Object)player);
        if (!this.useInventory && FawePlayer.wrap((Object)player).getLimit().INVENTORY_MODE == 0) {
            return null;
        }
        return player.getInventoryBlockBag();
    }

    @Nullable
    public Snapshot getSnapshot() {
        return this.snapshot;
    }

    public void setSnapshot(@Nullable Snapshot snapshot) {
        this.snapshot = snapshot;
    }

    public BlockTool getSuperPickaxe() {
        return this.pickaxeMode;
    }

    public void setSuperPickaxe(BlockTool tool) {
        Preconditions.checkNotNull((Object)tool);
        this.pickaxeMode = tool;
    }

    @Nullable
    public Tool getTool(ItemType item) {
        return this.tools[item.getInternalId()];
    }

    @Nullable
    public Tool getTool(Player player) {
        if (!Settings.IMP.EXPERIMENTAL.PERSISTENT_BRUSHES && !this.hasTool) {
            return null;
        }
        BaseItemStack item = player.getItemInHand(HandSide.MAIN_HAND);
        return this.getTool(item, player);
    }

    public Tool getTool(BaseItem item, Player player) {
        BrushTool tool;
        if (Settings.IMP.EXPERIMENTAL.PERSISTENT_BRUSHES && item.getNativeItem() != null && (tool = BrushCache.getTool(player, this, item)) != null) {
            return tool;
        }
        return this.getTool(item.getType());
    }

    @Deprecated
    public BrushTool getBrushTool(ItemType item) throws InvalidToolBindException {
        return this.getBrushTool(item.getDefaultState(), null, true);
    }

    @Deprecated
    public BrushTool getBrushTool(BaseItem item) throws InvalidToolBindException {
        return this.getBrushTool(item, null, true);
    }

    public BrushTool getBrushTool(Player player) throws InvalidToolBindException {
        return this.getBrushTool(player, true);
    }

    public BrushTool getBrushTool(Player player, boolean create) throws InvalidToolBindException {
        BaseItemStack item = player.getItemInHand(HandSide.MAIN_HAND);
        return this.getBrushTool(item, player, create);
    }

    public BrushTool getBrushTool(BaseItem item, Player player, boolean create) throws InvalidToolBindException {
        Tool tool = this.getTool(item, player);
        if (tool == null || !(tool instanceof BrushTool)) {
            if (create) {
                tool = new BrushTool();
                this.setTool(item, tool, player);
            } else {
                return null;
            }
        }
        return (BrushTool)tool;
    }

    @Deprecated
    public void setTool(ItemType item, @Nullable Tool tool) throws InvalidToolBindException {
        this.setTool(item.getDefaultState(), tool, null);
    }

    public void setTool(@Nullable Tool tool, Player player) throws InvalidToolBindException {
        BaseItemStack item = player.getItemInHand(HandSide.MAIN_HAND);
        this.setTool(item, tool, player);
    }

    public void setTool(BaseItem item, @Nullable Tool tool, Player player) throws InvalidToolBindException {
        Tool previous;
        ItemTypes type = item.getType();
        if (type.hasBlockType() && type.getBlockType().getMaterial().isAir()) {
            throw new InvalidToolBindException(type, "Blocks can't be used");
        }
        if (type == this.config.wandItem) {
            throw new InvalidToolBindException(type, "Already used for the wand");
        }
        if (type == this.config.navigationWand) {
            throw new InvalidToolBindException(type, "Already used for the navigation wand");
        }
        if (player != null && (tool instanceof BrushTool || tool == null) && Settings.IMP.EXPERIMENTAL.PERSISTENT_BRUSHES && item.getNativeItem() != null) {
            previous = BrushCache.getCachedTool(item);
            BrushCache.setTool(item, (BrushTool)tool);
            if (tool != null) {
                ((BrushTool)tool).setHolder(item);
            }
        } else {
            previous = this.tools[type.getInternalId()];
            this.tools[type.getInternalId()] = tool;
        }
        if (previous != null && player != null && previous instanceof BrushTool) {
            BrushTool brushTool = (BrushTool)previous;
            brushTool.clear(player);
        }
    }

    public boolean isUsingInventory() {
        return this.useInventory;
    }

    public void setUseInventory(boolean useInventory) {
        this.useInventory = useInventory;
    }

    @Nullable
    public String getLastScript() {
        return this.lastScript;
    }

    public void setLastScript(@Nullable String lastScript) {
        this.lastScript = lastScript;
        this.setDirty();
    }

    public void tellVersion(Actor player) {
    }

    public void dispatchCUIEvent(Actor actor, CUIEvent event) {
        CUI cui;
        Preconditions.checkNotNull((Object)actor);
        Preconditions.checkNotNull((Object)event);
        if (this.hasCUISupport) {
            actor.dispatchCUIEvent(event);
        } else if (actor.isPlayer() && (cui = Fawe.get().getCUI(actor)) != null) {
            cui.dispatchCUIEvent(event);
        }
    }

    public void dispatchCUISetup(Actor actor) {
        if (this.selector != null) {
            this.dispatchCUISelection(actor);
        }
    }

    public void dispatchCUISelection(Actor actor) {
        Preconditions.checkNotNull((Object)actor);
        if (this.selector instanceof CUIRegion) {
            CUIRegion tempSel = (CUIRegion)((Object)this.selector);
            if (tempSel.getProtocolVersion() > this.cuiVersion) {
                this.dispatchCUIEvent(actor, new SelectionShapeEvent(tempSel.getLegacyTypeID()));
                tempSel.describeLegacyCUI(this, actor);
            } else {
                this.dispatchCUIEvent(actor, new SelectionShapeEvent(tempSel.getTypeID()));
                tempSel.describeCUI(this, actor);
            }
        }
    }

    public void describeCUI(Actor actor) {
        Preconditions.checkNotNull((Object)actor);
        if (this.selector instanceof CUIRegion) {
            CUIRegion tempSel = (CUIRegion)((Object)this.selector);
            if (tempSel.getProtocolVersion() > this.cuiVersion) {
                tempSel.describeLegacyCUI(this, actor);
            } else {
                tempSel.describeCUI(this, actor);
            }
        }
    }

    public void handleCUIInitializationMessage(String text) {
        Preconditions.checkNotNull((Object)text);
        if (this.failedCuiAttempts > 3) {
            return;
        }
        String[] split = text.split("\\|", 2);
        if (split.length > 1 && split[0].equalsIgnoreCase("v")) {
            if (split[1].length() > 4) {
                ++this.failedCuiAttempts;
                return;
            }
            this.setCUISupport(true);
            try {
                this.setCUIVersion(Integer.parseInt(split[1]));
            }
            catch (NumberFormatException e) {
                String msg = e.getMessage();
                if (msg != null && msg.length() > 256) {
                    msg = msg.substring(0, 256);
                }
                ++this.failedCuiAttempts;
                WorldEdit.logger.warning("Error while reading CUI init message for player " + this.uuid + ": " + msg);
            }
        }
    }

    public boolean hasCUISupport() {
        return this.hasCUISupport;
    }

    public void setCUISupport(boolean support) {
        this.hasCUISupport = support;
    }

    public int getCUIVersion() {
        return this.cuiVersion;
    }

    public void setCUIVersion(int cuiVersion) {
        this.cuiVersion = cuiVersion;
    }

    @Nullable
    public Calendar detectDate(String input) {
        Preconditions.checkNotNull((Object)input);
        Time.setTimeZone(this.getTimeZone());
        Options opt = new Options();
        opt.setNow(Calendar.getInstance(this.getTimeZone()));
        Span date = Chronic.parse(input, opt);
        if (date == null) {
            return null;
        }
        return date.getBeginCalendar();
    }

    public EditSession createEditSession(Player player) {
        Preconditions.checkNotNull((Object)player);
        BlockBag blockBag = this.getBlockBag(player);
        World world = player.getWorld();
        boolean isPlayer = player.isPlayer();
        EditSessionBuilder builder = new EditSessionBuilder(world);
        if (player.isPlayer()) {
            builder.player(FawePlayer.wrap(player));
        }
        builder.blockBag(blockBag);
        builder.fastmode(this.fastMode);
        EditSession editSession = builder.build();
        Request.request().setEditSession(editSession);
        if (this.mask != null) {
            editSession.setMask(this.mask);
        }
        if (this.sourceMask != null) {
            editSession.setSourceMask(this.sourceMask);
        }
        if (this.transform != null) {
            editSession.addTransform(this.transform);
        }
        return editSession;
    }

    public boolean hasFastMode() {
        return this.fastMode;
    }

    public void setFastMode(boolean fastMode) {
        this.fastMode = fastMode;
    }

    public Mask getMask() {
        return this.mask;
    }

    public Mask getSourceMask() {
        return this.sourceMask;
    }

    public void setMask(Mask mask) {
        this.mask = mask;
    }

    public void setSourceMask(Mask mask) {
        this.sourceMask = mask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTextureUtil(TextureUtil texture) {
        LocalSession localSession = this;
        synchronized (localSession) {
            this.texture = texture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TextureUtil getTextureUtil() {
        TextureUtil tmp = this.texture;
        if (tmp == null) {
            LocalSession localSession = this;
            synchronized (localSession) {
                this.texture = tmp = Fawe.get().getCachedTextureUtil(true, 0, 100);
            }
        }
        return tmp;
    }

    public ResettableExtent getTransform() {
        return this.transform;
    }

    public void setTransform(ResettableExtent transform) {
        this.transform = transform;
    }
}

