/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.object.collection;

import com.boydti.fawe.object.collection.LocalBlockVectorSet;
import com.boydti.fawe.util.MathMan;
import com.sk89q.worldedit.MutableBlockVector;
import com.sk89q.worldedit.Vector;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

public class BlockVectorSet
extends AbstractCollection<Vector>
implements Set<Vector> {
    private Int2ObjectMap<LocalBlockVectorSet> localSets = new Int2ObjectOpenHashMap<LocalBlockVectorSet>();

    @Override
    public int size() {
        int size = 0;
        for (Int2ObjectMap.Entry entry : this.localSets.int2ObjectEntrySet()) {
            size += ((LocalBlockVectorSet)entry.getValue()).size();
        }
        return size;
    }

    public Vector get(int index) {
        int count = 0;
        for (Int2ObjectMap.Entry entry : this.localSets.int2ObjectEntrySet()) {
            int localIndex;
            Vector pos;
            LocalBlockVectorSet set = (LocalBlockVectorSet)entry.getValue();
            int size = set.size();
            int newSize = count + size;
            if (newSize > index && (pos = set.getIndex(localIndex = index - count)) != null) {
                int pair = entry.getIntKey();
                short cx = MathMan.unpairX(pair);
                short cz = MathMan.unpairY(pair);
                pos.mutX((cx << 11) + pos.getBlockX());
                pos.mutZ((cz << 11) + pos.getBlockZ());
                return pos;
            }
            count += newSize;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        for (Int2ObjectMap.Entry entry : this.localSets.int2ObjectEntrySet()) {
            if (((LocalBlockVectorSet)entry.getValue()).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean contains(int x, int y, int z) {
        int pair = MathMan.pair((short)(x >> 11), (short)(z >> 11));
        LocalBlockVectorSet localMap = (LocalBlockVectorSet)this.localSets.get(pair);
        return localMap != null && localMap.contains(x & 0x7FF, y, z & 0x7FF);
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Vector) {
            Vector v = (Vector)o;
            return this.contains(v.getBlockX(), v.getBlockY(), v.getBlockZ());
        }
        return false;
    }

    @Override
    public Iterator<Vector> iterator() {
        final ObjectIterator<Int2ObjectMap.Entry<LocalBlockVectorSet>> entries = this.localSets.int2ObjectEntrySet().iterator();
        if (!entries.hasNext()) {
            return new ArrayList().iterator();
        }
        return new Iterator<Vector>(){
            Int2ObjectMap.Entry<LocalBlockVectorSet> entry;
            Iterator<Vector> entryIter;
            MutableBlockVector mutable;
            {
                this.entry = (Int2ObjectMap.Entry)entries.next();
                this.entryIter = ((LocalBlockVectorSet)this.entry.getValue()).iterator();
                this.mutable = new MutableBlockVector();
            }

            @Override
            public void remove() {
                this.entryIter.remove();
            }

            @Override
            public boolean hasNext() {
                return this.entryIter.hasNext() || entries.hasNext();
            }

            @Override
            public Vector next() {
                while (!this.entryIter.hasNext()) {
                    if (!entries.hasNext()) {
                        throw new NoSuchElementException("End of iterator");
                    }
                    this.entry = (Int2ObjectMap.Entry)entries.next();
                    this.entryIter = ((LocalBlockVectorSet)this.entry.getValue()).iterator();
                }
                Vector localPos = this.entryIter.next();
                int pair = this.entry.getIntKey();
                short cx = MathMan.unpairX(pair);
                short cz = MathMan.unpairY(pair);
                return this.mutable.setComponents((cx << 11) + localPos.getBlockX(), localPos.getBlockY(), (cz << 11) + localPos.getBlockZ());
            }
        };
    }

    @Override
    public boolean add(Vector vector) {
        return this.add(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ());
    }

    public boolean add(int x, int y, int z) {
        int pair = MathMan.pair((short)(x >> 11), (short)(z >> 11));
        LocalBlockVectorSet localMap = (LocalBlockVectorSet)this.localSets.get(pair);
        if (localMap == null) {
            localMap = new LocalBlockVectorSet();
            localMap.setOffset(1024, 1024);
            this.localSets.put(pair, localMap);
        }
        return localMap.add(x & 0x7FF, y, z & 0x7FF);
    }

    public boolean remove(int x, int y, int z) {
        int pair = MathMan.pair((short)(x >> 11), (short)(z >> 11));
        LocalBlockVectorSet localMap = (LocalBlockVectorSet)this.localSets.get(pair);
        if (localMap != null && localMap.remove(x & 0x7FF, y, z & 0x7FF)) {
            if (localMap.isEmpty()) {
                this.localSets.remove(pair);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof Vector) {
            Vector v = (Vector)o;
            return this.remove(v.getBlockX(), v.getBlockY(), v.getBlockZ());
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Vector> c) {
        boolean result = false;
        for (Vector vector : c) {
            result |= this.add(vector);
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        Objects.requireNonNull(c);
        boolean modified = false;
        Iterator<Vector> it = this.iterator();
        while (it.hasNext()) {
            if (c.contains(it.next())) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = false;
        for (Object o : c) {
            result |= this.remove(o);
        }
        return result;
    }

    @Override
    public void clear() {
        this.localSets.clear();
    }
}

