/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.installer;

import com.boydti.fawe.FaweVersion;
import com.boydti.fawe.installer.BrowseButton;
import com.boydti.fawe.installer.CloseButton;
import com.boydti.fawe.installer.InteractiveButton;
import com.boydti.fawe.installer.InvisiblePanel;
import com.boydti.fawe.installer.MinimizeButton;
import com.boydti.fawe.installer.MovablePanel;
import com.boydti.fawe.installer.TextAreaOutputStream;
import com.boydti.fawe.installer.URLButton;
import com.boydti.fawe.util.MainUtil;
import com.boydti.fawe.util.StringMan;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Scanner;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class InstallerFrame
extends JFrame {
    private final InvisiblePanel loggerPanel;
    private Color LIGHT_GRAY = new Color(102, 102, 102);
    private Color GRAY = new Color(68, 68, 70);
    private Color DARK_GRAY = new Color(51, 51, 54);
    private Color DARKER_GRAY = new Color(38, 38, 40);
    private Color INVISIBLE = new Color(0, 0, 0, 0);
    private Color OFF_WHITE = new Color(200, 200, 200);
    private JTextArea loggerTextArea;
    private BrowseButton browse;
    private boolean newLine = false;

    public InstallerFrame() throws Exception {
        final MovablePanel movable = new MovablePanel(this);
        Container content = this.getContentPane();
        content.add(movable);
        this.setSize(480, 320);
        this.setDefaultCloseOperation(3);
        this.setUndecorated(true);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (int)((dimension.getWidth() - (double)this.getWidth()) / 2.0);
        int y = (int)((dimension.getHeight() - (double)this.getHeight()) / 2.0);
        this.setLocation(x, y);
        this.setVisible(true);
        this.setOpacity(0.0f);
        movable.setBackground(this.DARK_GRAY);
        movable.setLayout(new BorderLayout());
        this.fadeIn();
        InvisiblePanel topBar = new InvisiblePanel(new BorderLayout());
        InvisiblePanel topBarLeft = new InvisiblePanel();
        InvisiblePanel topBarRight = new InvisiblePanel();
        JLabel title = new JLabel("FastAsyncWorldEdit Installer");
        title.setHorizontalAlignment(0);
        title.setAlignmentX(1.0f);
        title.setForeground(this.LIGHT_GRAY);
        MinimizeButton minimize = new MinimizeButton(this);
        CloseButton exit = new CloseButton();
        topBarLeft.add(title);
        topBarRight.add(minimize);
        topBarRight.add(exit);
        topBar.add((Component)topBarLeft, "Center");
        topBar.add((Component)topBarRight, "East");
        InvisiblePanel mainContent = new InvisiblePanel(new BorderLayout());
        InvisiblePanel browseContent = new InvisiblePanel(new BorderLayout());
        File dir = MainUtil.getWorkingDirectory("minecraft");
        JLabel folder = new JLabel("Folder: ");
        folder.setForeground(this.OFF_WHITE);
        final InteractiveButton text = new InteractiveButton(dir.getPath(), this.DARKER_GRAY){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstallerFrame.this.browse.actionPerformed(e);
            }
        };
        text.setForeground(this.OFF_WHITE);
        text.setBackground(this.DARKER_GRAY);
        text.setOpaque(true);
        text.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.browse = new BrowseButton(""){

            @Override
            public void onSelect(File folder) {
                text.setText(folder.getPath());
                movable.repaint();
            }
        };
        InteractiveButton install = new InteractiveButton(">> Create Profile <<", this.DARKER_GRAY){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    InstallerFrame.this.install(text.getText());
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        };
        browseContent.add((Component)folder, "West");
        browseContent.add((Component)text, "Center");
        browseContent.add((Component)this.browse, "East");
        InvisiblePanel installContent = new InvisiblePanel(new FlowLayout());
        install.setPreferredSize(new Dimension(416, 32));
        installContent.add(install);
        installContent.setBorder(new EmptyBorder(10, 0, 10, 0));
        this.loggerPanel = new InvisiblePanel(new BorderLayout());
        this.loggerPanel.setBackground(Color.GREEN);
        this.loggerPanel.setPreferredSize(new Dimension(416, 160));
        this.loggerTextArea = new JTextArea(12, 52);
        this.loggerTextArea.setBackground(this.GRAY);
        this.loggerTextArea.setForeground(this.DARKER_GRAY);
        this.loggerTextArea.setFont(new Font(this.loggerTextArea.getFont().getName(), 0, 9));
        JScrollPane scroll = new JScrollPane(this.loggerTextArea, 20, 31);
        scroll.setBackground(this.DARK_GRAY);
        scroll.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.loggerPanel.add(scroll);
        this.loggerPanel.setVisible(false);
        mainContent.setBorder(new EmptyBorder(6, 32, 6, 32));
        mainContent.add((Component)browseContent, "North");
        mainContent.add((Component)installContent, "Center");
        mainContent.add((Component)this.loggerPanel, "South");
        InvisiblePanel bottomBar = new InvisiblePanel();
        try {
            InputStream stream = this.getClass().getResourceAsStream("/fawe.properties");
            Scanner scanner = new Scanner(stream).useDelimiter("\\A");
            String versionString = scanner.next().trim();
            scanner.close();
            FaweVersion version = new FaweVersion(versionString);
            String date = new Date(100 + version.year, version.month, version.day).toGMTString();
            String build = "https://ci.athion.net/job/FastAsyncWorldEdit/" + version.build;
            String commit = "https://github.com/boy0001/FastAsyncWorldedit/commit/" + Integer.toHexString(version.hash);
            String footerMessage = "FAWE v" + version.major + "." + version.minor + "." + version.patch + " by Empire92 (c) 2017 (GPL v3.0)";
            URL licenseUrl = new URL("https://github.com/boy0001/FastAsyncWorldedit/blob/master/LICENSE");
            URLButton licenseButton = new URLButton(licenseUrl, footerMessage);
            bottomBar.add(licenseButton);
        }
        catch (Throwable ignore) {
            ignore.printStackTrace();
        }
        URL chat = new URL("http://webchat.esper.net/?nick=&channels=IntellectualCrafters&fg_color=000&fg_sec_color=000&bg_color=FFF");
        URLButton chatButton = new URLButton(chat, "Chat");
        bottomBar.add(chatButton);
        URL wiki = new URL("https://github.com/boy0001/FastAsyncWorldedit/wiki");
        URLButton wikiButton = new URLButton(wiki, "Wiki");
        bottomBar.add(wikiButton);
        URL issue = new URL("https://github.com/boy0001/FastAsyncWorldedit/issues/new");
        URLButton issueButton = new URLButton(issue, "Report Issue");
        bottomBar.add(issueButton);
        movable.add((Component)topBar, "North");
        this.setVisible(true);
        this.repaint();
        movable.add((Component)mainContent, "Center");
        this.setVisible(true);
        this.repaint();
        movable.add((Component)bottomBar, "South");
        this.setVisible(true);
        this.repaint();
    }

    public void prompt(String message) {
        JOptionPane.showMessageDialog(null, message);
    }

    public void debug(String m) {
        System.out.println(m);
    }

    public void install(String name) throws Exception {
        if (!this.loggerPanel.isVisible()) {
            this.loggerPanel.setVisible(true);
            this.repaint();
            System.setOut(new TextAreaOutputStream(this.loggerTextArea));
        }
        if (name == null || name.isEmpty()) {
            this.prompt("No folder selection");
            return;
        }
        final File dirMc = new File(name);
        if (!dirMc.exists()) {
            this.prompt("Folder does not exist");
            return;
        }
        if (!dirMc.isDirectory()) {
            this.prompt("You must select a folder, not a file");
            return;
        }
        Thread installThread = new Thread(new Runnable(){

            @Override
            public void run() {
                Throwable throwable;
                FileOutputStream fos2;
                Throwable throwable2;
                ReadableByteChannel rbc;
                URL worldEditCuiUrl;
                URL worldEditUrl;
                URL forgeUrl;
                List<String> supported = Arrays.asList("v1710", "v189", "v194", "v110", "v111");
                String supportedString = null;
                for (String version : supported) {
                    try {
                        Class.forName("com.boydti.fawe.forge." + version + ".ForgeChunk_All");
                        supportedString = version;
                        break;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                }
                if (supportedString == null) {
                    InstallerFrame.this.prompt("This version of FAWE cannot be installed this way.");
                    return;
                }
                InstallerFrame.this.debug("Selected version " + supportedString);
                try {
                    switch (supportedString) {
                        case "v111": {
                            forgeUrl = new URL("https://files.minecraftforge.net/maven/net/minecraftforge/forge/1.11.2-13.20.0.2201/forge-1.11.2-13.20.0.2201-installer.jar");
                            worldEditUrl = new URL("http://builds.enginehub.org/job/worldedit/9593/download/worldedit-forge-mc1.11-6.1.6-SNAPSHOT-dist.jar");
                            worldEditCuiUrl = new URL("https://addons-origin.cursecdn.com/files/2361/241/worldeditcuife-v1.0.6-mf-1.11.2-13.20.0.2201.jar");
                            break;
                        }
                        case "v110": {
                            forgeUrl = new URL("http://files.minecraftforge.net/maven/net/minecraftforge/forge/1.10.2-12.18.3.2185/forge-1.10.2-12.18.3.2185-installer.jar");
                            worldEditUrl = new URL("http://builds.enginehub.org/job/worldedit/9395/download/worldedit-forge-mc1.10.2-6.1.4-SNAPSHOT-dist.jar");
                            worldEditCuiUrl = new URL("https://addons-origin.cursecdn.com/files/2361/239/WorldEditCuiFe-v1.0.6-mf-1.10.2-12.18.2.2125.jar");
                            break;
                        }
                        case "v194": {
                            forgeUrl = new URL("https://files.minecraftforge.net/maven/net/minecraftforge/forge/1.9.4-12.17.0.2051/forge-1.9.4-12.17.0.2051-installer.jar");
                            worldEditUrl = new URL("http://builds.enginehub.org/job/worldedit/9171/download/worldedit-forge-mc1.9.4-6.1.3-SNAPSHOT-dist.jar");
                            worldEditCuiUrl = new URL("https://addons-origin.cursecdn.com/files/2361/236/WorldEditCuiFe-v1.0.6-mf-1.9.4-12.17.0.1976.jar");
                            break;
                        }
                        case "v189": {
                            forgeUrl = new URL("https://files.minecraftforge.net/maven/net/minecraftforge/forge/1.8.9-11.15.1.1902-1.8.9/forge-1.8.9-11.15.1.1902-1.8.9-installer.jar");
                            worldEditUrl = new URL("http://builds.enginehub.org/job/worldedit/8755/download/worldedit-forge-mc1.8.9-6.1.1-dist.jar");
                            worldEditCuiUrl = new URL("https://addons-origin.cursecdn.com/files/2361/235/WorldEditCuiFe-v1.0.6-mf-1.8.9-11.15.1.1855.jar");
                            break;
                        }
                        case "v1710": {
                            forgeUrl = new URL("https://files.minecraftforge.net/maven/net/minecraftforge/forge/1.7.10-10.13.4.1614-1.7.10/forge-1.7.10-10.13.4.1614-1.7.10-installer.jar");
                            worldEditUrl = new URL("http://builds.enginehub.org/job/worldedit/9194/download/worldedit-forge-mc1.7.10-6.1.2-SNAPSHOT-dist.jar");
                            worldEditCuiUrl = new URL("https://addons-origin.cursecdn.com/files/2361/234/WorldEditCuiFe-v1.0.6-mf-1.7.10-10.13.4.1566.jar");
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    return;
                }
                try {
                    InstallerFrame.this.debug("Downloading forge installer from:\n - https://files.minecraftforge.net/");
                    URLClassLoader loader = new URLClassLoader(new URL[]{forgeUrl});
                    InstallerFrame.this.debug("Connected");
                    Class<?> forgeInstallClass = loader.loadClass("net.minecraftforge.installer.ClientInstall");
                    InstallerFrame.this.debug("Found ClientInstall class");
                    Object forgeInstallInstance = forgeInstallClass.newInstance();
                    InstallerFrame.this.debug(forgeInstallInstance + " | " + forgeInstallClass + " | " + StringMan.getString(forgeInstallClass.getMethods()));
                    InstallerFrame.this.debug("Created instance " + forgeInstallInstance);
                    Method methodRun = forgeInstallClass.getDeclaredMethods()[0];
                    Object alwaysTrue = loader.loadClass("com.google.common.base.Predicates").getDeclaredMethod("alwaysTrue", new Class[0]).invoke(null, new Object[0]);
                    methodRun.invoke(forgeInstallInstance, dirMc, alwaysTrue);
                    InstallerFrame.this.debug("Forge profile created, now installing WorldEdit");
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    InstallerFrame.this.prompt("[ERROR] Forge install failed, download from:\nhttps://files.minecraftforge.net/");
                }
                File mods = new File(dirMc, "mods");
                if (!mods.exists()) {
                    InstallerFrame.this.debug("Creating mods directory");
                    mods.mkdirs();
                } else {
                    for (File file : mods.listFiles()) {
                        String name = file.getName().toLowerCase();
                        if (!name.contains("worldedit") && !name.contains("fawe")) continue;
                        InstallerFrame.this.debug("Delete existing: " + file.getName());
                        file.delete();
                    }
                }
                try {
                    InstallerFrame.this.debug("Downloading WE-CUI from:\n - https://minecraft.curseforge.com/projects/worldeditcui-forge-edition");
                    rbc = Channels.newChannel(worldEditCuiUrl.openStream());
                    throwable2 = null;
                    try {
                        fos2 = new FileOutputStream(new File(mods, "WorldEditCUI.jar"));
                        throwable = null;
                        try {
                            fos2.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (fos2 != null) {
                                if (throwable != null) {
                                    try {
                                        fos2.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                } else {
                                    fos2.close();
                                }
                            }
                        }
                    }
                    catch (Throwable fos2) {
                        throwable2 = fos2;
                        throw fos2;
                    }
                    finally {
                        if (rbc != null) {
                            if (throwable2 != null) {
                                try {
                                    rbc.close();
                                }
                                catch (Throwable fos2) {
                                    throwable2.addSuppressed(fos2);
                                }
                            } else {
                                rbc.close();
                            }
                        }
                    }
                    InstallerFrame.this.debug("Successfully downloaded WorldEdit-CUI");
                }
                catch (Throwable e) {
                    InstallerFrame.this.prompt("[ERROR] WorldEdit install failed, download from:\nhttp://builds.enginehub.org/job/worldedit");
                }
                try {
                    InstallerFrame.this.debug("Downloading WorldEdit from:\n - http://builds.enginehub.org/job/worldedit");
                    rbc = Channels.newChannel(worldEditUrl.openStream());
                    throwable2 = null;
                    try {
                        fos2 = new FileOutputStream(new File(mods, "WorldEdit.jar"));
                        throwable = null;
                        try {
                            fos2.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                        }
                        catch (Throwable throwable5) {
                            throwable = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (fos2 != null) {
                                if (throwable != null) {
                                    try {
                                        fos2.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    fos2.close();
                                }
                            }
                        }
                    }
                    catch (Throwable throwable7) {
                        throwable2 = throwable7;
                        throw throwable7;
                    }
                    finally {
                        if (rbc != null) {
                            if (throwable2 != null) {
                                try {
                                    rbc.close();
                                }
                                catch (Throwable throwable8) {
                                    throwable2.addSuppressed(throwable8);
                                }
                            } else {
                                rbc.close();
                            }
                        }
                    }
                    InstallerFrame.this.debug("Successfully downloaded WorldEdit");
                }
                catch (Throwable e) {
                    InstallerFrame.this.prompt("[ERROR] WorldEdit install failed, download from:\nhttp://builds.enginehub.org/job/worldedit");
                }
                try {
                    InstallerFrame.this.debug("Copying FastAsyncWorldEdit to mods directory");
                    File file = new File(InstallerFrame.class.getProtectionDomain().getCodeSource().getLocation().getPath());
                    InstallerFrame.this.debug(" - " + file.getPath());
                    MainUtil.copyFile(file, new File(mods, "FastAsyncWorldEdit.jar"));
                    InstallerFrame.this.debug("Installation complete!");
                }
                catch (Throwable e) {
                    InstallerFrame.this.prompt("[ERROR] Copy installer failed, please copy this installer jar manually");
                }
                InstallerFrame.this.prompt("Installation complete!\nLaunch the game using the forge profile.");
            }
        });
        installThread.start();
    }

    public void fadeIn() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                float i = 0.0f;
                while (i <= 1.0f) {
                    InstallerFrame.this.setOpacity(i);
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    i = (float)((double)i + 0.001);
                }
            }
        });
        thread.start();
    }

    public static void main(String[] args) throws Exception {
        InstallerFrame window = new InstallerFrame();
    }
}

