/*
 * Decompiled with CFR 0.152.
 */
package com.boydti.fawe.bukkit.adapter.v1_13_1;

import com.boydti.fawe.Fawe;
import com.boydti.fawe.bukkit.adapter.v1_13_1.BlockMaterial_1_13;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.sk89q.jnbt.ByteArrayTag;
import com.sk89q.jnbt.ByteTag;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.DoubleTag;
import com.sk89q.jnbt.EndTag;
import com.sk89q.jnbt.FloatTag;
import com.sk89q.jnbt.IntArrayTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.LongTag;
import com.sk89q.jnbt.NBTConstants;
import com.sk89q.jnbt.ShortTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.blocks.BlockMaterial;
import com.sk89q.worldedit.blocks.TileEntityBlock;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.adapter.BukkitImplAdapter;
import com.sk89q.worldedit.bukkit.adapter.CachedBukkitAdapter;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.internal.Constants;
import com.sk89q.worldedit.registry.state.AbstractProperty;
import com.sk89q.worldedit.registry.state.BooleanProperty;
import com.sk89q.worldedit.registry.state.DirectionalProperty;
import com.sk89q.worldedit.registry.state.EnumProperty;
import com.sk89q.worldedit.registry.state.IntegerProperty;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.server.v1_13_R2.BiomeBase;
import net.minecraft.server.v1_13_R2.BlockPosition;
import net.minecraft.server.v1_13_R2.BlockStateBoolean;
import net.minecraft.server.v1_13_R2.BlockStateDirection;
import net.minecraft.server.v1_13_R2.BlockStateEnum;
import net.minecraft.server.v1_13_R2.BlockStateInteger;
import net.minecraft.server.v1_13_R2.BlockStateList;
import net.minecraft.server.v1_13_R2.ChunkSection;
import net.minecraft.server.v1_13_R2.EntityTypes;
import net.minecraft.server.v1_13_R2.IBlockData;
import net.minecraft.server.v1_13_R2.IBlockState;
import net.minecraft.server.v1_13_R2.INamable;
import net.minecraft.server.v1_13_R2.IRegistry;
import net.minecraft.server.v1_13_R2.MinecraftKey;
import net.minecraft.server.v1_13_R2.NBTBase;
import net.minecraft.server.v1_13_R2.NBTTagByte;
import net.minecraft.server.v1_13_R2.NBTTagByteArray;
import net.minecraft.server.v1_13_R2.NBTTagCompound;
import net.minecraft.server.v1_13_R2.NBTTagDouble;
import net.minecraft.server.v1_13_R2.NBTTagEnd;
import net.minecraft.server.v1_13_R2.NBTTagFloat;
import net.minecraft.server.v1_13_R2.NBTTagInt;
import net.minecraft.server.v1_13_R2.NBTTagIntArray;
import net.minecraft.server.v1_13_R2.NBTTagList;
import net.minecraft.server.v1_13_R2.NBTTagLong;
import net.minecraft.server.v1_13_R2.NBTTagShort;
import net.minecraft.server.v1_13_R2.NBTTagString;
import net.minecraft.server.v1_13_R2.PlayerChunkMap;
import net.minecraft.server.v1_13_R2.TileEntity;
import net.minecraft.server.v1_13_R2.World;
import net.minecraft.server.v1_13_R2.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_13_R2.CraftChunk;
import org.bukkit.craftbukkit.v1_13_R2.CraftServer;
import org.bukkit.craftbukkit.v1_13_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_13_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_13_R2.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_13_R2.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.event.entity.CreatureSpawnEvent;

public final class Spigot_v1_13_R2
extends CachedBukkitAdapter
implements BukkitImplAdapter<NBTBase> {
    private final Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    private final Field nbtListTagListField = NBTTagList.class.getDeclaredField("list");
    private final Method nbtCreateTagMethod;
    private int[] idbToStateOrdinal;

    public Spigot_v1_13_R2() throws NoSuchFieldException, NoSuchMethodException {
        this.nbtListTagListField.setAccessible(true);
        this.nbtCreateTagMethod = NBTBase.class.getDeclaredMethod("createTag", Byte.TYPE);
        this.nbtCreateTagMethod.setAccessible(true);
    }

    private boolean init() {
        if (this.idbToStateOrdinal != null) {
            return false;
        }
        this.idbToStateOrdinal = new int[net.minecraft.server.v1_13_R2.Block.REGISTRY_ID.a()];
        for (int i = 0; i < this.idbToStateOrdinal.length; ++i) {
            BlockState state = BlockTypes.states[i];
            BlockMaterial_1_13 material = (BlockMaterial_1_13)state.getMaterial();
            int id = net.minecraft.server.v1_13_R2.Block.REGISTRY_ID.getId((Object)material.getState());
            this.idbToStateOrdinal[id] = state.getOrdinal();
        }
        return true;
    }

    private static void readTagIntoTileEntity(NBTTagCompound tag, TileEntity tileEntity) {
        try {
            tileEntity.load(tag);
        }
        catch (Throwable e) {
            Fawe.debug("Invalid tag " + tag + " | " + tileEntity);
        }
    }

    private static void readTileEntityIntoTag(TileEntity tileEntity, NBTTagCompound tag) {
        tileEntity.save(tag);
    }

    @Nullable
    private static String getEntityId(net.minecraft.server.v1_13_R2.Entity entity) {
        MinecraftKey minecraftkey = EntityTypes.getName((EntityTypes)entity.getBukkitEntity().getHandle().P());
        return minecraftkey == null ? null : minecraftkey.toString();
    }

    @Nullable
    private static net.minecraft.server.v1_13_R2.Entity createEntityFromId(String id, World world) {
        return EntityTypes.a((World)world, (MinecraftKey)new MinecraftKey(id));
    }

    private static void readTagIntoEntity(NBTTagCompound tag, net.minecraft.server.v1_13_R2.Entity entity) {
        entity.f(tag);
    }

    private static void readEntityIntoTag(net.minecraft.server.v1_13_R2.Entity entity, NBTTagCompound tag) {
        entity.save(tag);
    }

    @Override
    public BlockMaterial getMaterial(BlockType blockType) {
        return new BlockMaterial_1_13(this.getBlock(blockType));
    }

    @Override
    public BlockMaterial getMaterial(BlockState state) {
        BlockTypes type = state.getBlockType();
        IBlockData bs = ((CraftBlockData)Bukkit.createBlockData((String)state.getAsString())).getState();
        return new BlockMaterial_1_13(bs.getBlock(), bs);
    }

    public net.minecraft.server.v1_13_R2.Block getBlock(BlockType blockType) {
        return (net.minecraft.server.v1_13_R2.Block)IRegistry.BLOCK.getOrDefault(new MinecraftKey(blockType.getNamespace(), blockType.getResource()));
    }

    @Override
    public int getBiomeId(Biome biome) {
        BiomeBase mcBiome = CraftBlock.biomeToBiomeBase((Biome)biome);
        return mcBiome != null ? IRegistry.BIOME.a((Object)mcBiome) : 0;
    }

    @Override
    public Biome getBiome(int id) {
        BiomeBase mcBiome = (BiomeBase)IRegistry.BIOME.fromId(id);
        return CraftBlock.biomeBaseToBiome((BiomeBase)mcBiome);
    }

    @Override
    public BlockState getBlock(Location location) {
        TileEntity te;
        Preconditions.checkNotNull((Object)location);
        CraftWorld craftWorld = (CraftWorld)location.getWorld();
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        Block bukkitBlock = location.getBlock();
        BlockState state = BukkitAdapter.adapt(bukkitBlock.getBlockData());
        if (state.getBlockType().getMaterial().hasContainer() && (te = craftWorld.getHandle().getTileEntity(new BlockPosition(x, y, z))) != null) {
            NBTTagCompound tag = new NBTTagCompound();
            Spigot_v1_13_R2.readTileEntityIntoTag(te, tag);
            return new BaseBlock(state, (CompoundTag)this.toNative((NBTBase)tag));
        }
        return state;
    }

    @Override
    public boolean isChunkInUse(Chunk chunk) {
        CraftChunk craftChunk = (CraftChunk)chunk;
        PlayerChunkMap chunkMap = ((WorldServer)craftChunk.getHandle().getWorld()).getPlayerChunkMap();
        return chunkMap.isChunkInUse(chunk.getX(), chunk.getZ());
    }

    @Override
    public boolean setBlock(Chunk chunk, int x, int y, int z, BlockStateHolder state, boolean update) {
        int y4;
        CraftChunk craftChunk = (CraftChunk)chunk;
        net.minecraft.server.v1_13_R2.Chunk nmsChunk = craftChunk.getHandle();
        World nmsWorld = nmsChunk.getWorld();
        IBlockData blockData = ((BlockMaterial_1_13)state.getMaterial()).getState();
        ChunkSection[] sections = nmsChunk.getSections();
        ChunkSection section = sections[y4 = y >> 4];
        IBlockData existing = section == null ? ((BlockMaterial_1_13)BlockTypes.AIR.getDefaultState().getMaterial()).getState() : section.getType(x & 0xF, y & 0xF, z & 0xF);
        BlockPosition pos = null;
        if (existing instanceof TileEntityBlock || blockData instanceof TileEntityBlock) {
            TileEntity tileEntity;
            pos = new BlockPosition(x, y, z);
            nmsWorld.setTypeAndData(pos, blockData, 0);
            CompoundTag nativeTag = state.getNbtData();
            if (nativeTag != null && (tileEntity = nmsWorld.getTileEntity(pos)) != null) {
                NBTTagCompound tag = (NBTTagCompound)this.fromNative(nativeTag);
                tag.set("x", (NBTBase)new NBTTagInt(x));
                tag.set("y", (NBTBase)new NBTTagInt(y));
                tag.set("z", (NBTBase)new NBTTagInt(z));
                Spigot_v1_13_R2.readTagIntoTileEntity(tag, tileEntity);
            }
        } else {
            if (existing == blockData) {
                return true;
            }
            if (section == null) {
                if (blockData.isAir()) {
                    return true;
                }
                sections[y4] = section = new ChunkSection(y4 << 4, nmsWorld.worldProvider.g());
            }
            if (existing.e() != blockData.e() || existing.getMaterial().f() != blockData.getMaterial().f()) {
                pos = new BlockPosition(x, y, z);
                nmsChunk.a(pos, blockData, false);
            } else {
                section.setType(x & 0xF, y & 0xF, z & 0xF, blockData);
            }
        }
        if (update) {
            if (pos == null) {
                pos = new BlockPosition(x, y, z);
            }
            nmsWorld.getMinecraftWorld().notify(pos, existing, blockData, 0);
        }
        return true;
    }

    @Override
    public BaseEntity getEntity(Entity entity) {
        Preconditions.checkNotNull((Object)entity);
        CraftEntity craftEntity = (CraftEntity)entity;
        net.minecraft.server.v1_13_R2.Entity mcEntity = craftEntity.getHandle();
        String id = Spigot_v1_13_R2.getEntityId(mcEntity);
        if (id != null) {
            NBTTagCompound tag = new NBTTagCompound();
            Spigot_v1_13_R2.readEntityIntoTag(mcEntity, tag);
            return new BaseEntity(com.sk89q.worldedit.world.entity.EntityTypes.get(id), (CompoundTag)this.toNative((NBTBase)tag));
        }
        return null;
    }

    @Override
    @Nullable
    public Entity createEntity(Location location, BaseEntity state) {
        Preconditions.checkNotNull((Object)location);
        Preconditions.checkNotNull((Object)state);
        CraftWorld craftWorld = (CraftWorld)location.getWorld();
        WorldServer worldServer = craftWorld.getHandle();
        net.minecraft.server.v1_13_R2.Entity createdEntity = Spigot_v1_13_R2.createEntityFromId(state.getType().getId(), (World)craftWorld.getHandle());
        if (createdEntity != null) {
            CompoundTag nativeTag = state.getNbtData();
            if (nativeTag != null) {
                NBTTagCompound tag = (NBTTagCompound)this.fromNative(nativeTag);
                for (String name : Constants.NO_COPY_ENTITY_NBT_FIELDS) {
                    tag.remove(name);
                }
                Spigot_v1_13_R2.readTagIntoEntity(tag, createdEntity);
            }
            createdEntity.setLocation(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
            worldServer.addEntity(createdEntity, CreatureSpawnEvent.SpawnReason.CUSTOM);
            return createdEntity.getBukkitEntity();
        }
        Fawe.debug("Invalid entity " + state.getType().getId());
        return null;
    }

    @Override
    public Map<String, ? extends Property> getProperties(BlockType blockType) {
        net.minecraft.server.v1_13_R2.Block block;
        try {
            block = (net.minecraft.server.v1_13_R2.Block)IRegistry.BLOCK.getOrDefault(new MinecraftKey(blockType.getNamespace(), blockType.getResource()));
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            return Collections.emptyMap();
        }
        if (block == null) {
            this.logger.warning("Failed to find properties for " + blockType.getId());
            return Collections.emptyMap();
        }
        LinkedHashMap properties = Maps.newLinkedHashMap();
        BlockStateList blockStateList = block.getStates();
        for (IBlockState state : blockStateList.d()) {
            AbstractProperty property;
            if (state instanceof BlockStateBoolean) {
                property = new BooleanProperty(state.a(), (List<Boolean>)ImmutableList.copyOf((Collection)state.d()));
            } else if (state instanceof BlockStateDirection) {
                property = new DirectionalProperty(state.a(), state.d().stream().map(e -> Direction.valueOf(((INamable)e).getName().toUpperCase())).collect(Collectors.toList()));
            } else if (state instanceof BlockStateEnum) {
                property = new EnumProperty(state.a(), state.d().stream().map(e -> ((INamable)e).getName()).collect(Collectors.toList()));
            } else if (state instanceof BlockStateInteger) {
                property = new IntegerProperty(state.a(), (List<Integer>)ImmutableList.copyOf((Collection)state.d()));
            } else {
                throw new IllegalArgumentException("WorldEdit needs an update to support " + state.getClass().getSimpleName());
            }
            properties.put(property.getName(), property);
        }
        return properties;
    }

    @Override
    public Tag toNative(NBTBase foreign) {
        if (foreign == null) {
            return null;
        }
        if (foreign instanceof NBTTagCompound) {
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            Set foreignKeys = ((NBTTagCompound)foreign).getKeys();
            for (String str : foreignKeys) {
                NBTBase base = ((NBTTagCompound)foreign).get(str);
                values.put(str, this.toNative(base));
            }
            return new CompoundTag(values);
        }
        if (foreign instanceof NBTTagByte) {
            return new ByteTag(((NBTTagByte)foreign).g());
        }
        if (foreign instanceof NBTTagByteArray) {
            return new ByteArrayTag(((NBTTagByteArray)foreign).c());
        }
        if (foreign instanceof NBTTagDouble) {
            return new DoubleTag(((NBTTagDouble)foreign).asDouble());
        }
        if (foreign instanceof NBTTagFloat) {
            return new FloatTag(((NBTTagFloat)foreign).i());
        }
        if (foreign instanceof NBTTagInt) {
            return new IntTag(((NBTTagInt)foreign).e());
        }
        if (foreign instanceof NBTTagIntArray) {
            return new IntArrayTag(((NBTTagIntArray)foreign).d());
        }
        if (foreign instanceof NBTTagList) {
            try {
                return this.toNativeList((NBTTagList)foreign);
            }
            catch (Throwable e) {
                this.logger.log(Level.WARNING, "Failed to convert NBTTagList", e);
                return new ListTag<ByteTag>(ByteTag.class, new ArrayList());
            }
        }
        if (foreign instanceof NBTTagLong) {
            return new LongTag(((NBTTagLong)foreign).d());
        }
        if (foreign instanceof NBTTagShort) {
            return new ShortTag(((NBTTagShort)foreign).f());
        }
        if (foreign instanceof NBTTagString) {
            return new StringTag(foreign.b_());
        }
        if (foreign instanceof NBTTagEnd) {
            return EndTag.INSTANCE;
        }
        throw new IllegalArgumentException("Don't know how to make native " + foreign.getClass().getCanonicalName());
    }

    public ListTag toNativeList(NBTTagList foreign) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        ArrayList<Tag> values = new ArrayList<Tag>();
        byte type = foreign.getTypeId();
        List foreignList = (List)this.nbtListTagListField.get(foreign);
        for (int i = 0; i < foreign.size(); ++i) {
            NBTBase element = (NBTBase)foreignList.get(i);
            values.add(this.toNative(element));
        }
        Class<? extends Tag> cls = NBTConstants.getClassFromType(type);
        return new ListTag<Tag>(cls, values);
    }

    @Override
    public NBTBase fromNative(Tag foreign) {
        if (foreign == null) {
            return null;
        }
        if (foreign instanceof CompoundTag) {
            NBTTagCompound tag = new NBTTagCompound();
            for (Map.Entry entry : ((CompoundTag)foreign).getValue().entrySet()) {
                tag.set((String)entry.getKey(), this.fromNative((Tag)entry.getValue()));
            }
            return tag;
        }
        if (foreign instanceof ByteTag) {
            return new NBTTagByte(((ByteTag)foreign).getValue().byteValue());
        }
        if (foreign instanceof ByteArrayTag) {
            return new NBTTagByteArray(((ByteArrayTag)foreign).getValue());
        }
        if (foreign instanceof DoubleTag) {
            return new NBTTagDouble(((DoubleTag)foreign).getValue().doubleValue());
        }
        if (foreign instanceof FloatTag) {
            return new NBTTagFloat(((FloatTag)foreign).getValue().floatValue());
        }
        if (foreign instanceof IntTag) {
            return new NBTTagInt(((IntTag)foreign).getValue().intValue());
        }
        if (foreign instanceof IntArrayTag) {
            return new NBTTagIntArray(((IntArrayTag)foreign).getValue());
        }
        if (foreign instanceof ListTag) {
            NBTTagList tag = new NBTTagList();
            ListTag foreignList = (ListTag)foreign;
            Iterator iterator = foreignList.getValue().iterator();
            while (iterator.hasNext()) {
                Tag t = (Tag)iterator.next();
                tag.add(this.fromNative(t));
            }
            return tag;
        }
        if (foreign instanceof LongTag) {
            return new NBTTagLong(((LongTag)foreign).getValue().longValue());
        }
        if (foreign instanceof ShortTag) {
            return new NBTTagShort(((ShortTag)foreign).getValue().shortValue());
        }
        if (foreign instanceof StringTag) {
            return new NBTTagString(((StringTag)foreign).getValue());
        }
        if (foreign instanceof EndTag) {
            try {
                return (NBTBase)this.nbtCreateTagMethod.invoke(null, (byte)0);
            }
            catch (Exception e) {
                return null;
            }
        }
        throw new IllegalArgumentException("Don't know how to make NMS " + foreign.getClass().getCanonicalName());
    }

    @Override
    public BlockState adapt(BlockData blockData) {
        try {
            CraftBlockData cbd = (CraftBlockData)blockData;
            IBlockData ibd = cbd.getState();
            int id = net.minecraft.server.v1_13_R2.Block.REGISTRY_ID.getId((Object)ibd);
            return BlockTypes.states[this.idbToStateOrdinal[id]];
        }
        catch (NullPointerException e) {
            if (this.init()) {
                return this.adapt(blockData);
            }
            throw e;
        }
    }

    @Override
    public BlockData adapt(BlockStateHolder state) {
        BlockMaterial_1_13 material = (BlockMaterial_1_13)state.getMaterial();
        return material.getCraftBlockData();
    }

    static {
        if (!Bukkit.getServer().getClass().getName().endsWith("DummyServer")) {
            CraftServer.class.cast(Bukkit.getServer());
        }
    }
}

