package fr.porcinet.skdisplay.utils;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.VariableString;
import ch.njol.skript.variables.Variables;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.apache.commons.codec.binary.Base64;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.SkullMeta;

import javax.net.ssl.HttpsURLConnection;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Arrays;
import java.util.Locale;
import java.util.UUID;

import static fr.porcinet.skdisplay.SkDisplay.skinCache;

public class Utils {

    public static Field VARIABLE_NAME;
    public static boolean variableNameGetterExists = Skript.methodExists(Variable.class, "getName");

    public static String cc(String text) {
        return ChatColor.translateAlternateColorCodes('&', text);
    }

    // Skript
    public static void storeInVar(VariableString name, Variable<?> varExpr, Object input, Event event) {
        if (varExpr.isList()) {
            setList(name.toString(event), event, varExpr.isLocal(), input);
        } else {
            Variables.setVariable(name.toString(event), input, event, varExpr.isLocal());
        }
    }

    public static void setList(String name, Event e, boolean local, Object... objects) {
        if (objects == null || name == null) return;

        int separatorLength = Variable.SEPARATOR.length() + 1;
        name = name.substring(0, (name.length() - separatorLength));
        name = name.toLowerCase(Locale.ENGLISH) + Variable.SEPARATOR;
        Variables.setVariable(name + "*", null, e, local);
        for (int i = 0; i < objects.length; i++)
            Variables.setVariable(name + (i + 1), objects[i], e, local);
    }

    public static VariableString getVariableName(Variable<?> var) {
        if (variableNameGetterExists) {
            return var.getName();
        } else {
            try {
                return (VariableString) VARIABLE_NAME.get(var);
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    // Custom NBT Head
    public static ItemStack getSkull(String url, String name, String[] lore) {
        ItemStack skull = new ItemStack(Material.SKULL_ITEM, 1, (short) 3);
        if (url == null || url.isEmpty())
            return skull;
        SkullMeta skullMeta = (SkullMeta) skull.getItemMeta();
        GameProfile profile = new GameProfile(UUID.randomUUID(), null);
        byte[] encodedData = Base64.encodeBase64(String.format("{textures:{SKIN:{url:\"%s\"}}}", url).getBytes());
        profile.getProperties().put("textures", new Property("textures", new String(encodedData)));
        Field profileField = null;
        try {
            profileField = skullMeta.getClass().getDeclaredField("profile");
        } catch (NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
        profileField.setAccessible(true);
        try {
            profileField.set(skullMeta, profile);
        } catch (IllegalArgumentException | IllegalAccessException e) {
            e.printStackTrace();
        }
        skullMeta.setDisplayName(name);
        skullMeta.setLore(Arrays.asList(lore));
        skull.setItemMeta(skullMeta);
        return skull;
    }

    // Send JSON
    public static TextComponent sendJSON(String text, String url, String hover) {
        TextComponent json = new TextComponent();
        json.setText(text);
        json.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, url));
        json.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(hover).create()));
        return json;
    }

    // Get Yaml
    public static String getYaml(String file, String yml_path) {
        File fichier = new File(file);
        FileConfiguration config = YamlConfiguration.loadConfiguration(fichier);
        return config.getString(yml_path);
    }

    // Get Skin => 1_8_R2 and up (not 1_8_R1)
    public static void getSkin(String uuid, GameProfile gameProfile) {
        if (skinCache.containsKey(uuid)) {
            gameProfile.getProperties().put("textures", skinCache.get(uuid));
        } else {
            try {
                HttpsURLConnection connection = (HttpsURLConnection) new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid + "?unsigned=false").openConnection();
                String reply = new BufferedReader(new InputStreamReader(connection.getInputStream())).readLine();

                if(reply == null) { return; };

                JsonObject json = new JsonParser().parse(reply).getAsJsonObject();
                JsonObject path = json.getAsJsonArray("properties").get(0).getAsJsonObject();

                String value = path.get("value").getAsString();
                String signature = path.get("signature").getAsString();

                Property property = new Property("textures", value, signature);

                if(gameProfile.getProperties().containsKey("texture")) {
                    gameProfile.getProperties().remove("textures", gameProfile.getProperties().get("textures").iterator().next());
                }
                gameProfile.getProperties().put("textures", property);

                skinCache.put(uuid, property);

            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

}
