package fr.porcinet.skdisplay.nms.V_1_8_R1;

import javax.net.ssl.HttpsURLConnection;

import org.bukkit.craftbukkit.libs.com.google.gson.JsonObject;
import org.bukkit.craftbukkit.libs.com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import fr.porcinet.skdisplay.interfaces.ResetPlayerSkin;
import net.minecraft.server.v1_8_R1.EntityPlayer;
import net.minecraft.server.v1_8_R1.EnumPlayerInfoAction;
import net.minecraft.server.v1_8_R1.PacketPlayOutPlayerInfo;
import net.minecraft.server.v1_8_R1.PacketPlayOutRespawn;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_8_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;

import static fr.porcinet.skdisplay.SkDisplay.plugin;
import static fr.porcinet.skdisplay.SkDisplay.skinCache;

public class EffResetPlayerSkin_1_8_R1 implements ResetPlayerSkin {

    public void EffResetPlayerSkin(Player p) {

        for(Player pl : Bukkit.getOnlinePlayers()) {
            if(pl != p) {
                pl.hidePlayer(p);
            }
        }

        // Get player's handle
        EntityPlayer ep = ((CraftPlayer) p).getHandle();
        String uuid = p.getUniqueId().toString().replaceAll("-", "");

        // Reset the player's skin
        try {
            if (skinCache.containsKey(uuid)) {
                ep.getProfile().getProperties().put("textures", skinCache.get(uuid));
            } else {
                HttpsURLConnection connection_texture = (HttpsURLConnection) new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid + "?unsigned=false").openConnection();
                String reply_texture = new BufferedReader(new InputStreamReader(connection_texture.getInputStream())).readLine();
                JsonObject json_texture = new JsonParser().parse(reply_texture).getAsJsonObject();
                JsonObject path = json_texture.getAsJsonArray("properties").get(0).getAsJsonObject();

                String value = path.get("value").getAsString();
                String signature = path.get("signature").getAsString();

                Property prop = new Property("textures", value, signature);

                ep.getProfile().getProperties().remove("textures", ep.getProfile().getProperties().get("textures").iterator().next());
                ep.getProfile().getProperties().put("textures", prop);

                skinCache.put(uuid, prop);
            }
        } catch (IOException e) {
            e.printStackTrace();
        }

        // Update the player
        Location loc = p.getLocation();

        ep.playerConnection.sendPacket(new PacketPlayOutPlayerInfo(EnumPlayerInfoAction.REMOVE_PLAYER, ep));
        ep.playerConnection.sendPacket(new PacketPlayOutPlayerInfo(EnumPlayerInfoAction.ADD_PLAYER, ep));

        new BukkitRunnable() {
            public void run() {
                p.teleport(loc);
                ep.playerConnection.sendPacket(new PacketPlayOutRespawn(ep.dimension, ep.getWorld().getDifficulty(), ep.getWorld().getWorldData().getType(), ep.playerInteractManager.getGameMode()));
                p.teleport(loc);
                p.updateInventory();
            }
        }.runTaskLater(plugin, 2L);

        // Update all players
        for(Player pl : Bukkit.getOnlinePlayers()) {
            if (pl != p) {
                pl.showPlayer(p);
            }
        }

    }

}
