package fr.porcinet.skdisplay.nms.V_1_12_R1;

import fr.porcinet.skdisplay.interfaces.ResetPlayerSkin;
import fr.porcinet.skdisplay.utils.Utils;
import net.minecraft.server.v1_12_R1.EntityPlayer;
import net.minecraft.server.v1_12_R1.PacketPlayOutPlayerInfo;
import net.minecraft.server.v1_12_R1.PacketPlayOutRespawn;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

import static fr.porcinet.skdisplay.SkDisplay.plugin;

public class EffResetPlayerSkin_1_12_R1 implements ResetPlayerSkin {

    public void EffResetPlayerSkin(Player p) {

        // Hide the player for all players
        for(Player pl : Bukkit.getOnlinePlayers()) {
            if(pl != p) {
                pl.hidePlayer(p);
            }
        }

        // Get player's handle
        EntityPlayer ep = ((CraftPlayer) p).getHandle();
        String uuid = p.getUniqueId().toString().replaceAll("-", "");

        // Set player's skin
        Utils.getSkin(uuid, ep.getProfile());

        // Update the player
        Location loc = p.getLocation();

        ep.playerConnection.sendPacket(new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.REMOVE_PLAYER, ep));
        ep.playerConnection.sendPacket(new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER, ep));

        new BukkitRunnable() {
            public void run() {
                ep.playerConnection.sendPacket(new PacketPlayOutRespawn(ep.dimension, ep.getWorld().getDifficulty(), ep.getWorld().getWorldData().getType(), ep.playerInteractManager.getGameMode()));
                p.teleport(loc);
                p.updateInventory();
            }
        }.runTaskLater(plugin, 2L);

        // Update all players
        for(Player pl : Bukkit.getOnlinePlayers()) {
            if (pl != p) {
                pl.showPlayer(p);
            }
        }

    }

}
