package fr.porcinet.skdisplay.effects.skin;

import javax.annotation.Nullable;

import fr.porcinet.skdisplay.interfaces.SetPlayerSkin;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser.ParseResult;
import ch.njol.util.Kleenean;

import fr.porcinet.skdisplay.nms.V_1_8_R1.EffSetPlayerSkin_1_8_R1;
import fr.porcinet.skdisplay.nms.V_1_8_R2.EffSetPlayerSkin_1_8_R2;
import fr.porcinet.skdisplay.nms.V_1_8_R3.EffSetPlayerSkin_1_8_R3;
import fr.porcinet.skdisplay.nms.V_1_9_R1.EffSetPlayerSkin_1_9_R1;
import fr.porcinet.skdisplay.nms.V_1_9_R2.EffSetPlayerSkin_1_9_R2;
import fr.porcinet.skdisplay.nms.V_1_10_R1.EffSetPlayerSkin_1_10_R1;
import fr.porcinet.skdisplay.nms.V_1_11_R1.EffSetPlayerSkin_1_11_R1;
import fr.porcinet.skdisplay.nms.V_1_12_R1.EffSetPlayerSkin_1_12_R1;

import static fr.porcinet.skdisplay.SkDisplay.version;

// Syntax
// [skdisplay] set %player%['s] skin [texture] to %string%
//  set player's skin texture to "Notch"

public class EffSetPlayerSkin extends Effect {

    private SetPlayerSkin Effect;

    private Expression<Player> player;
    private Expression<OfflinePlayer> player_texture;

    @SuppressWarnings("unchecked")
    @Override
    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean paramKleenean, ParseResult paramParseResult) {
        player = (Expression<Player>) expr[0];
        player_texture = (Expression<OfflinePlayer>) expr[1];
        return true;
    }

    @Override
    public String toString(@Nullable Event e, boolean b) {
        return "set player's skin texture to (\"Notch\" parsed as offline player)";
    }

    @Override
    protected void execute(Event e) {

        Player p = player.getSingle(e);
        OfflinePlayer p_t = player_texture.getSingle(e);

        if (version.equals("v1_8_R1")) {
            Effect = new EffSetPlayerSkin_1_8_R1();
        } else if (version.equals("v1_8_R2")) {
            Effect = new EffSetPlayerSkin_1_8_R2();
        } else if (version.equals("v1_8_R3")) {
            Effect = new EffSetPlayerSkin_1_8_R3();
        } else if (version.equals("v1_9_R1")) {
            Effect = new EffSetPlayerSkin_1_9_R1();
        } else if (version.equals("v1_9_R2")) {
            Effect = new EffSetPlayerSkin_1_9_R2();
        } else if (version.equals("v1_10_R1")) {
            Effect = new EffSetPlayerSkin_1_10_R1();
        } else if (version.equals("v1_11_R1")) {
            Effect = new EffSetPlayerSkin_1_11_R1();
        } else if (version.equals("v1_12_R1")) {
            Effect = new EffSetPlayerSkin_1_12_R1();
        }

        Effect.EffSetPlayerSkin(p, p_t);

    }

}
