package fr.porcinet.skdisplay.effects.skin;

import javax.annotation.Nullable;

import fr.porcinet.skdisplay.interfaces.ResetPlayerSkin;
import fr.porcinet.skdisplay.nms.V_1_10_R1.EffResetPlayerSkin_1_10_R1;
import fr.porcinet.skdisplay.nms.V_1_11_R1.EffResetPlayerSkin_1_11_R1;
import fr.porcinet.skdisplay.nms.V_1_12_R1.EffResetPlayerSkin_1_12_R1;
import fr.porcinet.skdisplay.nms.V_1_8_R1.EffResetPlayerSkin_1_8_R1;
import fr.porcinet.skdisplay.nms.V_1_8_R2.EffResetPlayerSkin_1_8_R2;
import fr.porcinet.skdisplay.nms.V_1_8_R3.EffResetPlayerSkin_1_8_R3;
import fr.porcinet.skdisplay.nms.V_1_9_R1.EffResetPlayerSkin_1_9_R1;
import fr.porcinet.skdisplay.nms.V_1_9_R2.EffResetPlayerSkin_1_9_R2;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser.ParseResult;
import ch.njol.util.Kleenean;

import static fr.porcinet.skdisplay.SkDisplay.version;

// Syntax
// [skdisplay] reset %player%['s] skin [texture]
//  reset player's skin texture

public class EffResetPlayerSkin extends Effect {

    private ResetPlayerSkin Effect;

    private Expression<Player> player;

    @SuppressWarnings("unchecked")
    @Override
    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean paramKleenean, ParseResult paramParseResult) {
        player = (Expression<Player>) expr[0];
        return true;
    }

    @Override
    public String toString(@Nullable Event e, boolean b) {
        return "reset player's skin texture";
    }

    @SuppressWarnings("deprecation")
    @Override
    protected void execute(Event e) {

        Player p = player.getSingle(e);

        if (version.equals("v1_8_R1")) {
            Effect = new EffResetPlayerSkin_1_8_R1();
        } else if (version.equals("v1_8_R2")) {
            Effect = new EffResetPlayerSkin_1_8_R2();
        } else if (version.equals("v1_8_R3")) {
            Effect = new EffResetPlayerSkin_1_8_R3();
        } else if (version.equals("v1_9_R1")) {
            Effect = new EffResetPlayerSkin_1_9_R1();
        } else if (version.equals("v1_9_R2")) {
            Effect = new EffResetPlayerSkin_1_9_R2();
        } else if (version.equals("v1_10_R1")) {
            Effect = new EffResetPlayerSkin_1_10_R1();
        } else if (version.equals("v1_11_R1")) {
            Effect = new EffResetPlayerSkin_1_11_R1();
        } else if (version.equals("v1_12_R1")) {
            Effect = new EffResetPlayerSkin_1_12_R1();
        }

        Effect.EffResetPlayerSkin(p);

    }

}
