package fr.porcinet.skdisplay.effects.scoreboard;

import javax.annotation.Nullable;

import org.bukkit.entity.Player;
import org.bukkit.event.Event;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser.ParseResult;
import ch.njol.util.Kleenean;

import static fr.porcinet.skdisplay.effects.scoreboard.EffCreateScoreboard.*;

// Syntax
// [skdisplay] (set|update|modify|edit) score[board] (title|named) to %string% for %player%
// edit scoreboard title to "Hello world"

public class EffSetTitleScoreboard extends Effect {

	private Expression<String> title;
	private Expression<Player> player;

	@SuppressWarnings("unchecked")
	@Override
	public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean paramKleenean, ParseResult paramParseResult) {
		title = (Expression<String>) expr[0];
		player = (Expression<Player>) expr[1];
		return true;
	}

	@Override
	public String toString(@Nullable Event e, boolean b) {
		return "edit scoreboard title to \"Hello universe\"";
	}

	@Override
	protected void execute(Event e) {

		String t = title.getSingle(e);
		Player p = player.getSingle(e);

		if(boards.containsKey(p)){
		    scoreboard.setObjectiveName(t);
		}

	}

}
