package fr.porcinet.skdisplay.effects.scoreboard;

import javax.annotation.Nullable;

import org.bukkit.entity.Player;
import org.bukkit.event.Event;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser.ParseResult;
import ch.njol.util.Kleenean;

import static fr.porcinet.skdisplay.effects.scoreboard.EffCreateScoreboard.*;

// Syntax
// [skdisplay] (remove|delete) score[board] line %integer% for %player%
// delete scoreboard line 2 for player

public class EffRemoveLineScoreboard extends Effect {

	private Expression<Integer> line;
	private Expression<Player> player;

	@SuppressWarnings("unchecked")
	@Override
	public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean paramKleenean, ParseResult paramParseResult) {
		line = (Expression<Integer>) expr[0];
		player = (Expression<Player>) expr[1];
		return true;
	}

	@Override
	public String toString(@Nullable Event e, boolean b) {
		return "delete scoreboard line 2 for player";
	}

	@Override
	protected void execute(Event e) {

		Player p = player.getSingle(e);
		Integer l = line.getSingle(e);

		if(boards.containsKey(p)){
		    scoreboard.removeLine(l);
		}

	}

}
