package fr.porcinet.skdisplay.effects.scoreboard;

import javax.annotation.Nullable;

import org.bukkit.entity.Player;
import org.bukkit.event.Event;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser.ParseResult;
import ch.njol.util.Kleenean;

import static fr.porcinet.skdisplay.effects.scoreboard.EffCreateScoreboard.*;

// Syntax
// [skdisplay] (destroy|remove) score[board] of %player%
// destroy scoreboard of player

public class EffDestroyScoreboad extends Effect {

	private Expression<Player> player;

	@SuppressWarnings("unchecked")
	@Override
	public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean paramKleenean, ParseResult paramParseResult) {
		player = (Expression<Player>) expr[0];
		return true;
	}

	@Override
	public String toString(@Nullable Event e, boolean b) {
		return "destroy scoreboard of player";
	}

	@Override
	protected void execute(Event e) {

		Player p = player.getSingle(e);

		if(boards.containsKey(p)){
		    boards.get(p).destroy();
		}

	}

}
