package fr.porcinet.skdisplay.effects.scoreboard;

import java.util.HashMap;
import java.util.Map;

import javax.annotation.Nullable;

import fr.porcinet.skdisplay.interfaces.ScoreboardSign;
import fr.porcinet.skdisplay.nms.V_1_10_R1.ScoreboardSign_1_10_R1;
import fr.porcinet.skdisplay.nms.V_1_11_R1.ScoreboardSign_1_11_R1;
import fr.porcinet.skdisplay.nms.V_1_12_R1.ScoreboardSign_1_12_R1;
import fr.porcinet.skdisplay.nms.V_1_8_R2.ScoreboardSign_1_8_R2;
import fr.porcinet.skdisplay.nms.V_1_8_R3.ScoreboardSign_1_8_R3;
import fr.porcinet.skdisplay.nms.V_1_9_R1.ScoreboardSign_1_9_R1;
import fr.porcinet.skdisplay.nms.V_1_9_R2.ScoreboardSign_1_9_R2;
import fr.porcinet.skdisplay.nms.V_1_8_R1.ScoreboardSign_1_8_R1;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser.ParseResult;
import ch.njol.util.Kleenean;

import static fr.porcinet.skdisplay.SkDisplay.version;

// Syntax
// [skdisplay] create score[board] (named|titled) %string% for %player%
// create scoreboard named "Salut!" for player

public class EffCreateScoreboard extends Effect {

    public static ScoreboardSign scoreboard;
    public static Map<Player, ScoreboardSign> boards = new HashMap<>();

	private Expression<Player> player;
	private Expression<String> title;

	@SuppressWarnings("unchecked")
	@Override
	public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean paramKleenean, ParseResult paramParseResult) {
		title = (Expression<String>) expr[0];
		player = (Expression<Player>) expr[1];
		return true;
	}

	@Override
	public String toString(@Nullable Event e, boolean b) {
		return "create scoreboard named \"Hello world\" for player";
	}

	@Override
	protected void execute(Event e) {

		Player p = player.getSingle(e);
		String t = title.getSingle(e);

		if (version.equals("v1_8_R1")) {
            scoreboard = new ScoreboardSign_1_8_R1(p.getUniqueId(), t, ScoreboardSign_1_8_R1.ScoreboardSlot.SIDEBAR);
        } else if (version.equals("v1_8_R2")) {
            scoreboard = new ScoreboardSign_1_8_R2(p, t);
        } else if (version.equals("v1_8_R3")) {
            scoreboard = new ScoreboardSign_1_8_R3(p, t);
        } else if (version.equals("v1_9_R1")) {
            scoreboard = new ScoreboardSign_1_9_R1(p, t);
        } else if (version.equals("v1_9_R2")) {
            scoreboard = new ScoreboardSign_1_9_R2(p, t);
        } else if (version.equals("v1_10_R1")) {
            scoreboard = new ScoreboardSign_1_10_R1(p, t);
        } else if (version.equals("v1_11_R1")) {
            scoreboard = new ScoreboardSign_1_11_R1(p, t);
        } else if (version.equals("v1_12_R1")) {
            scoreboard = new ScoreboardSign_1_12_R1(p, t);
        }

        scoreboard.create();
        boards.put(p, scoreboard);

	}

}