package fr.porcinet.skdisplay.effects.scoreboard;

import javax.annotation.Nullable;

import org.bukkit.entity.Player;
import org.bukkit.event.Event;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser.ParseResult;
import ch.njol.util.Kleenean;

import static fr.porcinet.skdisplay.SkDisplay.version;
import static fr.porcinet.skdisplay.effects.scoreboard.EffCreateScoreboard.*;

// Syntax
// [skdisplay] set [score][board] [line] %integer% to %string% for %player%
// set scoreboard line 1 to "Hello" for player

public class EffAddLineScoreboard extends Effect {

	private Expression<Integer> line;
	private Expression<String> text;
	private Expression<Player> player;

	@SuppressWarnings("unchecked")
	@Override
	public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean paramKleenean, ParseResult paramParseResult) {
		line = (Expression<Integer>) expr[0];
		text = (Expression<String>) expr[1];
		player = (Expression<Player>) expr[2];
		return true;
	}

	@Override
	public String toString(@Nullable Event e, boolean b) {
		return "set scoreboard line 1 to \"Hello\"";
	}

	@Override
	protected void execute(Event e) {

		Player p = player.getSingle(e);
		Integer l = line.getSingle(e);
		String t = text.getSingle(e);

        if(boards.containsKey(p)){
            scoreboard.setLine(l, t);
        }

	}

}