package fr.porcinet.skdisplay.effects;

import ch.njol.skript.lang.Variable;
import ch.njol.skript.lang.VariableString;
import fr.porcinet.skdisplay.utils.Utils;
import org.bukkit.Location;
import org.bukkit.event.Event;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser.ParseResult;
import ch.njol.util.Kleenean;

import javax.annotation.Nullable;

public class EffSpawnNpc extends Effect {

    private Expression<Location> location;
    private Expression<String> name;

    private Variable<?> varExpr;
    private VariableString varName;

    @SuppressWarnings("unchecked")
    @Override
    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, ParseResult parser) {
        name = (Expression<String>) e[0];
        location = (Expression<Location>) e[1];

        if (e[2] instanceof Variable) {
            varExpr = (Variable<?>) e[2];
            varName = Utils.getVariableName(varExpr);
        }

        return true;
    }

    @Override
    public String toString(@Nullable Event paramEvent, boolean paramBoolean) {
        return "(create|spawn|register) [a] npc named %string% at %location% [and store (it|the message) in %-objects%]";
    }

    @Override
    protected void execute(Event e) {
        if (varExpr != null) {
            Utils.storeInVar(varName, varExpr, NpcManager.registerNpc(name.getSingle(e), location.getSingle(e)), e);
        } else {
            NpcManager.registerNpc(name.getSingle(e), location.getSingle(e));
        }
    }
}
