package fr.porcinet.skdisplay.effects;

import javax.annotation.Nullable;

import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser.ParseResult;
import ch.njol.util.Kleenean;

// Syntax
// [skdisplay] (show|send) action[(-| )bar] named %string% to %player%
// send action-bar named "Hello world" to player

public class EffSendActionBar extends Effect {

    private Expression<String> text;
    private Expression<Player> player;

    @SuppressWarnings("unchecked")
    @Override
    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean paramKleenean, ParseResult paramParseResult) {
        text = (Expression<String>) expr[0];
        player = (Expression<Player>) expr[1];
        return true;
    }

    @Override
    public String toString(@Nullable Event e, boolean b) {
        return "send action-bar named \"Hello world\" to player";
    }

    @SuppressWarnings("deprecation")
    @Override
    protected void execute(Event e) {

        String t = text.getSingle(e);
        Player p = player.getSingle(e);

        p.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText(t));
        // p.sendTitle("Hello", "World", 20, 40, 20);

    }

}
