package fr.porcinet.skdisplay.effects;

import fr.porcinet.skdisplay.types.Npc;
import fr.porcinet.skdisplay.utils.ReflectionUtil;
import net.minecraft.server.v1_12_R1.*;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser.ParseResult;
import ch.njol.util.Kleenean;

import javax.annotation.Nullable;

// add effect to %npc% for %player%

public class EffEffectNpc extends Effect {

    private Expression<Npc> npc;
    private Expression<Player> player;

    @SuppressWarnings("unchecked")
    @Override
    public boolean init(Expression<?>[] e, int matchedPattern, Kleenean isDelayed, ParseResult parser) {
        npc = (Expression<Npc>) e[0];
        player = (Expression<Player>) e[1];

        return true;
    }

    @Override
    public String toString(@Nullable Event paramEvent, boolean paramBoolean) {
        return "add effect to %npc%";
    }

    @Override
    protected void execute(Event e) {
        EntityPlayer ep = (EntityPlayer) npc.getSingle(e).getEntity();
        DataWatcher watcher = ep.getDataWatcher();
        watcher.set(new DataWatcherObject<>(0, DataWatcherRegistry.a), (byte) 0x20);

        // NpcManager.unregister(npc.getSingle(e));
        // NpcManager.update(npc.getSingle(e));

        try {
            ReflectionUtil.sendPacket(player.getSingle(e), new PacketPlayOutEntityMetadata(npc.getSingle(e).getID(), watcher, false));
        } catch (NoSuchMethodException e1) {
            e1.printStackTrace();
        }
    }
}
