package fr.porcinet.skdisplay.effects;

import javax.annotation.Nullable;

import fr.porcinet.skdisplay.interfaces.AddHoverCooldown;
import fr.porcinet.skdisplay.types.Npc;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

import ch.njol.skript.util.Timespan;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser.ParseResult;
import ch.njol.util.Kleenean;

import fr.porcinet.skdisplay.nms.V_1_9_R1.EffAddHoverCooldown_1_9_R1;
import fr.porcinet.skdisplay.nms.V_1_9_R2.EffAddHoverCooldown_1_9_R2;
import fr.porcinet.skdisplay.nms.V_1_10_R1.EffAddHoverCooldown_1_10_R1;
import fr.porcinet.skdisplay.nms.V_1_11_R1.EffAddHoverCooldown_1_11_R1;
import fr.porcinet.skdisplay.nms.V_1_12_R1.EffAddHoverCooldown_1_12_R1;
import org.bukkit.inventory.ItemStack;

import static fr.porcinet.skdisplay.SkDisplay.version;

// Syntax
// [skdisplay] (add|set) [hover] cooldown to %itemstack% for %timespan% for %player%
// add hover cooldown to event-item for 2 seconds for player

public class EffAddHoverCooldown extends Effect {

    private AddHoverCooldown Effect;

    private Expression<ItemStack> item;
    private Expression<Timespan> time;
    private Expression<Player> player;

    @SuppressWarnings("unchecked")
    @Override
    public boolean init(Expression<?>[] expr, int matchedPattern, Kleenean paramKleenean, ParseResult paramParseResult) {
        item = (Expression<ItemStack>) expr[0];
        time = (Expression<Timespan>) expr[1];
        player = (Expression<Player>) expr[2];
        return true;
    }

    @Override
    public String toString(@Nullable Event e, boolean b) {
        return "add hover cooldown to event-item for 2 seconds for player";
    }

    @SuppressWarnings("deprecation")
    @Override
    protected void execute(Event e) {

        Player p = player.getSingle(e);
        Integer t = time.getSingle(e).getTicks();
        ItemStack i = item.getSingle(e);

        if (version.equals("v1_9_R1")) {
            Effect = new EffAddHoverCooldown_1_9_R1();
        } else if (version.equals("v1_9_R2")) {
            Effect = new EffAddHoverCooldown_1_9_R2();
        } else if (version.equals("v1_10_R1")) {
            Effect = new EffAddHoverCooldown_1_10_R1();
        } else if (version.equals("v1_11_R1")) {
            Effect = new EffAddHoverCooldown_1_11_R1();
        } else if (version.equals("v1_12_R1")) {
            Effect = new EffAddHoverCooldown_1_12_R1();
        }

        Effect.EffAddHoverCooldown(p, t, i);

    }

}
