package fr.porcinet.skdisplay.commands;

import java.util.Arrays;
import java.util.List;

import fr.porcinet.skdisplay.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.PluginDescriptionFile;

import static fr.porcinet.skdisplay.SkDisplay.plugin;

public class CmdSkDisplay implements CommandExecutor {

	@SuppressWarnings("deprecation")
	@Override
	public boolean onCommand(CommandSender sender, Command cmd, String msg, String[] args) {

		if(sender instanceof Player) {
			Player player = (Player) sender;

			Inventory inv = Bukkit.createInventory(null, 27, "§8SkDisplay Infos");
			PluginDescriptionFile config = plugin.getDescription();

			ItemStack skull = new ItemStack(Material.SKULL_ITEM, 1, (byte)3);
			SkullMeta meta = (SkullMeta) skull.getItemMeta();
			meta.setOwner("XC2DN");
			meta.setDisplayName("§bXC2DN - Porcinet");
			meta.setLore(Arrays.asList("§c", "§7Créateur de l'addon"));
			skull.setItemMeta(meta);

			// Infos plugin.yml

			String version = config.getVersion();
			String desc = config.getDescription();
			String name = config.getName();
			List<String> author = config.getAuthors();

			inv.setItem(0, skull);
			inv.setItem(11, Utils.getSkull("http://textures.minecraft.net/texture/26e27da12819a8b053da0cc2b62dec4cda91de6eeec21ccf3bfe6dd8d4436a7", "§cGitHub", new String[] {"§c", "§7Découvre son GitHub"}));
			inv.setItem(12, Utils.getSkull("http://textures.minecraft.net/texture/7873c12bffb5251a0b88d5ae75c7247cb39a75ff1a81cbe4c8a39b311ddeda", "§cDiscord", new String[] {"§c", "§7Découvre son Discord"}));
			inv.setItem(13, Utils.getSkull("http://textures.minecraft.net/texture/ef4229149025fd2ac2cac53a4852cb7e95087e26089834433835397d5b3ce15", "§cWebsite", new String[] {"§c", "§7Découvre son site web"}));
			inv.setItem(15, Utils.getSkull("http://textures.minecraft.net/texture/e825419e429afc040c9e68b10523b917d7b8087d63e7648b10807da8b768ee", "§cInformations", new String[] {"§1", "§7Nom: §f" + name , "§2", "§7Créateur: §f" + author.get(0) , "§c", "§7Version: §f" + version, "§2", "§7Description: §f" + desc}));

			player.openInventory(inv);
			player.updateInventory();

		} else {
			sender.sendMessage("§cErreur: Seul un joueur peux executer cette commande.");
		}
		return false;
	}

}
