package fr.porcinet.skdisplay;

import fr.porcinet.skdisplay.effects.NpcManager;
import fr.porcinet.skdisplay.utils.Utils;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

import static fr.porcinet.skdisplay.SkDisplay.plugin;

public class SkDisplayListeners implements Listener {

	@EventHandler
	public void onChat(AsyncPlayerChatEvent event) {
		String msg = event.getMessage();
		Player player = event.getPlayer();

		if(msg.startsWith("LimeGlass")) {
			NpcManager.registerNpc(player.getName(), player.getLocation());
		}

	}

	// Inventory Click
	@EventHandler
    public void onInventoryClick(InventoryClickEvent event) {

		ItemStack item = event.getCurrentItem();
		Inventory inv = event.getInventory();
		Player player = (Player) event.getWhoClicked(); 
		
		if(item == null) return;
		
		if(inv.getName() == "§8SkDisplay Infos" && item.getType() != Material.AIR) {
			event.setCancelled(true);
			
			if(item.getItemMeta().hasDisplayName()) {
				switch(item.getItemMeta().getDisplayName()) {
					case "§cGitHub":
						player.spigot().sendMessage(Utils.sendJSON("§7GitHub §8» §ahttps://github.com/XC2DN", "https://github.com/XC2DN", "§cOuvre son GitHub."));
						player.closeInventory();
						break;
					case "§cDiscord":
						player.spigot().sendMessage(Utils.sendJSON("§7Discord §8» §ahttps://discord.gg/mr45uQs", "https://discord.gg/mr45uQs", "§cOuvre son Discord."));
						player.closeInventory();
						break;
					case "§cWebsite":
						player.spigot().sendMessage(Utils.sendJSON("§7Website §8» §ahttps://porcinet.tk", "https://porcinet.tk", "§cOuvre son site web."));
						player.closeInventory();
						break;
					default:
						break;	
				}
			}
		}
    }

	// onCommand
	@EventHandler
	public void onCommand(PlayerCommandPreprocessEvent event) {
		
		Player player = event.getPlayer();
		String cmd = event.getMessage().toLowerCase();
		
		// Yaml
		String perm = plugin.getConfig().getString("options.skdisplay_cmd.perm");
		String perm_msg = plugin.getConfig().getString("options.skdisplay_cmd.perm_err");
		
		if(cmd.startsWith("/skdisplay")) {
			if(perm != "none") {
				if(!player.hasPermission(perm)) {
					event.setCancelled(true);
					player.sendMessage(perm_msg);
				}
			}
		}
	}
	
	// onClick
	@EventHandler
	public void onClick(PlayerInteractEvent event) {		
		
		Player player = event.getPlayer();
		Action action = event.getAction();
		ItemStack item = event.getItem();
		
		if(item != null && item.getType() == Material.COMPASS) {
			if(action == Action.RIGHT_CLICK_AIR) {
				event.setCancelled(true);
				player.performCommand("skdisplay");
			}
		}
	}
}
