package fr.porcinet.skdisplay;

import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.expressions.base.EventValueExpression;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.registrations.Classes;
import com.mojang.authlib.properties.Property;
import fr.porcinet.skdisplay.effects.EffAddHoverCooldown;
import fr.porcinet.skdisplay.effects.EffEffectNpc;
import fr.porcinet.skdisplay.effects.EffSpawnNpc;
import fr.porcinet.skdisplay.effects.skin.EffResetPlayerSkin;
import fr.porcinet.skdisplay.effects.skin.EffSetPlayerSkin;
import fr.porcinet.skdisplay.effects.scoreboard.*;
import fr.porcinet.skdisplay.types.Npc;
import net.minecraft.server.v1_12_R1.EntityPlayer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

import ch.njol.skript.Skript;
import fr.porcinet.skdisplay.commands.CmdSkDisplay;

import javax.annotation.Nullable;
import java.io.*;
import java.util.HashMap;
import java.util.Map;



public class SkDisplay extends JavaPlugin {

    // Utils
	public static SkDisplay plugin;
    public static File npc_folder;
    public static String version = Bukkit.getServer().getClass().getPackage().getName().replace(".",  ",").split(",")[3];

    // Other
    public static Map<String, Property> skinCache = new HashMap<>();

    // NPC
    public static Map<Integer, EntityPlayer> npc_list = new HashMap<>();
    public static Map<Player, Integer> npc_corpse = new HashMap<>();
    public static Map<Player, Integer> npc_client = new HashMap<>();

	@Override
	public void onEnable() {

	    // Config
	    saveDefaultConfig();
		plugin = this;
		npc_folder = new File(getDataFolder() + File.separator + "npc");

        // Fichiers config
        if(!getDataFolder().exists()) { getDataFolder().mkdir(); }
        if(!npc_folder.exists()) { npc_folder.mkdir(); }

		// Infos
        System.out.println("[SkDisplay] You're running on " + version);
		
		// Register Event
		getServer().getPluginManager().registerEvents(new SkDisplayListeners(), this);
		// getServer().getPluginManager().registerEvents(new NPC(), this);

		// Register Skript
		Skript.registerAddon(this);
		Skript.registerEffect(EffCreateScoreboard.class, "[skdisplay] create score[board] (named|titled) %string% for %player%");
		Skript.registerEffect(EffAddLineScoreboard.class, "[skdisplay] set score[board] [line] %integer% to %string% for %player%");
		Skript.registerEffect(EffDestroyScoreboad.class, "[skdisplay] (destroy|remove) score[board] of %player%");
		Skript.registerEffect(EffSetTitleScoreboard.class, "[skdisplay] (set|update|modify|edit) score[board] (title|named) to %string% for %player%");
		Skript.registerEffect(EffRemoveLineScoreboard.class, "[skdisplay] (remove|delete) score[board] line %integer% for %player%");
		Skript.registerEffect(EffSetPlayerSkin.class, "[skdisplay] set %player%['s] skin [texture] to %offlineplayer%");
		Skript.registerEffect(EffResetPlayerSkin.class, "[skdisplay] reset %player%['s] skin [texture]");
		// Skript.registerEffect(EffSendActionBar.class, "[skdisplay] (show|send) action[(-| )bar] named %string% to %player%");

        Skript.registerEffect(EffSpawnNpc.class, "(create|spawn|register) [a] npc named %string% at %location% [and store (it|the message) in %-objects%]");
        Skript.registerEffect(EffEffectNpc.class, "add effect to %npc% for %player%");

        types();

        // 1.8 Version => v1_8_RX
		if (!version.equals("v1_8_R1") || !version.equals("v1_8_R2") || !version.equals("v1_8_R3")) {
			Skript.registerEffect(EffAddHoverCooldown.class, "[skdisplay] (add|set) [hover] cooldown to %itemstack% for %timespan% for %player%");
		}
		
		// Register Command
		getCommand("skdisplay").setExecutor(new CmdSkDisplay());

		// NPC List
        try {
            FileInputStream fileIn = new FileInputStream(npc_folder + File.separator + "npc_list.txt");
            ObjectInputStream ois = new ObjectInputStream(fileIn);
            npc_list = (HashMap) ois.readObject();
            ois.close();
            fileIn.close();
        } catch (IOException | ClassNotFoundException e) {
            e.printStackTrace();
        }

	}

	@Override
    public void onDisable() {

        try {
            FileOutputStream fileOut = new FileOutputStream( npc_folder + File.separator + "npc_list.txt");
            ObjectOutputStream out = new ObjectOutputStream(fileOut);
            out.writeObject(npc_list);
            out.close();
            fileOut.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void types() {
        String codeName = "npc";
        if (Classes.getClassInfoNoError(codeName) != null) {
            codeName = "npctype";
        }
        Classes.registerClass(new ClassInfo<Npc>(Npc.class, codeName)
                .user("npc(s)?")
                .name("Npc")
                .description("An type that represents the Npc class within Skript.")
                .defaultExpression(new EventValueExpression<Npc>(Npc.class))
                .parser(new Parser<Npc>() {
                    @Nullable
                    public Npc parse(final String s, final ParseContext context) {
                        return null;
                    }

                    @Override
                    public String toVariableNameString(final Npc npc) {
                        return npc.getEntity().toString();
                    }

                    @Override
                    public String getVariableNamePattern() {
                        return ".+";
                    }

                    @Override
                    public String toString(final Npc npc, final int flags) {
                        return npc.toString();
                    }
                }));
    }


	
}
